/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuPlus;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuPlusGroup;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuSizeRef;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;

@Handles(domainClass=InventoryAddGroup.class, exportClass=PosMenuPlusGroup.class)
public class MenuPlusGroupHandler
extends PropertyHandler<InventoryAddGroup, PosMenuPlusGroup> {
    protected MenuPlusGroupHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(InventoryAddGroup.class, PosMenuPlusGroup.class, null, integrationContext);
    }

    @Override
    public PosMenuPlusGroup createAndPopulate(InventoryAddGroup domainObj, ObjectFactory objectFactory) throws ExportException {
        PosMenuPlusGroup plusGroup = objectFactory.createPosMenuPlusGroup();
        this.exportProperties(domainObj, (PropertiedEntity)plusGroup, objectFactory);
        this.exportAdds(plusGroup, domainObj, objectFactory);
        plusGroup.setSize(this.convertToExport(domainObj.getSize(), PosMenuSizeRef.class, objectFactory));
        return plusGroup;
    }

    protected void exportAdds(PosMenuPlusGroup group, InventoryAddGroup domainObj, ObjectFactory objectFactory) {
        this.exportList(group.getPluses(), domainObj.getModifications(), InventoryAdd.class, PosMenuPlus.class, objectFactory);
    }

    @Override
    public InventoryAddGroup importElement(PosMenuPlusGroup element, PersistentObject parent) throws UnmarshalException {
        InventoryAddGroup group = (InventoryAddGroup)this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(group, element);
        if (!group.isPersistent() && "DELETED".equals(group.getSystemState())) {
            return null;
        }
        this.alreadyAssignedMap.put(element.getID(), group);
        this.getIntegrationContext().addObject(InventoryAddGroup.class, group);
        this.getIntegrationContext().setCurrentObject(InventoryAddGroup.class, group);
        for (PosMenuPlus menuPlus : element.getPluses()) {
            group.addInventoryAdd(this.importElement((Object)menuPlus, InventoryAdd.class));
        }
        group.setSize(this.importElement((Object)element.getSize(), InventoryItemSize.class));
        if (group.getSize() == null) {
            group.setSize(InventoryItemSize.findSize("Main"));
        }
        this.getIntegrationContext().setCurrentObject(InventoryAddGroup.class, null);
        return group;
    }

    @Override
    protected InventoryAddGroup findMatching(PosMenuPlusGroup entity) throws UnmarshalException {
        if (this.alreadyAssignedMap.containsKey(entity.getID())) {
            return (InventoryAddGroup)this.alreadyAssignedMap.get(entity.getID());
        }
        InventoryItemSize size = this.importElement((Object)entity.getSize(), InventoryItemSize.class);
        if (size != null && size.isPersistent()) {
            ObjectQuery query = Query.select(InventoryAddGroup.class).equals(InventoryAddGroup.Properties.LABEL, entity.getLabel()).equals(InventoryAddGroup.Properties.SIZE, size);
            this.appendExistingWhereClause(query);
            query.orderBy(InventoryAddGroup.Properties.SYSTEM_STATE, false);
            List<InventoryAddGroup> invAddList = this.getIntegrationContext().getPersistenceDelegate().getObjectList(InventoryAddGroup.class, query.toString(), null, null);
            for (InventoryAddGroup invAdd : invAddList) {
                if (!SystemState.isActive(invAdd) || this.alreadyAssignedMap.values().contains(invAdd) || invAdd.getMasterId() != null) continue;
                this.alreadyAssignedMap.put(entity.getID(), invAdd);
                return invAdd;
            }
        }
        return (InventoryAddGroup)super.findMatching(entity);
    }
}

