/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuPlus;
import au.com.ordermate.xmlintegration.system.posdatabase.PosStockMenuUsageLink;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.misc.HOConfig;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockUsageAddLink;
import ordermate.database.stock.usagelink.StockUsageLink;
import ordermate.database.stock.usagelink.StockUsageOptionLink;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;

@Handles(domainClass=InventoryAdd.class, exportClass=PosMenuPlus.class)
public class MenuPlusHandler
extends PropertyHandler<InventoryAdd, PosMenuPlus> {
    protected MenuPlusHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(InventoryAdd.class, PosMenuPlus.class, integrationContext);
    }

    @Override
    public PosMenuPlus createAndPopulate(InventoryAdd domainObj, ObjectFactory objectFactory) throws ExportException {
        PosMenuPlus menuPlus = objectFactory.createPosMenuPlus();
        this.exportProperties(domainObj, (PropertiedEntity)menuPlus, objectFactory);
        this.exportList(menuPlus.getStockUsages(), domainObj.getStockUsageLinks(), StockUsageAddLink.class, PosStockMenuUsageLink.class, objectFactory);
        return menuPlus;
    }

    @Override
    public InventoryAdd importElement(PosMenuPlus element, PersistentObject parent) throws UnmarshalException {
        InventoryAdd add = (InventoryAdd)this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(add, element);
        if (!add.isPersistent() && "DELETED".equals(add.getSystemState())) {
            return null;
        }
        add.clearStockUsage();
        HashSet oldItems = null;
        if (add.getStockUsageLinks() != null && !add.getStockUsageLinks().isEmpty()) {
            oldItems = new HashSet();
            for (StockUsageLink stockUsageLink : add.getStockUsageLinks()) {
                try {
                    add.setStockUsage(stockUsageLink.getStockItem(), stockUsageLink.getQuantity());
                }
                catch (NullPointerException e) {
                    OrderMate.LOG.warn("Null stock item for usageLink:" + stockUsageLink.getID() + "\nOn Inventory add:" + add.getID(), (Throwable)e);
                }
            }
        }
        for (PosStockMenuUsageLink posStockMenuUsageLink : element.getStockUsages()) {
            StockUsageLink usage = this.importElement((Object)posStockMenuUsageLink, StockUsageOptionLink.class);
            if (usage != null) {
                add.setStockUsage(usage.getStockItem(), usage.getQuantity());
                if (oldItems != null) {
                    oldItems.remove(usage.getStockItem());
                }
            }
            if (oldItems == null || oldItems.isEmpty()) continue;
            for (StockItem removeUsage : oldItems) {
                try {
                    add.setStockUsage(removeUsage, null);
                }
                catch (NullPointerException e) {
                    OrderMate.LOG.warn("Null stock item for usageLink:" + posStockMenuUsageLink.getID() + "\nOn Inventory add:" + add.getID(), (Throwable)e);
                }
            }
        }
        return add;
    }

    @Override
    protected Iterable<PropertiedObject.Property> getImportableProperties(InventoryAdd domainObj) {
        Iterable<PropertiedObject.Property> props = super.getImportableProperties(domainObj);
        if (HOConfig.getInstance().isIgnorePricesOnImport() && domainObj.getID() != null) {
            Iterator<PropertiedObject.Property> it = props.iterator();
            while (it.hasNext()) {
                PropertiedObject.Property prop = it.next();
                if (!prop.equals(InventoryAdd.Properties.PRICE)) continue;
                it.remove();
            }
        }
        return props;
    }
}

