/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosBarcode;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuModificationRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuModificationType;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuOptionGroupRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuPlusGroupRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuPortionRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuSizeRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuUnit;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuUnitPriceLevel;
import au.com.ordermate.xmlintegration.system.posdatabase.PosStockMenuUsageLink;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryDefaultAdd;
import ordermate.database.inventory.InventoryDefaultMod;
import ordermate.database.inventory.InventoryDefaultOption;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;

@Handles(domainClass=InventoryItemUnit.class, exportClass=PosMenuUnit.class)
public class MenuUnitHandler
extends PropertyHandler<InventoryItemUnit, PosMenuUnit> {
    private InventoryItem parentItem;

    public MenuUnitHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(InventoryItemUnit.class, PosMenuUnit.class, integrationContext);
    }

    @Override
    public PosMenuUnit createAndPopulate(InventoryItemUnit domainObj, ObjectFactory objectFactory) throws ExportException {
        List<UnitPriceLevel> filteredList = domainObj.getPrices();
        if (this.getIntegrationContext().sizeOf(PriceLevel.class) > 0) {
            filteredList = this.filter(filteredList, UnitPriceLevel.Properties.PRICE_LEVEL, this.getIntegrationContext().getObjects(PriceLevel.class), PriceLevel.getAllPriceLevels());
        }
        if (filteredList.isEmpty()) {
            OrderMate.LOG.info("Will not export " + domainObj + " since it is not linked to any of the given price levels.");
            return null;
        }
        PosMenuUnit unit = objectFactory.createPosMenuUnit();
        this.exportProperties(domainObj, (PropertiedEntity)unit, objectFactory);
        unit.setSize(this.convertToExport(domainObj.getSize(), PosMenuSizeRef.class, objectFactory));
        unit.setPortion(this.convertToExport(domainObj.getPortion(), PosMenuPortionRef.class, objectFactory));
        unit.setPlusGroup(this.convertToExport(domainObj.getPlusGroup(), PosMenuPlusGroupRef.class, objectFactory));
        unit.setTaxCode(TaxCode.convertToString(domainObj.getTaxCodes()));
        this.exportList(unit.getOptionGroups(), domainObj.getOptionGroupLinks(), InventoryOptionGroupLink.class, PosMenuOptionGroupRef.class, objectFactory);
        this.exportList(unit.getUnitPriceLevels(), filteredList, UnitPriceLevel.class, PosMenuUnitPriceLevel.class, objectFactory);
        for (String code : domainObj.getBarcodes()) {
            PosBarcode barcode = objectFactory.createPosBarcode();
            barcode.setCode(code);
            unit.getBarcodes().add(barcode);
        }
        this.exportList(unit.getStockUsages(), domainObj.getStockLinks(), StockInventoryUsageLink.class, PosStockMenuUsageLink.class, objectFactory);
        for (InventoryDefaultMod nextMod : domainObj.getDefaultMods()) {
            PosMenuModificationRef ref = new PosMenuModificationRef();
            if (nextMod instanceof InventoryDefaultOption) {
                ref.setType(PosMenuModificationType.OPTION);
            } else if (nextMod instanceof InventoryDefaultAdd) {
                ref.setType(PosMenuModificationType.PLUS);
            } else {
                throw new IllegalStateException("Cannot export " + nextMod + " Unknown type");
            }
            ref.setDomainId(this.getIntegrationContext().getIDGenStrategy().getID((ExportableObject)((Object)nextMod.getDefaultMod())));
            ref.setMasterId(nextMod.getMasterId());
            ref.setSequence(Integer.valueOf(nextMod.getSequence()));
            unit.getDefaultMods().add(ref);
        }
        return unit;
    }

    @Override
    public InventoryItemUnit importElement(PosMenuUnit element, PersistentObject parent) throws UnmarshalException {
        OrderMate.LOG.info("Importing Inventory Item Unit with parent:" + parent);
        this.parentItem = parent instanceof InventoryItem ? (InventoryItem)parent : null;
        InventoryItemUnit unit = (InventoryItemUnit)this.getExistingOrCreateNew((ExportEntityI)element);
        if (this.parentItem != null) {
            unit.setItem(this.parentItem);
        }
        this.importProperties(unit, element);
        if (!unit.isPersistent() && "DELETED".equals(unit.getSystemState())) {
            return null;
        }
        unit.setSize(this.importElement((Object)element.getSize(), InventoryItemSize.class));
        unit.setPortion(this.importElement((Object)element.getPortion(), InventoryItemPortion.class));
        if (unit.getSize() == null || unit.getPortion() == null) {
            String msg = "Could not import unit, missing size or portion : " + unit + " " + unit.getSize() + " " + unit.getPortion();
            if (Config.isDebuging()) {
                throw new IllegalStateException(msg);
            }
            OrderMate.LOG.warn(msg);
            return null;
        }
        unit.setPlusGroup(this.importElement((Object)element.getPlusGroup(), InventoryAddGroup.class));
        this.getIntegrationContext().addObject(InventoryItemPortion.class, unit.getPortion());
        List<TaxCode> taxCodes = TaxCode.convertToList(element.getTaxCode(), this.getIntegrationContext().getObjects(TaxCode.class));
        unit.setTaxCodes(taxCodes);
        ArrayList<InventoryOptionGroupLink> optionGroups = new ArrayList<InventoryOptionGroupLink>();
        for (PosMenuOptionGroupRef optionGroupRef : element.getOptionGroups()) {
            InventoryOptionGroupLink link = this.importElement(optionGroupRef, InventoryOptionGroupLink.class, unit);
            if (link == null || link.getOptionGroup() == null) continue;
            InventoryOptionGroup opGroup = link.getOptionGroup();
            if ("DELETED".equals(opGroup.getSystemState())) {
                link.setSystemState(SystemState.DELETED_STATE);
            }
            this.addIfNotNull(optionGroups, link);
        }
        unit.setOptionGroups(optionGroups);
        if (element.getDefaultMods().size() > 0) {
            for (PosMenuModificationRef nextDefault : element.getDefaultMods()) {
                InventoryDefaultMod mod = this.importElement((Object)nextDefault, InventoryDefaultMod.class);
                if (mod != null && mod.getDefaultMod() != null) {
                    InventoryDefaultMod dbMod = unit.addDefaultMod(mod);
                    if (dbMod == null) continue;
                    dbMod.setMasterId(mod.getMasterId());
                    continue;
                }
                OrderMate.LOG.warn("Cannot import default modification, does not exist. Please check master ids");
            }
        }
        for (PosMenuUnitPriceLevel unitPrice : element.getUnitPriceLevels()) {
            this.addUnitPriceLevel(unit, unitPrice);
        }
        for (PosBarcode barcode : element.getBarcodes()) {
            this.addBarcodeToUnit(barcode, unit);
        }
        if (Boolean.TRUE.equals(this.getIntegrationContext().getAttribute("StockConfigured"))) {
            StockInventoryUsageLink stockLink;
            HashSet<StockItem> stockItems = new HashSet<StockItem>();
            for (InventoryOptionGroupLink link : element.getStockUsages()) {
                stockLink = this.importElement((Object)link, StockInventoryUsageLink.class);
                if (stockLink == null) continue;
                stockItems.add(stockLink.getStockItem());
            }
            unit.retainStockUsages(stockItems);
            for (PosStockMenuUsageLink stockMenuUsageLink : element.getStockUsages()) {
                stockLink = this.importElement((Object)stockMenuUsageLink, StockInventoryUsageLink.class);
                unit.setStockUsage(stockLink.getStockItem(), stockLink.getQuantity());
                unit.setStockUsageRemovable(stockLink.getStockItem(), stockLink.isRemovable(), stockLink.getRemovePrice());
            }
        }
        return unit;
    }

    private void addUnitPriceLevel(InventoryItemUnit unit, PosMenuUnitPriceLevel unitPrice) throws UnmarshalException {
        UnitPriceLevel priceLevel = this.getHandler(UnitPriceLevel.class, PosMenuUnitPriceLevel.class).importElement(unitPrice, unit);
        if (priceLevel != null && priceLevel.getPriceLevel() != null) {
            unit.addUnitPriceLevel(priceLevel);
        } else {
            OrderMate.LOG.warn("Unit price level with the MenuUnitPriceLevel ID " + unitPrice.getID() + " is NOT imported!");
        }
    }

    @Override
    protected InventoryItemUnit findMatching(PosMenuUnit entity) throws UnmarshalException {
        if (this.alreadyAssignedMap.containsKey(entity.getID())) {
            return (InventoryItemUnit)this.alreadyAssignedMap.get(entity.getID());
        }
        InventoryItemSize size = this.importElement((Object)entity.getSize(), InventoryItemSize.class);
        InventoryItemPortion portion = this.importElement((Object)entity.getPortion(), InventoryItemPortion.class);
        if (this.parentItem != null && this.parentItem.isPersistent()) {
            if (portion == null) {
                ObjectQuery query = Query.select(InventoryItemPortion.class).equals(InventoryItemPortion.Properties.LABEL, "WHOLE");
                this.appendExistingWhereClause(query);
                portion = this.getIntegrationContext().getPersistenceDelegate().getObject(InventoryItemPortion.class, query.toString(), null, null);
            }
            List<InventoryItemUnit> unitsFound = this.getAllInventoryItemUnits(size, portion);
            for (InventoryItemUnit unit : unitsFound) {
                if (!SystemState.isActive(unit) || this.alreadyAssignedMap.containsValue(unit) || unit.getMasterId() != null) continue;
                this.alreadyAssignedMap.put(entity.getID(), unit);
                return unit;
            }
        }
        return (InventoryItemUnit)super.findMatching(entity);
    }

    private List<InventoryItemUnit> getAllInventoryItemUnits(InventoryItemSize size, InventoryItemPortion portion) {
        ArrayList<String> stateList = new ArrayList<String>();
        stateList.add("ACTIVE");
        stateList.add("INACTIVE");
        ObjectQuery query = Query.select(InventoryItemUnit.class).equals(InventoryItemUnit.Properties.ITEM, this.parentItem.getID()).equals(InventoryItemUnit.Properties.SIZE, size.getID()).equals(InventoryItemUnit.Properties.PORTION, portion.getID()).wherePropertyIn(InventoryItemUnit.Properties.SYSTEM_STATE, stateList);
        this.appendExistingWhereClause(query);
        return this.getIntegrationContext().getPersistenceDelegate().getObjectList(InventoryItemUnit.class, query.toString(), null, null);
    }

    protected void addBarcodeToUnit(PosBarcode barcode, InventoryItemUnit unit) {
        InventoryItemUnit.addUnitBarcode(barcode.getCode(), unit);
    }
}

