/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.Prop;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuUnitPriceLevel;
import au.com.ordermate.xmlintegration.system.posdatabase.PosPriceLevelRef;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.UnmarshalException;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.misc.HOConfig;
import ordermate.database.queries.inventory.UnitPriceLevelQueries;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;

@Handles(domainClass=UnitPriceLevel.class, exportClass=PosMenuUnitPriceLevel.class)
public class MenuUnitPriceLevelHandler
extends PropertyHandler<UnitPriceLevel, PosMenuUnitPriceLevel> {
    private InventoryItemUnit parentUnit;

    public MenuUnitPriceLevelHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(UnitPriceLevel.class, PosMenuUnitPriceLevel.class, integrationContext);
    }

    @Override
    public PosMenuUnitPriceLevel createAndPopulate(UnitPriceLevel domainObj, ObjectFactory objectFactory) throws ExportException {
        PosMenuUnitPriceLevel menuUnitPriceLevel = objectFactory.createPosMenuUnitPriceLevel();
        this.exportProperties(domainObj, (PropertiedEntity)menuUnitPriceLevel, objectFactory);
        menuUnitPriceLevel.setPriceLevel(this.convertToExport(domainObj.getPriceLevel(), PosPriceLevelRef.class, objectFactory));
        if (menuUnitPriceLevel.getPriceLevel() == null) {
            return null;
        }
        return menuUnitPriceLevel;
    }

    @Override
    public UnitPriceLevel importElement(PosMenuUnitPriceLevel element, PersistentObject parent) throws UnmarshalException {
        this.parentUnit = null;
        if (parent instanceof InventoryItemUnit) {
            this.parentUnit = (InventoryItemUnit)parent;
        }
        UnitPriceLevel unitPriceLevel = (UnitPriceLevel)this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(unitPriceLevel, element);
        unitPriceLevel.setPriceLevel(this.importElement((Object)element.getPriceLevel(), PriceLevel.class));
        return unitPriceLevel;
    }

    @Override
    protected UnitPriceLevel findMatching(PosMenuUnitPriceLevel entity) throws UnmarshalException {
        PriceLevel level = this.importElement((Object)entity.getPriceLevel(), PriceLevel.class);
        ObjectQuery query = UnitPriceLevelQueries.getUnitPriceLevel(this.parentUnit, level);
        this.appendExistingWhereClause(query);
        return this.getIntegrationContext().getPersistenceDelegate().getObject(UnitPriceLevel.class, query.toString(), null, null);
    }

    @Override
    protected Iterable<PropertiedObject.Property> getImportableProperties(UnitPriceLevel domainObj) {
        Iterable<PropertiedObject.Property> props = super.getImportableProperties(domainObj);
        if (HOConfig.getInstance().isIgnorePricesOnImport() && domainObj.getID() != null) {
            Iterator<PropertiedObject.Property> it = props.iterator();
            while (it.hasNext()) {
                PropertiedObject.Property prop = it.next();
                if (!prop.equals(UnitPriceLevel.Properties.PRICE)) continue;
                it.remove();
            }
        }
        return props;
    }

    @Override
    protected void filterNonImportedProps(Set<Prop> props) {
        Prop toRemove = null;
        for (Prop prop : props) {
            if (!"systemState".equals(prop.getName())) continue;
            toRemove = prop;
            break;
        }
        if (toRemove != null) {
            props.remove(toRemove);
        }
    }
}

