/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handler;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuModificationRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuModificationType;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryDefaultAdd;
import ordermate.database.inventory.InventoryDefaultMod;
import ordermate.database.inventory.InventoryDefaultOption;
import ordermate.database.inventory.InventoryOption;
import ordermate.jaxb.exporter.handlers.online.idstrategy.MasterIDStrategy;

@Handles(domainClass=InventoryDefaultMod.class, exportClass=PosMenuModificationRef.class)
public class ModificationRefHandler
implements Handler<InventoryDefaultMod, PosMenuModificationRef, ObjectFactory> {
    protected final AbstractXMLIntegrationContext<ObjectFactory> context;

    public ModificationRefHandler(AbstractXMLIntegrationContext<ObjectFactory> yourContext) {
        this.context = yourContext;
    }

    @Override
    public PosMenuModificationRef exportDomainObject(InventoryDefaultMod domainObj, ObjectFactory objectFactory) throws ExportException {
        PosMenuModificationRef ref = new PosMenuModificationRef();
        ref.setDomainId(this.context.getIDGenStrategy().getID(domainObj));
        ref.setMasterId(domainObj.getMasterId());
        if (domainObj instanceof InventoryDefaultOption) {
            ref.setType(PosMenuModificationType.OPTION);
        } else if (domainObj instanceof InventoryDefaultAdd) {
            ref.setType(PosMenuModificationType.PLUS);
        } else {
            throw new IllegalArgumentException("Unsupported menu mod:" + domainObj);
        }
        ref.setSequence(Integer.valueOf(domainObj.getSequence()));
        return ref;
    }

    @Override
    public InventoryDefaultMod importElement(PosMenuModificationRef element, PersistentObject parent) throws UnmarshalException {
        InventoryDefaultMod mod = null;
        Long id = element.getDomainId();
        if (PosMenuModificationType.OPTION.equals((Object)element.getType())) {
            InventoryOption option = this.context.getIDGenStrategy().find(InventoryOption.class, id);
            if (option != null) {
                mod = new InventoryDefaultOption();
                ((InventoryDefaultOption)mod).setOption(option);
            } else {
                OrderMate.LOG.warn("Cannot find option for id :" + id);
            }
        } else if (PosMenuModificationType.PLUS.equals((Object)element.getType())) {
            InventoryAdd add = this.context.getIDGenStrategy().find(InventoryAdd.class, id);
            if (add != null) {
                mod = new InventoryDefaultAdd();
                ((InventoryDefaultAdd)mod).setAdd(add);
            } else {
                OrderMate.LOG.warn("Cannot find plus for id :" + id);
            }
        } else {
            throw new IllegalArgumentException("Unsupported menu mod type:" + element.getType());
        }
        if (mod != null && element.getSequence() != null) {
            mod.setSequence(element.getSequence());
            if (this.context.getIDGenStrategy() instanceof MasterIDStrategy) {
                mod.setMasterId(element.getMasterId());
            }
        }
        return mod;
    }

    @Override
    public Class<? extends InventoryDefaultMod> getDomainClass() {
        return InventoryDefaultMod.class;
    }

    @Override
    public Class<PosMenuModificationRef> getElementClass() {
        return PosMenuModificationRef.class;
    }
}

