/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.Prop;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosPriceAdjustment;
import au.com.ordermate.xmlintegration.system.posdatabase.PosTriggerRef;
import javax.xml.bind.UnmarshalException;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.TriggeredPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.DeliveryPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.inventory.SimplePriceAdjustment;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;

@Handles(domainClass=InventoryPriceAdjustment.class, exportClass=PosPriceAdjustment.class)
public class PriceAdjustmentHandler
extends PropertyHandler<InventoryPriceAdjustment, PosPriceAdjustment> {
    private static final String AMOUNT = "amount";

    protected PriceAdjustmentHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(InventoryPriceAdjustment.class, PosPriceAdjustment.class, integrationContext);
    }

    @Override
    public PosPriceAdjustment createAndPopulate(InventoryPriceAdjustment domainObj, ObjectFactory objectFactory) throws ExportException {
        if (domainObj instanceof SimplePriceAdjustment || domainObj instanceof DeliveryPriceAdjustment) {
            PosPriceAdjustment element = objectFactory.createPosPriceAdjustment();
            this.exportProperties(domainObj, (PropertiedEntity)element, objectFactory);
            this.exportList(element.getTriggers(), ((TriggeredPriceAdjustment)domainObj).getTriggers(), AbstractTrigger.class, PosTriggerRef.class, objectFactory);
            return element;
        }
        return null;
    }

    @Override
    public InventoryPriceAdjustment importElement(PosPriceAdjustment element, PersistentObject parent) throws UnmarshalException {
        InventoryPriceAdjustment adj = this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(adj, element);
        if (!adj.isPersistent() && SystemState.DELETED_STATE.equals(adj.getSystemState())) {
            return null;
        }
        if (adj instanceof SimplePriceAdjustment) {
            for (PosTriggerRef trigger : element.getTriggers()) {
                AbstractTrigger posTrigger = this.importElement((Object)trigger, AbstractTrigger.class);
                if (posTrigger == null) continue;
                if (!posTrigger.isPersistent()) {
                    posTrigger.save();
                }
                ((SimplePriceAdjustment)adj).addTrigger(posTrigger);
            }
        }
        return adj;
    }

    @Override
    protected InventoryPriceAdjustment findMatching(PosPriceAdjustment entity) throws UnmarshalException {
        Prop prop = this.findProperty("type", entity.getProperties());
        if (prop.getVal().equals(PriceAdjustmentType.DELIVERY_SURCHARGE.toString())) {
            return PriceAdjustmentManager.getInstance().getDeliveryFee();
        }
        return (InventoryPriceAdjustment)super.findMatching(entity);
    }

    @Override
    protected InventoryPriceAdjustment getExistingOrCreateNew(ExportEntityI entity) throws UnmarshalException {
        InventoryPriceAdjustment domainObj = (InventoryPriceAdjustment)super.getExisting(entity, new PropertiedObject.Property(this.getDomainClass(), "masterId"));
        if (domainObj == null) {
            domainObj = this.getInventoryPriceAdjustmentByProperties((PosPriceAdjustment)entity);
        }
        if (domainObj == null) {
            domainObj = (InventoryPriceAdjustment)super.createDomainInstance((PosPriceAdjustment)entity);
        }
        return domainObj;
    }

    @Override
    protected Class<? extends InventoryPriceAdjustment> determineConcreteType(PosPriceAdjustment entity) {
        Prop prop = this.findProperty("type", entity.getProperties());
        if (prop.getVal().equals(PriceAdjustmentType.NORMAL.toString())) {
            return SimplePriceAdjustment.class;
        }
        if (prop.getVal().equals(PriceAdjustmentType.DELIVERY_SURCHARGE.toString())) {
            return DeliveryPriceAdjustment.class;
        }
        throw new IllegalArgumentException("Unsupported price adjustment type : " + prop.getVal());
    }

    public InventoryPriceAdjustment getInventoryPriceAdjustmentByProperties(PosPriceAdjustment element) {
        PriceAdjustmentDirection direction = PriceAdjustmentDirection.DISCOUNT;
        PriceAdjustmentUnit unit = PriceAdjustmentUnit.DOLLAR_UNIT;
        String label = null;
        String type = null;
        InventoryPriceAdjustment adj = null;
        for (Prop prop : element.getProperties()) {
            if (prop.getName().equals("unit")) {
                String xmlUnit = prop.getVal().toString().toLowerCase();
                if (xmlUnit.startsWith("dollar")) {
                    unit = PriceAdjustmentUnit.DOLLAR_UNIT;
                    continue;
                }
                if (xmlUnit.startsWith("perc")) {
                    unit = PriceAdjustmentUnit.PERCENTAGE_UNIT;
                    continue;
                }
                if (!xmlUnit.startsWith("flat")) continue;
                unit = PriceAdjustmentUnit.FLAT_PRICE_UNIT;
                continue;
            }
            if (prop.getName().equals("direction")) {
                if (!prop.getVal().toString().equalsIgnoreCase(PriceAdjustmentDirection.SURCHARGE.getLabel())) continue;
                direction = PriceAdjustmentDirection.SURCHARGE;
                continue;
            }
            if (prop.getName().equals("label")) {
                String value = prop.getVal();
                int index = value.indexOf("(");
                label = value;
                if (index <= 1) continue;
                label = label.substring(0, index).trim();
                continue;
            }
            if (!prop.getName().equals("type")) continue;
            type = prop.getVal().toString();
        }
        if (type != null && type.equals("NORMAL")) {
            ObjectQuery sql1 = Query.select(SimplePriceAdjustment.class).equals(SimplePriceAdjustment.Properties.UNIT, unit).equals(SimplePriceAdjustment.Properties.DIRECTION, direction).equals(SimplePriceAdjustment.Properties.TYPE, type).wherePropertyLike(SimplePriceAdjustment.Properties.LABEL, label).active(SimplePriceAdjustment.class);
            adj = PersistenceManager.getObject(SimplePriceAdjustment.class, sql1.toString());
        }
        return adj;
    }
}

