/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosPriceLevel;
import au.com.ordermate.xmlintegration.system.posdatabase.PosPriceLevelRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosTriggerRef;
import java.util.ArrayList;
import javax.xml.bind.UnmarshalException;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.jaxb.exporter.handlers.posdatabase.PosExportUtil;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;
import ordermate.jaxb.exporter.handlers.posdatabase.inventory.TriggerActivatedHelper;

@Handles(domainClass=PriceLevel.class, exportClass=PosPriceLevel.class)
public class PriceLevelHandler
extends PropertyHandler<PriceLevel, PosPriceLevel> {
    public PriceLevelHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(PriceLevel.class, PosPriceLevel.class, integrationContext);
    }

    @Override
    public PosPriceLevel createAndPopulate(PriceLevel domainObj, ObjectFactory objectFactory) throws ExportException {
        PosPriceLevel element = objectFactory.createPosPriceLevel();
        this.exportProperties(domainObj, (PropertiedEntity)element, objectFactory);
        for (AbstractTrigger trigger : domainObj.getTriggers()) {
            if (PosExportUtil.shouldIgnoreTrigger(trigger.getDiscriminatorType())) continue;
            this.addIfNotNull(element.getTriggers(), this.convertToExport(trigger, PosTriggerRef.class, objectFactory));
        }
        if (domainObj.getReferencePriceLevel() != null) {
            PosPriceLevelRef ref = objectFactory.createPosPriceLevelRef();
            ref.setDomainId(this.getIntegrationContext().getIDGenStrategy().getID(domainObj.getReferencePriceLevel()));
            element.setReferencePriceLevel(ref);
        }
        return element;
    }

    @Override
    public PriceLevel importElement(PosPriceLevel element, PersistentObject parent) throws UnmarshalException {
        PriceLevel level = (PriceLevel)this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(level, element);
        if (!level.isPersistent() && "DELETED".equals(level.getSystemState())) {
            return null;
        }
        level.save();
        level.setSystemState("ACTIVE");
        ArrayList<AbstractTrigger> newTriggers = new ArrayList<AbstractTrigger>();
        for (PosTriggerRef triggerRef : element.getTriggers()) {
            AbstractTrigger trigger = this.importElement((Object)triggerRef, AbstractTrigger.class);
            newTriggers.add(trigger);
        }
        TriggerActivatedHelper helper = new TriggerActivatedHelper(this.getIntegrationContext());
        level = (PriceLevel)helper.handleTriggers(level, newTriggers);
        this.alreadyAssignedMap.put(level.getMasterId(), level);
        if (element.getReferencePriceLevel() != null) {
            level.setReferencePriceLevel((PriceLevel)this.alreadyAssignedMap.get(element.getReferencePriceLevel().getDomainId()));
        }
        return level;
    }
}

