/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.ExportLaw;
import au.com.ordermate.integration.jaxb.Handler;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.jaxb.exporter.handlers.posdatabase.stock.RefTrackerHandlerWrapper;

public class RefHandler<D extends PersistentObject, REF, OF, E extends PropertiedEntity>
extends AbstractHandler<D, REF, OF> {
    private final RefTrackerHandlerWrapper<D, E, OF> wrappedHandler;

    @Override
    public void setExportLaw(ExportLaw theLaw) {
        super.setExportLaw(theLaw);
        if (this.wrappedHandler.getWrappedHandler() instanceof AbstractHandler) {
            ((AbstractHandler)this.wrappedHandler.getWrappedHandler()).setExportLaw(theLaw);
        }
    }

    public static <D extends PersistentObject, REF, OF, E extends PropertiedEntity> RefHandler<D, REF, OF, E> create(Class<D> domainClass, Class<REF> refClass, AbstractXMLIntegrationContext<OF> context, Handler<D, E, OF> directHandler) {
        return new RefHandler<D, REF, OF, E>(domainClass, refClass, context, directHandler);
    }

    public RefHandler(Class<D> domainClass, Class<REF> refClass, AbstractXMLIntegrationContext<OF> integrationContext, Handler<D, E, OF> directHandler) {
        super(domainClass, refClass, integrationContext);
        this.wrappedHandler = new RefTrackerHandlerWrapper<D, E, OF>(directHandler);
        integrationContext.register(this.wrappedHandler);
    }

    @Override
    public REF exportDomainObject(D domainObj, OF objectFactory) throws ExportException {
        E element = this.wrappedHandler.getElement(domainObj);
        if (element == null) {
            return null;
        }
        REF ref = this.createRef(objectFactory);
        this.setXMLRefID(ref, element);
        return ref;
    }

    protected RefTrackerHandlerWrapper<D, E, OF> getWrappedHandler() {
        return this.wrappedHandler;
    }

    @Override
    public D importElement(REF refElement, PersistentObject parent) throws UnmarshalException {
        if (refElement == null) {
            return null;
        }
        D domainObj = null;
        Object element = null;
        domainObj = this.resolveElementById(refElement);
        if (domainObj == null) {
            element = this.resolveElementByXmlRef(refElement);
            if (element.getID() == null) {
                String id = element.getXMLRefID();
                id = id.substring(id.indexOf("_") + 1);
                try {
                    Long longId = Long.valueOf(id);
                    element.setID(longId);
                }
                catch (NumberFormatException ex) {
                    OrderMate.LOG.warn("Couldn't wrangle id out of xmlRefID. You're on your own.", (Throwable)ex);
                }
            }
            domainObj = this.wrappedHandler.getDomainObj(element);
        }
        if (domainObj == null) {
            domainObj = this.wrappedHandler.importElement(element, parent);
        }
        if (domainObj == null) {
            OrderMate.LOG.warn("Could not find domain object for : " + element.getXMLRefID() + ":" + element + " expecting a " + this.getDomainClass());
        }
        return domainObj;
    }

    private void setXMLRefID(REF ref, E element) {
        if (element == null) {
            throw new IllegalArgumentException("Element should not be null");
        }
        try {
            Method method = ref.getClass().getMethod("setXMLRefID", element.getClass());
            method.invoke(ref, element);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(ref.getClass().getSimpleName() + " must contain a method setXMLRefID", nsme);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("Exception setting element on reference object : " + ref.getClass(), ite);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("setXMLRefID of class " + ref.getClass().getSimpleName() + " is not public", iae);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error setting xml ref ID for class " + ref.getClass(), ex);
        }
    }

    private REF createRef(OF objectFactory) {
        Class refClass = this.getElementClass();
        try {
            Method method = objectFactory.getClass().getMethod("create" + refClass.getSimpleName(), null);
            return (REF)refClass.cast(method.invoke(objectFactory, null));
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("Object factory must contain a method : create" + refClass.getSimpleName(), nsme);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("Exception creating new reference object : " + refClass, ite);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("create" + refClass.getSimpleName() + " is not public", iae);
        }
    }

    private D resolveElementById(REF ref) {
        try {
            Method method = ref.getClass().getMethod("getDomainId", new Class[0]);
            Long id = (Long)method.invoke(ref, new Object[0]);
            if (id != null) {
                Class domainClazz = this.getDomainClass();
                return (D)((PersistentObject)this.getIntegrationContext().getIDGenStrategy().find(domainClazz, id));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private E resolveElementByXmlRef(REF ref) {
        try {
            Method method = ref.getClass().getMethod("getXMLRefID", null);
            return (E)((PropertiedEntity)this.wrappedHandler.getElementClass().cast(method.invoke(ref, null)));
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(ref.getClass().getSimpleName() + " must contain a method getXMLRefID", nsme);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("Exception getting element on reference object : " + ref.getClass(), ite);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("getXMLRefID of class " + ref.getClass().getSimpleName() + " is not public", iae);
        }
    }
}

