/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Price;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosStockItemRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosStockMenuUsageLink;
import java.math.BigDecimal;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockLink;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.jaxb.exporter.handlers.posdatabase.converters.Converters;

@Handles(domainClass=StockLink.class, exportClass=PosStockMenuUsageLink.class)
public class StockMenuUsageLinkHandler<T extends PersistentObject>
extends AbstractHandler<T, PosStockMenuUsageLink, ObjectFactory> {
    protected StockMenuUsageLinkHandler(Class<T> newDomainClass, AbstractXMLIntegrationContext integrationContext) {
        super(newDomainClass, PosStockMenuUsageLink.class, integrationContext);
    }

    @Override
    public PosStockMenuUsageLink exportDomainObject(T domainObj, ObjectFactory objectFactory) throws ExportException {
        if (domainObj == null) {
            return null;
        }
        if (((StockLink)domainObj).getStockItem() == null) {
            OrderMate.LOG.warn("Stock item was null for " + domainObj);
            return null;
        }
        PosStockMenuUsageLink stockLink = objectFactory.createPosStockMenuUsageLink();
        String qty = Converters.getConverterFor(Quantity.class).convertToString(((StockLink)domainObj).getQuantity());
        if (qty == null || qty.isEmpty()) {
            throw new IllegalStateException("Qty should not be null for " + domainObj + "\nwith class " + domainObj.getClass().getSimpleName() + " and ID :" + ((PersistentObject)domainObj).getID());
        }
        stockLink.setQuantity(qty);
        stockLink.setStockItem(this.convertToExport(((StockLink)domainObj).getStockItem(), PosStockItemRef.class, objectFactory));
        if (domainObj instanceof StockInventoryUsageLink) {
            stockLink.setRemovable(((StockInventoryUsageLink)domainObj).isRemovable());
            Price price = ((StockInventoryUsageLink)domainObj).getRemovePrice();
            if (price != null) {
                stockLink.setRemovePrice(price.toBigDecimal());
            }
        }
        if (stockLink.getStockItem() == null) {
            OrderMate.LOG.info("Exported stock item was null for " + domainObj + " with stock item " + ((StockLink)domainObj).getStockItem() + ", stock item may be deleted but deletions not included");
            return null;
        }
        return stockLink;
    }

    @Override
    public T importElement(PosStockMenuUsageLink element, PersistentObject parent) throws UnmarshalException {
        Object stockLink = this.createDomainInstance(element);
        ((StockLink)stockLink).setQuantity((Quantity)Converters.getConverterFor(Quantity.class).convertFromString(element.getQuantity()));
        ((StockLink)stockLink).setStockItem(this.importElement((Object)element.getStockItem(), StockItem.class));
        if (stockLink instanceof StockInventoryUsageLink) {
            ((StockInventoryUsageLink)stockLink).setRemovable(element.isRemovable());
            BigDecimal price = element.getRemovePrice();
            if (price != null) {
                ((StockInventoryUsageLink)stockLink).setRemovePrice(new Price(price, 0.01));
            }
        }
        if (((StockLink)stockLink).getStockItem() == null) {
            return null;
        }
        return stockLink;
    }
}

