/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.Prop;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosCustomerCategoryRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosTrigger;
import au.com.ordermate.xmlintegration.system.posdatabase.PosTriggerRef;
import java.util.Set;
import javax.xml.bind.UnmarshalException;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.AccountTypeTrigger;
import ordermate.database.inventory.triggers.CompositeTrigger;
import ordermate.database.inventory.triggers.CustomerCategoryTrigger;
import ordermate.database.inventory.triggers.UserTrigger;
import ordermate.database.queries.inventory.TriggerQueries;
import ordermate.database.sales.CustomerCategory;
import ordermate.jaxb.exporter.handlers.posdatabase.PosExportUtil;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;

@Handles(domainClass=AbstractTrigger.class, exportClass=PosTrigger.class)
public class TriggerHandler
extends PropertyHandler<AbstractTrigger, PosTrigger> {
    private final String PERMISSION_GROUP_PROPERTY_NAME = "PermissionGp";
    private final String LABEL_PROPERTY_NAME = "label";

    protected TriggerHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(AbstractTrigger.class, PosTrigger.class, integrationContext);
    }

    @Override
    public PosTrigger createAndPopulate(AbstractTrigger domainObj, ObjectFactory objectFactory) throws ExportException {
        if (domainObj == null || PosExportUtil.shouldIgnoreTrigger(domainObj.getDiscriminatorType())) {
            return null;
        }
        PosTrigger trigger = objectFactory.createPosTrigger();
        if (trigger == null) {
            return null;
        }
        this.exportProperties(domainObj, (PropertiedEntity)trigger, objectFactory);
        trigger.setDiscriminatorType(domainObj.getDiscriminatorType().toString());
        this.getExportLaw().modify(domainObj, AbstractTrigger.class, trigger);
        if (domainObj instanceof CompositeTrigger) {
            CompositeTrigger compositeTrigger = (CompositeTrigger)domainObj;
            this.exportList(trigger.getChildTriggers(), compositeTrigger.getTriggers(), AbstractTrigger.class, PosTriggerRef.class, objectFactory);
        } else if (domainObj instanceof CustomerCategoryTrigger) {
            CustomerCategoryTrigger custCatTrigger = (CustomerCategoryTrigger)domainObj;
            trigger.setCustomerCategory(this.convertToExport(custCatTrigger.getCustomerCategory(), PosCustomerCategoryRef.class, objectFactory));
        } else if (domainObj instanceof UserTrigger) {
            Prop permissionGpProp = new Prop();
            permissionGpProp.setName("PermissionGp");
            permissionGpProp.setVal(String.valueOf(((UserTrigger)domainObj).getPermissionGroup().getLevel()));
            permissionGpProp.setType("int");
            trigger.getProperties().add(permissionGpProp);
        }
        return trigger;
    }

    @Override
    public AbstractTrigger importElement(PosTrigger element, PersistentObject parent) throws UnmarshalException {
        AbstractTrigger.Types<? super AbstractTrigger> type = this.getTriggerType(element);
        if (PosExportUtil.shouldIgnoreTrigger(type)) {
            return null;
        }
        AbstractTrigger domainObj = (AbstractTrigger)this.getExistingOrCreateNew((ExportEntityI)element);
        if (domainObj instanceof UserTrigger) {
            return domainObj;
        }
        this.importProperties(domainObj, element);
        if (!domainObj.isPersistent() && "DELETED".equals(domainObj.getSystemState())) {
            return null;
        }
        if (domainObj instanceof CompositeTrigger) {
            CompositeTrigger compositeTrigger = (CompositeTrigger)domainObj;
            for (PosTriggerRef childTrigger : element.getChildTriggers()) {
                compositeTrigger.addTrigger(this.getIntegrationContext().getHandler(AbstractTrigger.class, PosTriggerRef.class).importElement(childTrigger, null));
            }
            return compositeTrigger;
        }
        if (domainObj instanceof CustomerCategoryTrigger) {
            CustomerCategoryTrigger custCatTrig = (CustomerCategoryTrigger)domainObj;
            custCatTrig.setCustomerCategory(this.getHandler(CustomerCategory.class, PosCustomerCategoryRef.class).importElement(element.getCustomerCategory(), null));
            return custCatTrig;
        }
        return domainObj;
    }

    private AbstractTrigger.Types<? super AbstractTrigger> getTriggerType(PosTrigger triggerXML) {
        AbstractTrigger.Types type = AbstractTrigger.Types.register.get(triggerXML.getDiscriminatorType());
        if (type == null) {
            throw new IllegalArgumentException("Trigger type not found : " + triggerXML.getDiscriminatorType());
        }
        return type;
    }

    @Override
    protected Class<? extends AbstractTrigger> determineConcreteType(PosTrigger entity) {
        AbstractTrigger.Types<? super AbstractTrigger> type = this.getTriggerType(entity);
        return type.getTriggerClass();
    }

    @Override
    protected AbstractTrigger getExisting(ExportEntityI entity, PropertiedObject.Property<? extends Number> idProp) throws UnmarshalException {
        AbstractTrigger.Types<? super AbstractTrigger> expectedType;
        if (this.getTriggerType((PosTrigger)entity).equals(AbstractTrigger.Types.USER_TYPE)) {
            return this.getUserTrigger(entity);
        }
        AbstractTrigger foundTrigger = (AbstractTrigger)super.getExisting(entity, idProp);
        if (foundTrigger == null) {
            if (this.getTriggerType((PosTrigger)entity).equals(AbstractTrigger.Types.DEFAULT_TYPE)) {
                return AbstractTrigger.getDefaultTriggerIfExists();
            }
            if (this.getTriggerType((PosTrigger)entity).equals(AbstractTrigger.Types.ACCOUNT_TYPE)) {
                return this.getAccountTypeTrigger(entity);
            }
        }
        if (foundTrigger != null && !(expectedType = this.getTriggerType((PosTrigger)entity)).equals(foundTrigger.getDiscriminatorType())) {
            if (foundTrigger instanceof CompositeTrigger) {
                for (AbstractTrigger childTrigger : ((CompositeTrigger)foundTrigger).getTriggers()) {
                    childTrigger.setMasterId(null);
                    childTrigger.save();
                }
            }
            foundTrigger.setMasterId(null);
            foundTrigger.save();
            foundTrigger = null;
        }
        return foundTrigger;
    }

    private UserTrigger getUserTrigger(ExportEntityI entity) {
        PosTrigger hoUserTrigger = (PosTrigger)entity;
        UserTrigger existingUTrigger = null;
        for (Prop prop : hoUserTrigger.getProperties()) {
            if (!prop.getName().equals("PermissionGp")) continue;
            existingUTrigger = PersistenceManager.getObject(UserTrigger.class, TriggerQueries.getUserTriggerWithPermissionLevel(Integer.valueOf(prop.getVal())).toString());
            break;
        }
        if (existingUTrigger == null) {
            existingUTrigger = PersistenceManager.getObject(UserTrigger.class, TriggerQueries.getUserTriggerWithPermissionLevel(1).toString());
        }
        return existingUTrigger;
    }

    private AccountTypeTrigger getAccountTypeTrigger(ExportEntityI entity) {
        PosTrigger defaultTrigger = (PosTrigger)entity;
        AccountTypeTrigger existingUTrigger = null;
        String label = null;
        for (Prop prop : defaultTrigger.getProperties()) {
            if (!prop.getName().equals("label")) continue;
            label = prop.getVal().toString();
            break;
        }
        existingUTrigger = PersistenceManager.getObject(AccountTypeTrigger.class, TriggerQueries.getAccountTypeTriggerWithLabelAndType(label).toString());
        return existingUTrigger;
    }

    @Override
    protected void filterNonImportedProps(Set<Prop> props) {
        Prop toRemove = null;
        for (Prop prop : props) {
            if (!"triggerType".equals(prop.getName())) continue;
            toRemove = prop;
        }
        if (toRemove != null) {
            props.remove(toRemove);
        }
    }
}

