/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.stock;

import au.com.ordermate.integration.jaxb.Handler;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import javax.xml.bind.UnmarshalException;

public class RefTrackerHandlerWrapper<D extends PersistentObject, E extends PropertiedEntity, OF>
implements Handler<D, E, OF> {
    private Handler<D, E, OF> wrappedHandler;
    private BiMap<E, D> pojoToDomainObj = HashBiMap.create();

    public RefTrackerHandlerWrapper(Handler<D, E, OF> handlerToWrap) {
        this.wrappedHandler = handlerToWrap;
    }

    @Override
    public E exportDomainObject(D domainObj, OF objectFactory) throws ExportException {
        if (this.pojoToDomainObj.containsValue(domainObj)) {
            return (E)((PropertiedEntity)this.pojoToDomainObj.inverse().get(domainObj));
        }
        PropertiedEntity element = (PropertiedEntity)this.wrappedHandler.exportDomainObject(domainObj, objectFactory);
        if (element != null) {
            this.pojoToDomainObj.put((Object)element, domainObj);
            element.setXMLRefID(this.getElementClass().getSimpleName() + "_" + ((PersistentObject)domainObj).getID());
        }
        return (E)element;
    }

    @Override
    public D importElement(E element, PersistentObject parent) throws UnmarshalException {
        if (this.pojoToDomainObj.containsKey(element)) {
            return (D)((PersistentObject)this.pojoToDomainObj.get(element));
        }
        D domObj = this.wrappedHandler.importElement(element, parent);
        if (!this.pojoToDomainObj.inverse().containsKey(domObj)) {
            this.pojoToDomainObj.put(element, domObj);
        }
        return domObj;
    }

    @Override
    public Class<? extends D> getDomainClass() {
        return this.wrappedHandler.getDomainClass();
    }

    @Override
    public Class<E> getElementClass() {
        return this.wrappedHandler.getElementClass();
    }

    public D getDomainObj(E key) {
        return (D)((PersistentObject)this.pojoToDomainObj.get(key));
    }

    public E getElement(D domainObj) {
        return (E)((PropertiedEntity)this.pojoToDomainObj.inverse().get(domainObj));
    }

    public String toString() {
        return "RefTrackerHandlerWrapper [wrappedHandler=" + this.wrappedHandler + "]";
    }

    public Handler<D, E, OF> getWrappedHandler() {
        return this.wrappedHandler;
    }
}

