/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.stock;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handler;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.Prop;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosBarcode;
import au.com.ordermate.xmlintegration.system.posdatabase.PosStockItem;
import au.com.ordermate.xmlintegration.system.posdatabase.PosStockOnHand;
import au.com.ordermate.xmlintegration.system.posdatabase.PosSupplierRef;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockItemSupplier;
import ordermate.database.stock.StockOnHand;
import ordermate.database.stock.StockSupplier;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;

@Handles(domainClass=StockItem.class, exportClass=PosStockItem.class)
class StockItemHandler
extends PropertyHandler<StockItem, PosStockItem> {
    protected StockItemHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(StockItem.class, PosStockItem.class, null, integrationContext);
    }

    @Override
    public PosStockItem createAndPopulate(StockItem domainObj, ObjectFactory objectFactory) throws ExportException {
        PosStockItem stockItemXML = objectFactory.createPosStockItem();
        this.exportProperties(domainObj, (PropertiedEntity)stockItemXML, objectFactory);
        this.exportList(stockItemXML.getStockOnHands(), domainObj.getStockOnHand(), StockOnHand.class, PosStockOnHand.class, objectFactory);
        for (String barcodeStr : domainObj.getBarcodes()) {
            PosBarcode barcode = objectFactory.createPosBarcode();
            barcode.setCode(barcodeStr);
            stockItemXML.getBarcodes().add(barcode);
        }
        for (StockItemSupplier stockItemSupplier : domainObj.getStockItemSuppliers()) {
            PosSupplierRef ref = this.getHandler(StockSupplier.class, PosSupplierRef.class).exportDomainObject(stockItemSupplier.getStockSupplier(), objectFactory);
            this.addIfNotNull(stockItemXML.getSuppliers(), ref);
            if (ref == null) continue;
            ref.setProdCode(stockItemSupplier.getProductCode());
        }
        return stockItemXML;
    }

    @Override
    public StockItem importElement(PosStockItem element, PersistentObject parent) throws UnmarshalException {
        PersistentObject itemContainer;
        StockItem item = (StockItem)this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(item, element);
        boolean foundCurrentCost = false;
        boolean foundOldCost = false;
        boolean foundPurchaseQty = false;
        boolean foundMeasureUnit = false;
        for (Prop prop : element.getProperties()) {
            if (prop.getName().equals("currentCost")) {
                Price currentCost = this.importProperty(StockItem.Properties.CURRENT_COST, prop);
                item.setCurrentCost(currentCost);
                foundCurrentCost = true;
                continue;
            }
            if (prop.getName().equalsIgnoreCase("oldCost")) {
                Price oldCost = this.importProperty(StockItem.Properties.OLD_COST, prop);
                item.setOldCost(oldCost);
                foundOldCost = true;
                continue;
            }
            if (prop.getName().equalsIgnoreCase("quantityPerUnit") || prop.getName().equalsIgnoreCase("purchaseQty")) {
                Quantity qtyPerUnit = (Quantity)this.importProperty(StockItem.Properties.PURCHASE_QTY, prop);
                item.setPurchaseQty(qtyPerUnit);
                foundPurchaseQty = true;
                continue;
            }
            if (prop.getName().equalsIgnoreCase("ingredientMeasureUnit")) {
                MeasureUnit unit = this.importProperty(StockItem.Properties.INGREDIENT_MEASURE_UNIT, prop);
                item.setIngredientMeasureUnit(unit);
                foundMeasureUnit = true;
                continue;
            }
            if (!prop.getName().equalsIgnoreCase("displayMeasureUnit") && !prop.getName().equalsIgnoreCase("displayMeasureUnitContainer")) continue;
            itemContainer = item.getDisplayMeasureUnitContainer();
            MeasureUnitContainer importedContainer = this.importProperty(MeasureUnitContainer.class, prop);
            MeasureUnit unit = importedContainer.getMeasureUnit();
            if (unit == null) continue;
            ((MeasureUnitContainer)itemContainer).setMeasureUnit(unit);
            ((MeasureUnitContainer)itemContainer).setMeasureContainer(importedContainer.getMeasureContainer());
            ((MeasureUnitContainer)itemContainer).setQuantityPerContainer(importedContainer.getQuantityPerContainer());
            item.setIngredientMeasureUnit(unit);
            foundMeasureUnit = true;
        }
        if (!foundMeasureUnit && foundPurchaseQty) {
            item.setIngredientMeasureUnit(item.getPurchaseQty().getMeasureUnit());
            foundMeasureUnit = true;
        }
        if (!(foundOldCost && foundCurrentCost && foundPurchaseQty && foundMeasureUnit)) {
            throw new IllegalStateException("Special case handling of old cost or current cost failed : " + foundOldCost + " " + foundCurrentCost + " " + foundPurchaseQty + " " + foundMeasureUnit);
        }
        for (PosStockOnHand sohXml : element.getStockOnHands()) {
            itemContainer = this.getHandler(StockOnHand.class, PosStockOnHand.class).importElement(sohXml, null);
        }
        for (PosBarcode barcode : element.getBarcodes()) {
            item.addBarcode(barcode.getCode());
        }
        for (PosSupplierRef supplierRef : element.getSuppliers()) {
            Handler handler = this.getHandler(StockSupplier.class, PosSupplierRef.class);
            StockSupplier supplier = handler.importElement(supplierRef, null);
            if (supplier == null) {
                OrderMate.LOG.info("Cannot find supplier:" + supplierRef);
                continue;
            }
            item.addSupplier(supplier, supplierRef.getProdCode());
        }
        return item;
    }

    @Override
    protected Iterable<PropertiedObject.Property> getImportableProperties(StockItem domainObj) {
        Iterable<PropertiedObject.Property> props = super.getImportableProperties(domainObj);
        Iterator<PropertiedObject.Property> it = props.iterator();
        while (it.hasNext()) {
            PropertiedObject.Property prop = it.next();
            if (!prop.equals(StockItem.Properties.CURRENT_COST) && !prop.equals(StockItem.Properties.OLD_COST) && !prop.equals(StockItem.Properties.PURCHASE_QTY) && !prop.equals(StockItem.Properties.DISPLAY_MEASURE_UNIT_CONTAINER) && !prop.equals(StockItem.Properties.INGREDIENT_MEASURE_UNIT)) continue;
            it.remove();
        }
        return props;
    }

    @Override
    protected void filterNonImportedProps(Set<Prop> props) {
        HashSet<Prop> removeSet = new HashSet<Prop>();
        for (Prop prop : props) {
            if (!prop.getName().equals("currentCost") && !prop.getName().equals("oldCost") && !prop.getName().equals("quantityPerUnit") && !prop.getName().equals("ingredientMeasureUnit") && !prop.getName().equals("displayMeasureUnit")) continue;
            removeSet.add(prop);
        }
        props.removeAll(removeSet);
    }
}

