/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.webservices.finance;

import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.queries.finance.timesheet.FinanceTimesheetQueries;
import ordermate.database.users.User;
import ordermate.integration.jaxb.webservice.finance.timesheet.ObjectFactory;
import ordermate.integration.jaxb.webservice.finance.timesheet.TimesheetEvent;
import ordermate.integration.jaxb.webservice.finance.timesheet.TimesheetEventType;
import ordermate.integration.jaxb.webservice.finance.timesheet.TimesheetReport;

public class TimesheetExporter {
    private final DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();

    public void exportTimesheets(Date fromDate, Date toDate, OutputStream output) throws JAXBException {
        if (output == null) {
            throw new IllegalArgumentException("The outputStream cannot be null.");
        }
        TimesheetReport report = this.generateTimesheetReport(fromDate, toDate);
        Class[] boundClasses = new Class[]{TimesheetEvent.class, TimesheetReport.class};
        Marshaller marshaller = JAXBContext.newInstance((Class[])boundClasses).createMarshaller();
        marshaller.marshal((Object)report, output);
    }

    public TimesheetReport generateTimesheetReport(Date fromDate, Date toDate) {
        Calendar from = Calendar.getInstance();
        Calendar to = Calendar.getInstance();
        if (fromDate != null) {
            from.setTime(fromDate);
        }
        if (toDate != null) {
            to.setTime(toDate);
        }
        this.validateDates(from, to);
        List<FinanceTimesheet> sheets = FinanceTimesheetQueries.getTimesheetsClockedInOrOutWithin(from, to);
        ObjectFactory factory = new ObjectFactory();
        TimesheetReport report = factory.createTimesheetReport();
        this.setupReport(from, to, sheets, report, factory);
        return report;
    }

    private void setupReport(Calendar from, Calendar to, List<FinanceTimesheet> sheets, TimesheetReport report, ObjectFactory factory) {
        report.setBusinessName(BusinessInfo.getInstance().getName());
        report.setFromDate(this.makeXMLDate(from));
        report.setToDate(this.makeXMLDate(to));
        for (FinanceTimesheet sheet : sheets) {
            TimesheetEvent event = this.createEvent(factory, sheet, TimesheetEventType.LOGIN);
            if (event != null) {
                report.getEvents().add(event);
            }
            if ((event = this.createEvent(factory, sheet, TimesheetEventType.LOGOUT)) == null) continue;
            report.getEvents().add(event);
        }
    }

    private TimesheetEvent createEvent(ObjectFactory factory, FinanceTimesheet sheet, TimesheetEventType type) {
        Date date = null;
        if (TimesheetEventType.LOGIN.equals((Object)type)) {
            date = sheet.getTimeIn();
        } else if (TimesheetEventType.LOGOUT.equals((Object)type)) {
            date = sheet.getTimeOut();
        }
        if (date == null) {
            return null;
        }
        User user = sheet.getUser();
        if (user == null) {
            return null;
        }
        TimesheetEvent event = factory.createTimesheetEvent();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        event.setDate(this.makeXMLDate(cal));
        event.setEvent(type);
        event.setStaffId(user.getPayrollID());
        event.setStaffName(user.getName());
        event.setTime(this.makeXMLTime(cal));
        event.setUserId(user.getID());
        event.setClockLogId(sheet.getID());
        return event;
    }

    private XMLGregorianCalendar makeXMLTime(Calendar time) {
        return this.datatypeFactory.newXMLGregorianCalendarTime(time.get(11), time.get(12), time.get(13), Integer.MIN_VALUE);
    }

    private XMLGregorianCalendar makeXMLDate(Calendar date) {
        return this.datatypeFactory.newXMLGregorianCalendarDate(date.get(1), date.get(2) + 1, date.get(5), Integer.MIN_VALUE);
    }

    private void validateDates(Calendar from, Calendar to) {
        if (from.getTime().after(to.getTime())) {
            Date temp = from.getTime();
            from.setTime(to.getTime());
            to.setTime(temp);
        }
        long now = System.currentTimeMillis();
        if (from.getTimeInMillis() > now) {
            from.setTimeInMillis(now);
        }
        if (to.getTimeInMillis() > now) {
            to.setTimeInMillis(now);
        }
    }
}

