/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.masterid;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceDelegate;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import java.util.Collection;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryProfileHelper;
import ordermate.jaxb.exporter.masterid.MasterIDGenerator;

public abstract class AbstractMasterIDGenerator
implements MasterIDGenerator {
    private final PersistenceDelegate persistence;
    private final String SYSTEMSTATE = "system_state";

    public AbstractMasterIDGenerator(PersistenceDelegate delegate) {
        this.persistence = delegate;
    }

    protected PersistenceDelegate getPersistence() {
        return this.persistence;
    }

    @Override
    public boolean generateMasterIds(Collection<Class<? extends PersistentObject>> classes) {
        String updateClause = this.makeUpdateClause();
        String whereClause = this.makeWhereClause();
        try {
            for (Class<? extends PersistentObject> clazz : classes) {
                if (ExportableObject.class.isAssignableFrom(clazz)) {
                    try {
                        System.out.println(clazz.toString());
                        String table = PersistenceManager.getPersistenceMetaData().getClassTable(clazz);
                        boolean flag = true;
                        Object[][] systemStateColumnResult = this.persistence.executeQuery(this.isSystemStateExistQuery(table), null);
                        if (systemStateColumnResult == null || systemStateColumnResult.length == 0) {
                            flag = false;
                        }
                        StringBuilder SB = new StringBuilder("UPDATE ");
                        SB.append(table).append(" SET ").append("masterId").append(" = ").append(updateClause);
                        if (whereClause != null) {
                            SB.append(" WHERE ").append(whereClause);
                        }
                        if (flag) {
                            SB.append(" and system_state= 'ACTIVE'");
                        }
                        this.persistence.executeUpdate(SB.toString(), null);
                    }
                    catch (Exception ex) {
                        String table = PersistenceManager.getPersistenceMetaData().getClassTable(clazz);
                        OrderMate.LOG.error("Could not set master id for " + clazz + ". Unable to retrieve table or not persistent." + this.isSystemStateExistQuery(table));
                    }
                    continue;
                }
                String msg = "Could not generate master id for class " + clazz + " it does not extend exportable object";
                OrderMate.LOG.warn(msg);
            }
            PersistenceManager.getInstance().clearLocalCaches();
            InventoryProfileHelper.getInstance().clearCache();
            return true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("An exception occurred generating master IDs", (Throwable)ex);
            return false;
        }
    }

    private String isSystemStateExistQuery(String tableName) {
        String sql = "SELECT * FROM information_schema.columns WHERE table_schema = 'ordermate_prod' AND table_name = '" + tableName + "' AND COLUMN_NAME='" + "system_state" + "'";
        return sql;
    }

    protected abstract String makeUpdateClause();

    protected abstract String makeWhereClause();
}

