/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jnlp;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractJNLP {
    public abstract List<String> getSpecificJars();

    public abstract List<String> getNativeLibs();

    public abstract Map<String, String> getApplicationProperties();

    public abstract String getMainClass();

    public abstract String getTitle();

    public abstract String getDescription();

    public abstract String getShortDescription();

    public abstract String getApplicationJar();

    public String getIcon() {
        return "images/ordermate.ico";
    }

    protected final void addJasperReportJars(List<String> jars) {
        jars.add("lib/jasperreports/commons-beanutils-1.7.jar");
        jars.add("lib/jasperreports/commons-collections-3.2.jar");
        jars.add("lib/jasperreports/commons-digester-1.7.jar");
        jars.add("lib/jasperreports/itext-2.1.0.jar");
        jars.add("lib/jasperreports/jasperreports-3.7.3.jar");
    }

    protected final void addJacksonJars(List<String> jars) {
        jars.add("lib/jackson/jackson-core-2.2.0.jar");
        jars.add("lib/jackson/jackson-databind-2.2.0.jar");
        jars.add("lib/jackson/jackson-annotations-2.2.0.jar");
        jars.add("lib/jackson/jackson-jaxrs-base-2.2.0.jar");
        jars.add("lib/jackson/jackson-jaxrs-json-provider-2.2.0.jar");
        jars.add("lib/jackson/jackson-module-jaxb-annotations-2.2.0.jar");
    }

    protected final void addVaadinJars(List<String> jars) {
        jars.add("lib/vaadin7/jsoup-1.6.3.jar");
        jars.add("lib/vaadin7/commons-jexl-2.1.1.jar");
        jars.add("lib/vaadin7/vaadin-client-compiled-7.4.0.alpha1.jar");
        jars.add("lib/vaadin7/vaadin-push-7.4.0.alpha11.jar");
        jars.add("lib/vaadin7/vaadin-server-7.4.0.alpha1.jar");
        jars.add("lib/vaadin7/vaadin-shared-7.4.0.alpha1.jar");
        jars.add("lib/vaadin7/vaadin-shared-deps-1.0.2.jar");
        jars.add("lib/vaadin7/vaadin-themes-7.4.0.alpha1.jar");
        jars.add("lib/vaadin7/vaadin-touchkit-cval-3.0.0.jar");
        jars.add("lib/vaadin7/vaadin-slf4j-jdk14-1.6.1.jar");
        jars.add("lib/vaadin7/atmosphere-runtime-2.1.2.vaadin2.jar");
    }

    protected final void addDynamicJasperJars(List<String> jars) {
        jars.add("lib/jasperreports/poi-3.5-FINAL.jar");
        jars.add("lib/jasperreports/DynamicJasper-3.1.3a.jar");
        jars.add("lib/jasperreports/jcommon-1.0.15.jar");
        jars.add("lib/jasperreports/jdtcore-3.1.0.jar");
        jars.add("lib/jasperreports/jfreechart-1.0.12.jar");
    }

    protected final void addZxingJars(List<String> jars) {
        jars.add("lib/zxing/core-3.2.1.jar");
        jars.add("lib/zxing/javase-3.2.1.jar");
    }

    protected final void addJerseyJars(List<String> jars) {
        jars.add("lib/jersey/asm-3.1.jar");
        jars.add("lib/jersey/jersey-core-1.17.jar");
        jars.add("lib/jersey/jersey-server-1.17.jar");
        jars.add("lib/jersey/jersey-servlet-1.17.jar");
        jars.add("lib/jersey/jersey-client-1.17.jar");
        jars.add("lib/jersey/jersey-multipart-1.17.jar");
        jars.add("lib/jersey/jersey-json-1.17.jar");
        jars.add("lib/jersey/jsr311-api-1.1.1.jar");
        jars.add("lib/kxml2-2.3.0.jar");
    }

    protected final void addWindowsJars(List<String> jars) {
        jars.add("lib/windows/comm.jar");
        jars.add("lib/windows/rainbow.jar");
    }

    protected final void addFingerprintJars(List<String> jars) {
        jars.add("lib/fingerprint/dpfpenrollment.jar");
        jars.add("lib/fingerprint/dpfpverification.jar");
        jars.add("lib/fingerprint/dpotapi.jar");
        jars.add("lib/fingerprint/dpotjni.jar");
    }

    protected void addServletJars(List<String> jars) {
        jars.add("lib/jetty/javax.servlet-api-4.0.1.jar");
        jars.add("lib/jetty/jetty-util-8.0.4.v20111024.jar");
        jars.add("lib/jetty/jetty-server-8.0.4.v20111024.jar");
        jars.add("lib/jetty/jetty-servlet-8.0.4.v20111024.jar");
        jars.add("lib/jetty/jetty-servlets-8.0.4.v20111024.jar");
        jars.add("lib/jetty/jetty-continuation-8.0.4.v20111024.jar");
        jars.add("lib/jetty/jetty-http-8.0.4.v20111024.jar");
        jars.add("lib/jetty/jetty-io-8.0.4.v20111024.jar");
        jars.add("lib/jetty/jetty-security-8.0.4.v20111024.jar");
        jars.add("lib/jetty/jetty-webapp-8.0.4.v20111024.jar");
        jars.add("lib/jetty/jetty-xml-8.0.4.v20111024.jar");
        jars.add("lib/jetty/jetty-websocket-8.0.4.v20111024.jar");
        this.addJerseyJars(jars);
        this.addJacksonJars(jars);
    }

    protected void addLog4J2Jars(List<String> jars) {
        jars.add("lib/disruptor-3.3.4.jar");
        jars.add("lib/log4j-api-2.12.4.jar");
        jars.add("lib/log4j-core-2.12.4.jar");
        jars.add("lib/slf4j-api-1.7.25.jar");
    }

    protected void addSentryJars(List<String> jars) {
        jars.add("lib/sentry/sentry-1.7.3.jar");
        jars.add("lib/sentry/sentry-log4j-1.7.3.jar");
    }

    protected void addAssemblyJars(List<String> jars) {
        jars.add("lib/assembly/okhttp-3.12.0.jar");
        jars.add("lib/assembly/okio-1.15.0.jar");
        jars.add("lib/assembly/spi-client-java-2.3.8.jar");
        jars.add("lib/annotations-16.0.1.jar");
        jars.add("lib/gson-2.8.2.jar");
    }

    protected void addFontPack(List<String> jars) {
        jars.add("lib/om-fontpack.jar");
    }

    public final List<String> getCommonLibraryJars() {
        ArrayList<String> jars = new ArrayList<String>();
        jars.add("lib/commons-lang-2.6.jar");
        jars.add("lib/encryption.jar");
        jars.add("lib/commons-logging-1.1.1.jar");
        jars.add("lib/jasperreports/groovy-all-1.7.2.jar");
        jars.add("lib/guava-r05.jar");
        jars.add("lib/TimingFramework-1.0.jar");
        jars.add("lib/commons-io-2.4.jar");
        jars.add("lib/mimepull-1.7.jar");
        return jars;
    }

    public List<String> getCommonJars() {
        List<String> jars = this.getCommonLibraryJars();
        jars.add("lib/pocketmate/StockMate.jar");
        jars.add("lib/ordermate-pos.jar");
        this.addFontPack(jars);
        return jars;
    }

    protected void addOAuthJars(List<String> jars) {
        jars.add("lib/oauth/httpclient-4.3.5.jar");
        jars.add("lib/oauth/httpcore-4.3.2.jar");
        jars.add("lib/oauth/oauth-20100527.jar");
        jars.add("lib/oauth/oauth-consumer-20100527.jar");
        jars.add("lib/oauth/oauth-httpclient4-20090913.jar");
        jars.add("lib/oauth/oauth-httpclient3-20090617.jar");
    }

    protected void addEclipseLinkJars(List<String> jars) {
        jars.add("lib/eclipselink/eclipselink.jar");
    }

    public List<String> getExternalJars(String outputDirectory) {
        ArrayList<String> jars = new ArrayList<String>();
        this.addExternalJars(jars, outputDirectory, "lib/ext/");
        this.addExternalJars(jars, outputDirectory, "lib/ext/" + this.getApplicationJar().toLowerCase().split("\\.")[0] + "/");
        return jars;
    }

    private void addExternalJars(List<String> jars, String outputDirectory, String externalJarDirectory) {
        File directory = new File(outputDirectory + externalJarDirectory);
        if (directory.exists()) {
            String[] jarFiles = directory.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.endsWith(".jar");
                }
            });
            String path = externalJarDirectory;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            for (String jarFile : jarFiles) {
                jars.add(path + jarFile);
            }
        }
    }
}

