/*
 * Decompiled with CFR 0.152.
 */
package ordermate.maps;

import au.com.ordermate.persistence.database.ClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.PropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ReferenceMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.maps.AllMappings;

public class DependenciesUtil {
    Map<Class, Set<Class>> dependencies = new HashMap<Class, Set<Class>>();
    private static final DependenciesUtil INSTANCE = new DependenciesUtil();
    private final List<Class> result;
    private Set<Class> stack = new HashSet<Class>();

    private List<Class> sortClassesByDependency() {
        Collection<ClassMap> mappings = AllMappings.getMappings();
        for (ClassMap mapping : mappings) {
            this.dependencies.put(mapping.getTypeClass(), new HashSet());
        }
        for (ClassMap mapping : mappings) {
            for (PropertyMapping pm : mapping.getPropertyMappings()) {
                Set<Class> depOf;
                if (!(pm instanceof ReferenceMapping) || (depOf = this.dependencies.get(mapping.getTypeClass())) == null || mapping.getTypeClass().equals(pm.getProperty().getObjectType())) continue;
                depOf.add(pm.getProperty().getObjectType());
            }
        }
        ArrayList<Class> entities = new ArrayList<Class>();
        while (!this.dependencies.isEmpty()) {
            Class entity = this.dependencies.keySet().iterator().next();
            this.stack.clear();
            Class leaf = this.getLeaf(entity);
            entities.add(leaf);
        }
        return entities;
    }

    private Class getLeaf(Class node) {
        this.stack.add(node);
        Set<Class> children = this.dependencies.get(node);
        if (children == null) {
            return null;
        }
        if (!children.isEmpty()) {
            Iterator<Class> it = children.iterator();
            while (it.hasNext()) {
                Class leaf;
                Class child = it.next();
                it.remove();
                if (this.stack.contains(child) || (leaf = this.getLeaf(child)) == null) continue;
                return leaf;
            }
        }
        this.dependencies.remove(node);
        return node;
    }

    public static Collection<Class> getEntitiesByDependency() {
        return DependenciesUtil.INSTANCE.result;
    }

    private DependenciesUtil() {
        this.result = this.sortClassesByDependency();
    }
}

