/*
 * Decompiled with CFR 0.152.
 */
package ordermate.maps.finance.debtors;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.FKList;
import au.com.ordermate.persistence.cache.CachedFKReference;
import au.com.ordermate.persistence.database.AbstractSuperClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.IDMapping;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ListMapping;
import au.com.ordermate.persistence.database.columnpropertymap.PriceMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ReferenceMapping;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.users.LockingUserReference;

public class AbstractDebtorMap
extends AbstractSuperClassMap {
    public static final String ID = "ID";
    public static final String NAME = "Name";
    public static final String TYPE = "Type";
    public static final String TABLE_NAME = "debtor";
    public static final String SYSTEM_STATE = "system_state";
    public static final String AMOUNT_OUTSTANDING = "amount_outstanding";
    public static final String CREDIT_LIMIT = "credit_limit";
    private ColumnPropertyMapping[] maps;
    private static final ListMapping[] listMappings = new ListMapping[]{new ListMapping<DebtorSale>(AbstractDebtor.Properties.PAID_SALES, new FKList<DebtorSale>(DebtorSale.class, DebtorSale.Properties.DEBTOR){

        @Override
        protected ObjectQuery getObjectQuery() {
            return super.getObjectQuery().equals(DebtorSale.Properties.AMOUNT_OUTSTANDING, 0.0).orderBy(DebtorSale.Properties.SALE_DATE);
        }
    }.tearDownLinkBack(true)), new ListMapping<DebtorPayment>(AbstractDebtor.Properties.UNSETTLED_PAYMENTS, new FKList<DebtorPayment>(DebtorPayment.class, DebtorPayment.Properties.DEBTOR){

        @Override
        protected ObjectQuery getObjectQuery() {
            return super.getObjectQuery().linkUsing(DebtorPayment.Properties.FINANCE_TRANSACTION, FinanceTransaction.Properties.ID).active(FinanceTransaction.class).isNull(DebtorPayment.Properties.SALE);
        }
    }.deleteOnRemove(false).tearDownLinkBack(false)), new ListMapping<DebtorPayment>(AbstractDebtor.Properties.ALL_PAYMENTS, new FKList<DebtorPayment>(DebtorPayment.class, DebtorPayment.Properties.DEBTOR)), new ListMapping<DebtorSale>(AbstractDebtor.Properties.UNPAID_SALES, new FKList<DebtorSale>(DebtorSale.class, DebtorSale.Properties.DEBTOR){

        @Override
        protected ObjectQuery getObjectQuery() {
            return super.getObjectQuery().not().equals(DebtorSale.Properties.AMOUNT_OUTSTANDING, 0.0).orderBy(DebtorSale.Properties.SALE_DATE);
        }
    }.tearDownLinkBack(true))};

    @Override
    public String getDiscriminatorColumn() {
        return TYPE;
    }

    public AbstractDebtorMap() {
        super(TABLE_NAME, AbstractDebtor.class);
        this.maps = new ColumnPropertyMapping[]{new IDMapping(), new InstanceVarMapping(AbstractDebtor.Properties.LABEL, NAME), new InstanceVarMapping(AbstractDebtor.Properties.SYSTEM_STATE, SYSTEM_STATE), new PriceMapping(AbstractDebtor.Properties.AMOUNT_OUTSTANDING, AMOUNT_OUTSTANDING, 0.01), new PriceMapping(AbstractDebtor.Properties.CREDIT_LIMIT, CREDIT_LIMIT, 0.01), new InstanceVarMapping(AbstractDebtor.Properties.LAST_ACTIVITY_DATE, "last_activity_date"), new InstanceVarMapping(AbstractDebtor.Properties.EARLIEST_DUE_DATE, "earliest_due_date"), new InstanceVarMapping(AbstractDebtor.Properties.NOTE_REQUIRED, "is_note_required"), new ReferenceMapping(AbstractDebtor.Properties.GROUP, "FK_debtor_group", new CachedFKReference<DebtorGroup>(DebtorGroup.class)), new ReferenceMapping(AbstractDebtor.Properties.USER, "FK_config_user", new LockingUserReference(AbstractDebtor.Properties.USER))};
    }

    @Override
    protected ListMapping[] getSuperClassListMappings() {
        return listMappings;
    }

    @Override
    protected ColumnPropertyMapping[] getRawSuperClassMappings() {
        return this.maps;
    }
}

