/*
 * Decompiled with CFR 0.152.
 */
package ordermate.maps.finance.debtors;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.FKList;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.cache.CachedFKReference;
import au.com.ordermate.persistence.database.AbstractQueryableColumnClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.BooleanMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.IDMapping;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ListMapping;
import au.com.ordermate.persistence.database.columnpropertymap.PriceMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ReferenceMapping;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.sales.Account;

public class DebtorSaleMap
extends AbstractQueryableColumnClassMap {
    public static final String TABLE_NAME = "debtor_sale";
    public static final String COL_DUE_DATE = "debtor_sale.due_date";
    public static final String COL_SALE_DATE = "debtor_sale.sale_date";
    public static final String COL_PAID_FLAG = "debtor_sale.paid";
    public static final String COL_AMOUNT_OUTSTANDING = "debtor_sale.amount_outstanding";
    private ColumnPropertyMapping[] maps;
    public ListMapping[] lists;

    public DebtorSaleMap() {
        super(TABLE_NAME, DebtorSale.class);
        this.maps = new ColumnPropertyMapping[]{new IDMapping(), new InstanceVarMapping(DebtorSale.Properties.SALE_DATE, "sale_date"), new InstanceVarMapping(DebtorSale.Properties.DUE_DATE, "due_date"), new InstanceVarMapping(DebtorSale.Properties.PAID_DATE, "paid_date"), new BooleanMapping(DebtorSale.Properties.PAID), new BooleanMapping(DebtorSale.Properties.EXPORTED), new PriceMapping(DebtorSale.Properties.TOTAL, "total", 0.01), new PriceMapping(DebtorSale.Properties.TIP, "tip", 0.01), new PriceMapping(DebtorSale.Properties.AMOUNT_OUTSTANDING, "amount_outstanding", 0.01), new InstanceVarMapping(DebtorSale.Properties.REFUND_STATUS, "refund_status"), new InstanceVarMapping(DebtorSale.Properties.INVOICE_NOTE, "invoice_note"), new ReferenceMapping(DebtorSale.Properties.DEBTOR, "FK_debtor", new CachedFKReference<AbstractDebtor>(AbstractDebtor.class)), new ReferenceMapping(DebtorSale.Properties.SALE_ACCOUNT, "FK_sales_account", new CachedFKReference<Account>(Account.class)), new ReferenceMapping(DebtorSale.Properties.TERMINAL, "FK_config_terminal", new CachedFKReference<Terminal>(Terminal.class).collapseOnSerialize(true)), new ReferenceMapping(DebtorSale.Properties.CASHDRAWER, "FK_config_cashdrawer", new CachedFKReference<CashDrawer>(CashDrawer.class).collapseOnSerialize(true)), new ReferenceMapping(DebtorSale.Properties.SHIFT, "FK_finance_shift", new CachedFKReference<Shift>(Shift.class).collapseOnSerialize(true))};
        this.lists = new ListMapping[]{new ListMapping<DebtorPayment>(DebtorSale.Properties.PAYMENTS, new FKList<DebtorPayment>(DebtorPayment.class, DebtorPayment.Properties.SALE))};
    }

    @Override
    public ColumnPropertyMapping[] getRawMappings() {
        return this.maps;
    }

    @Override
    public ListMapping[] getListMappings() {
        return this.lists;
    }

    public static List<DebtorSale> getSalesBetweenDatesForDebtors(Date startDate, Date endDate, List debtors) {
        Date localEndDate = new Date(endDate.getTime());
        Date localStartDate = new Date(startDate.getTime());
        localEndDate.setHours(23);
        localEndDate.setMinutes(59);
        localEndDate.setSeconds(59);
        localStartDate.setHours(0);
        localStartDate.setMinutes(0);
        localStartDate.setSeconds(0);
        ObjectQuery query = Query.select(DebtorSale.class).wherePropertyIn(DebtorSale.Properties.DEBTOR, debtors).greaterThanOrEqual(DebtorSale.Properties.SALE_DATE, localStartDate, SQLDateType.TIMESTAMP).lessThanOrEqual(DebtorSale.Properties.SALE_DATE, localEndDate, SQLDateType.TIMESTAMP).equals(DebtorSale.Properties.EXPORTED, 0.0);
        return PersistenceManager.getObjectList(DebtorSale.class, query.toString(), null);
    }
}

