/*
 * Decompiled with CFR 0.152.
 */
package ordermate.maps.finance.transactions;

import au.com.ordermate.persistence.FKList;
import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.persistence.cache.CachedFKReference;
import au.com.ordermate.persistence.database.AbstractSuperClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.BooleanMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.IDMapping;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ListMapping;
import au.com.ordermate.persistence.database.columnpropertymap.PriceMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ReferenceMapping;
import au.com.ordermate.persistence.database.columnpropertymap.TimestampMapping;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.users.User;

public class FinanceTransactionMap
extends AbstractSuperClassMap {
    public static final String TABLE_NAME = "finance_transaction";
    private ColumnPropertyMapping[] maps;
    private ListMapping[] listMaps;

    public FinanceTransactionMap() {
        super(TABLE_NAME, FinanceTransaction.class);
        this.maps = new ColumnPropertyMapping[]{new IDMapping(), new PriceMapping(FinanceTransaction.Properties.PAID, "amount_paid", 0.01), new PriceMapping(FinanceTransaction.Properties.CASH_OUT, "cash_out", 0.01), new PriceMapping(FinanceTransaction.Properties.TIP, "tip", 0.01), new PriceMapping(FinanceTransaction.Properties.TENDERED, "tendered", 0.01), new PriceMapping(FinanceTransaction.Properties.SURCHARGE, "surcharge", 0.01), new BooleanMapping(FinanceTransaction.Properties.PROCESSED, "processed"), new InstanceVarMapping(FinanceTransaction.Properties.SYSTEM_STATE, "system_state"), new TimestampMapping(FinanceTransaction.Properties.CREATION_TIME, "timestamp").setAllowNulls(true), new TimestampMapping(FinanceTransaction.Properties.PIGGY_PAYMENT_TIME, "piggy_payment_time").setAllowNulls(true), new InstanceVarMapping(FinanceTransaction.Properties.NOTE, "note"), new InstanceVarMapping(FinanceTransaction.Properties.MASKED_CARD_NUMBER, "masked_card_number"), new InstanceVarMapping(FinanceTransaction.Properties.TRANSACTION_REFERENCE, "transaction_reference"), new InstanceVarMapping(FinanceTransaction.Properties.SOURCE, "source"), new InstanceVarMapping(FinanceTransaction.Properties.EXT_TRANSACTION_ID, "ext_transaction_id", false), new ReferenceMapping(FinanceTransaction.Properties.ACCOUNT, "FK_payoff_account", new CachedFKReference<Account>(Account.class)), new ReferenceMapping(FinanceTransaction.Properties.TRADING_DAY, "FK_finance_trading_day", new CachedFKReference<TradingDay>(TradingDay.class).collapseOnSerialize(true)), new ReferenceMapping(FinanceTransaction.Properties.SHIFT, "FK_finance_shift", new CachedFKReference<Shift>(Shift.class).collapseOnSerialize(true)), new ReferenceMapping(FinanceTransaction.Properties.TERMINAL, "FK_config_terminal", new CachedFKReference<Terminal>(Terminal.class).collapseOnSerialize(true)), new ReferenceMapping(FinanceTransaction.Properties.USER, "FK_config_user", new CachedFKReference<User>(User.class).collapseOnSerialize(true)), new ReferenceMapping(FinanceTransaction.Properties.SUB_TYPE, "FK_finance_unit", new CachedFKReference<FinanceUnit>(FinanceUnit.class)), new ReferenceMapping(FinanceTransaction.Properties.CASH_DRAWER, "FK_config_cashdrawer", new CachedFKReference<CashDrawer>(CashDrawer.class).collapseOnSerialize(true)), new ReferenceMapping(FinanceTransaction.Properties.MOVED_TRANSACTION, "FK_finance_transaction", new FKReference<FinanceTransaction>(FinanceTransaction.class)), new PriceMapping(FinanceTransaction.Properties.ROUNDING_AMT, "rounding_amt", 0.01), new ReferenceMapping(FinanceTransaction.Properties.LOCATION, "FK_config_terminal_location", new CachedFKReference<TerminalLocation>(TerminalLocation.class).collapseOnSerialize(true)), new ReferenceMapping(FinanceTransaction.Properties.SALES_LOCATION, "FK_config_sales_location", new CachedFKReference<SalesLocation>(SalesLocation.class).collapseOnSerialize(true)), new InstanceVarMapping(EftposTransaction.Properties.REFUND_TXN_REF, "refund_txn_ref", false), new InstanceVarMapping(EftposTransaction.Properties.REVERSED_TRANSACTION_ID, "reversed_transaction_id", false), new InstanceVarMapping(EftposTransaction.Properties.BANK_DESC, "bank_desc", false)};
        this.listMaps = new ListMapping[]{new ListMapping<DebtorPayment>(FinanceTransaction.Properties.DEBTOR_PAYMENTS, new FKList<DebtorPayment>(DebtorPayment.class, DebtorPayment.Properties.FINANCE_TRANSACTION))};
    }

    @Override
    public String getDiscriminatorColumn() {
        return "type";
    }

    @Override
    protected ColumnPropertyMapping[] getRawSuperClassMappings() {
        return this.maps;
    }

    @Override
    protected ListMapping[] getSuperClassListMappings() {
        return this.listMaps;
    }
}

