/*
 * Decompiled with CFR 0.152.
 */
package ordermate.maps.integration.finance;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.cache.CachedFKReference;
import au.com.ordermate.persistence.database.AbstractColumnClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.persistence.database.columnpropertymap.PriceMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ReferenceMapping;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.reports.AccountingFinanceReport;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.misc.TradingDay;

public class AccountingFinanceReportMap
extends AbstractColumnClassMap {
    private static final double PRICE_ROUNDING = 0.01;
    private final ColumnPropertyMapping[] maps;

    public AccountingFinanceReportMap() {
        super(AccountingFinanceReport.class);
        this.maps = new ColumnPropertyMapping[]{new InstanceVarMapping(AccountingFinanceReport.Properties.DATE, "date", null), new PriceMapping(AccountingFinanceReport.Properties.AMOUNT, "amount", null, 0.01), new PriceMapping(AccountingFinanceReport.Properties.AMOUNT_EX, "amount_ex_gst", null, 0.01), new InstanceVarMapping(AccountingFinanceReport.Properties.PAYMENT_METHOD, "payment_method", null), new InstanceVarMapping(AccountingFinanceReport.Properties.UNIT_TYPE, "unit_type", null), new InstanceVarMapping(AccountingFinanceReport.Properties.CASH_DRAWER_NAME, "cash_drawer_name", null), new ReferenceMapping(AccountingFinanceReport.Properties.FINANCE_UNIT, "FK_finance_unit", new FKReference<FinanceUnit>(FinanceUnit.class), null), new ReferenceMapping(AccountingFinanceReport.Properties.CASH_DRAWER, "FK_config_cashdrawer", new FKReference<CashDrawer>(CashDrawer.class), null), new ReferenceMapping(AccountingFinanceReport.Properties.SHIFT, "FK_finance_shift", new FKReference<Shift>(Shift.class), null), new ReferenceMapping(AccountingFinanceReport.Properties.TRADING_DAY, "FK_finance_trading_day", new FKReference<TradingDay>(TradingDay.class), null), new ReferenceMapping(AccountingFinanceReport.Properties.GL_ACCOUNT, "FK_config_integration_acc_gl_account", new CachedFKReference<GLAccount>(GLAccount.class), null), new ReferenceMapping(AccountingFinanceReport.Properties.SALES_LOCATION, "FK_config_sales_location", new CachedFKReference<SalesLocation>(SalesLocation.class), null), new ReferenceMapping(AccountingFinanceReport.Properties.FINANCE_TRANSACTION, "FK_finance_transaction", new CachedFKReference<FinanceTransaction>(FinanceTransaction.class), null), new ReferenceMapping(AccountingFinanceReport.Properties.SOURCE_FINANCE_TRANSACTION, "source_finance_transaction", new CachedFKReference<FinanceTransaction>(FinanceTransaction.class), null)};
    }

    public static List<AccountingFinanceReport> getReportList(Shift startShift, Shift endShift) {
        if (startShift == null || endShift == null) {
            return null;
        }
        List<AccountingFinanceReport> reportList = PersistenceManager.getObjectList(AccountingFinanceReport.class, AccountingFinanceReportMap.getSelectStmt(), new Object[]{startShift.getID(), endShift.getID()});
        ArrayList<AccountingFinanceReport> accountingFinanceReportWithSourceList = new ArrayList<AccountingFinanceReport>();
        for (AccountingFinanceReport accountingFinanceReport : reportList) {
            if (accountingFinanceReport.getSourceFinanceTransaction() == null) continue;
            accountingFinanceReportWithSourceList.add(accountingFinanceReport);
        }
        reportList.removeAll(AccountingFinanceReportMap.getAccountingFinanceReportsSent(accountingFinanceReportWithSourceList));
        AccountingFinanceReportMap.ensureAtLeastOne(reportList, startShift, endShift);
        return reportList;
    }

    private static List<AccountingFinanceReport> getAccountingFinanceReportsSent(List<AccountingFinanceReport> accountingFinanceReportWithSourceList) {
        ArrayList<AccountingFinanceReport> accountingFinanceReportsSent = new ArrayList<AccountingFinanceReport>();
        for (AccountingFinanceReport accountingFinanceReport : accountingFinanceReportWithSourceList) {
            if (accountingFinanceReport.getSourceFinanceTransaction().getTradingDay().equals(accountingFinanceReport.getFinanceTransaction().getTradingDay())) continue;
            Date financtTransactionCreationTime = accountingFinanceReport.getFinanceTransaction().getCreationTime();
            Date sourceFinanctTransactionCreationTime = accountingFinanceReport.getSourceFinanceTransaction().getCreationTime();
            Date lastExportDateTime = AccountingIntegrationConfig.getInstance().getLastExportDate();
            if ((!lastExportDateTime.after(sourceFinanctTransactionCreationTime) || !lastExportDateTime.before(financtTransactionCreationTime)) && !lastExportDateTime.before(sourceFinanctTransactionCreationTime)) continue;
            accountingFinanceReportsSent.add(accountingFinanceReport);
        }
        return accountingFinanceReportsSent;
    }

    private static final void ensureAtLeastOne(List<AccountingFinanceReport> reportList, Shift startShift, Shift endShift) {
        List<Shift> shifts = PersistenceManager.getObjectList(Shift.class, new ObjectQuery().select(Shift.class).wherePropertyBetween(Shift.Properties.ID, startShift.getID(), endShift.getID()).toString(), null);
        int index = 0;
        for (Shift shift : shifts) {
            boolean found = false;
            long id = shift.getID();
            for (int i = index; i < reportList.size(); ++i) {
                AccountingFinanceReport report = reportList.get(i);
                if (report.getShift().getID() > id) {
                    index = i;
                    break;
                }
                if (!report.getShift().getID().equals(shift.getID())) continue;
                found = true;
                break;
            }
            if (found) continue;
            reportList.add(index, AccountingFinanceReport.generateBlankReport(shift));
        }
    }

    @Override
    public ColumnPropertyMapping[] getRawMappings() {
        return this.maps;
    }

    private static String getSelectStmt() {
        StringBuilder SB = new StringBuilder();
        SB.append("SELECT  finance_shift.ID \t\t\t\t\tAS ID, ").append("finance_trading_day.day \t\t\t\tAS date, ");
        ExperimentalFeature feature = ExperimentalFeature.find("Tips In Accounting");
        if (feature != null && Boolean.TRUE.equals(feature.getBooleanValue(Boolean.FALSE))) {
            SB.append("SUM(finance_transaction.amount_paid + finance_transaction.tip) \tAS amount ,").append("SUM(finance_transaction.amount_paid + finance_transaction.tip)   AS amount_ex_gst, ");
        } else {
            SB.append("SUM(finance_transaction.amount_paid) \tAS amount ,").append("SUM(finance_transaction.amount_paid)   AS amount_ex_gst, ");
        }
        SB.append("finance_unit.Name \t\t\t\t\t\tAS payment_method, ").append("finance_unit.unit_type \t\t\t\tAS unit_type, ").append("config_cashdrawer.name \t\t\t\tAS cash_drawer_name, ").append("finance_unit.ID \t\t\tAS FK_finance_unit, ").append("config_cashdrawer.ID\t \tAS FK_config_cashdrawer, ").append("finance_shift.ID \t\t\tAS FK_finance_shift, ").append("finance_trading_day.ID \tAS FK_finance_trading_day, ").append("config_sales_location.ID \t\t\t\t\tAS FK_config_sales_location , ").append("finance_accounting_group.fk_config_integration_acc_gl_account\tAS FK_config_integration_acc_gl_account, ").append("finance_transaction.ID \tAS FK_finance_transaction ,").append("finance_transaction.FK_finance_transaction \tAS source_finance_transaction ").append("FROM finance_unit  ").append("INNER JOIN finance_transaction ").append("ON finance_transaction.FK_finance_unit = finance_unit.ID ").append("INNER JOIN finance_shift ").append("ON finance_transaction.FK_finance_Shift = finance_shift.ID ").append("LEFT JOIN config_sales_location ").append("\tON finance_transaction.FK_config_sales_location = config_sales_location.ID ").append("INNER JOIN finance_trading_day ").append("ON finance_shift.FK_finance_trading_day = finance_trading_day.ID ").append("INNER JOIN config_cashdrawer ").append(" ON config_cashdrawer.ID = FK_config_cashdrawer ");
        SB.append("INNER JOIN finance_accounting_group ").append("ON finance_unit.FK_finance_accounting_group = finance_accounting_group.ID ");
        SB.append("WHERE finance_shift.ID >= ? AND finance_shift.ID <= ? ").append("AND finance_unit.system_state = 'ACTIVE' ").append("AND finance_unit.unit_type <> 'PETTY_CASH' ").append("AND finance_unit.unit_type <> 'OVER_CHARGE' ").append("AND finance_transaction.system_state = 'ACTIVE' ").append("AND finance_transaction.type <> 'ACCOUNT' ");
        SB.append("GROUP BY finance_shift.ID, ").append("finance_transaction.FK_config_cashdrawer, ").append("finance_transaction.FK_finance_shift,").append("finance_unit.name ");
        return SB.toString();
    }
}

