/*
 * Decompiled with CFR 0.152.
 */
package ordermate.maps.integration.finance;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.cache.CachedFKReference;
import au.com.ordermate.persistence.database.AbstractColumnClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.persistence.database.columnpropertymap.PriceMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ReferenceMapping;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.reports.AccountingSalesReport;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.misc.TradingDay;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import org.apache.commons.collections.map.MultiKeyMap;

public class AccountingSalesReportMap
extends AbstractColumnClassMap {
    private static final double PRICE_ROUNDING = 0.01;
    private static final String ONE_CENT = "0.01";
    private static final String BASE_QUERY = "SELECT\tfinance_shift.ID as ID, finance_trading_day.day as date , SUM((sales_component.item_discount_total + account_discount_total) * sales_item_quantity.quantity) AS total_discount, SUM((sales_component.account_surcharge_total + sales_component.item_surcharge_total) * sales_item_quantity.quantity) AS total_surcharge,SUM(sales_component.unit_price * sales_item_quantity.quantity) AS total_nett, SUM((sales_component.unit_price \t\t+ sales_component.item_discount_total \t\t+ account_discount_total  \t\t- account_surcharge_total\t)* sales_item_quantity.quantity) \t\t\tAS total_gross, sales_component_tax.fk_system_tax_code\t\t\tAS tax_code, SUM(sales_component_tax.value * sales_item_quantity.quantity) AS tax_amount, inventory_group.name \t\t\t\t\t\t\tAS group_name, config_sales_location.name  \t\t\t\tAS location_name, inventory_group.ID \t\t\t\t\t\t\tAS FK_inventory_group ,config_sales_location.ID \t\t\t\t\tAS FK_config_sales_location , finance_trading_day.ID \t\t\t\t\t\tAS FK_finance_trading_day, finance_shift.ID \t\t\t\t\t\t\t\tAS FK_finance_shift, inventory_group.FK_config_integration_acc_gl_account\t\t\tAS FK_config_integration_acc_gl_account FROM sales_component INNER JOIN sales_item \tON sales_component.FK_sales_item = sales_item.ID LEFT JOIN sales_component_tax ON sales_component.ID = sales_component_tax.fk_sales_component INNER JOIN sales_item_quantity \tON sales_item.ID = sales_item_quantity.FK_sales_item LEFT JOIN config_sales_location \tON sales_item_quantity.FK_config_sales_location = config_sales_location.ID INNER JOIN inventory_item \tON inventory_item.ID = sales_component.FK_inventory_item INNER JOIN inventory_group \tON inventory_item.FK_inventory_group = inventory_group.ID INNER JOIN finance_shift \tON sales_item_quantity.FK_finance_shift = finance_shift.ID  INNER JOIN finance_trading_day \tON finance_shift.FK_finance_trading_day = finance_trading_day.ID WHERE \tsales_item_quantity.FK_finance_shift >= ? \tAND sales_item_quantity.FK_finance_shift <= ? ";
    private final ColumnPropertyMapping[] maps;

    public AccountingSalesReportMap() {
        super(AccountingSalesReport.class);
        this.maps = new ColumnPropertyMapping[]{new InstanceVarMapping(AccountingSalesReport.Properties.DATE, "date", null), new PriceMapping(AccountingSalesReport.Properties.DISCOUNT, "total_discount", null, 0.01), new PriceMapping(AccountingSalesReport.Properties.SURCHARGE, "total_surcharge", null, 0.01), new PriceMapping(AccountingSalesReport.Properties.NETT_SALES, "total_nett", null, 0.01), new PriceMapping(AccountingSalesReport.Properties.GROSS_SALES, "total_gross", null, 0.01), new PriceMapping(AccountingSalesReport.Properties.TAX_AMOUNT, "tax_amount", null, 0.01), new InstanceVarMapping(AccountingSalesReport.Properties.GROUP_NAME, "group_name", null), new InstanceVarMapping(AccountingSalesReport.Properties.LOCATION_NAME, "location_name", null), new ReferenceMapping(AccountingSalesReport.Properties.TAX_CODE, "tax_code", new CachedFKReference<TaxCode>(TaxCode.class), null), new ReferenceMapping(AccountingSalesReport.Properties.INVENTORY_GROUP, "FK_inventory_group", new CachedFKReference<InventoryGroup>(InventoryGroup.class), null), new ReferenceMapping(AccountingSalesReport.Properties.SALES_LOCATION, "FK_config_sales_location", new CachedFKReference<SalesLocation>(SalesLocation.class), null), new ReferenceMapping(AccountingSalesReport.Properties.TRADING_DAY, "FK_finance_trading_day", new CachedFKReference<TradingDay>(TradingDay.class), null), new ReferenceMapping(AccountingSalesReport.Properties.SHIFT, "FK_finance_shift", new CachedFKReference<Shift>(Shift.class), null), new ReferenceMapping(AccountingSalesReport.Properties.GL_ACCOUNT, "FK_config_integration_acc_gl_account", new CachedFKReference<GLAccount>(GLAccount.class), null)};
    }

    public static List<AccountingSalesReport> getSalesReport(Shift startShift, Shift endShift) {
        ExperimentalFeature recalculateTAXBySalesAmountFeature;
        if (startShift == null || endShift == null) {
            return null;
        }
        List<AccountingSalesReport> reportList = PersistenceManager.getObjectList(AccountingSalesReport.class, AccountingSalesReportMap.getSelectStmt(), new Object[]{startShift.getID(), endShift.getID()});
        AccountingSalesReportMap.ensureAtLeastOne(reportList, startShift, endShift);
        ExperimentalFeature feature = ExperimentalFeature.find("MYOB Multi Tax Codes");
        if (feature != null) {
            AccountingSalesReportMap.adjustForMultipleTaxesPatWay(reportList);
        }
        if ((recalculateTAXBySalesAmountFeature = ExperimentalFeature.find("Calculate Tax by Sales Amount")) != null && recalculateTAXBySalesAmountFeature.getBooleanValue(true).booleanValue()) {
            AccountingSalesReportMap.recalculateTAXBySalesAmount(reportList);
        }
        return reportList;
    }

    private static void adjustForMultipleTaxes(List<AccountingSalesReport> reportList) {
        List<AccountingSalesReport> reports;
        MultiKeyMap map = new MultiKeyMap();
        for (AccountingSalesReport report : reportList) {
            reports = (List)map.get((Object)report.getShift(), (Object)report.getGroupName(), (Object)report.getSalesLocation());
            if (reports == null) {
                reports = new ArrayList<AccountingSalesReport>();
                map.put((Object)report.getShift(), (Object)report.getGroupName(), (Object)report.getSalesLocation(), reports);
            }
            reports.add(report);
        }
        for (AccountingSalesReport reportObject : map.values()) {
            reports = (ArrayList<AccountingSalesReport>)((Object)reportObject);
            if (reports.size() <= 1) continue;
            AccountingSalesReport mainReport = (AccountingSalesReport)reports.get(0);
            for (int i = 1; i < reports.size(); ++i) {
                AccountingSalesReport report = (AccountingSalesReport)reports.get(i);
                report.setNettSales(report.getTaxAmount());
                report.setGrossSales(report.getTaxAmount());
                report.setSurcharge(Price.ZERO_DOLLAR);
                report.setDiscount(Price.ZERO_DOLLAR);
                mainReport.setGrossSales(mainReport.getGrossSales().subtract(report.getTaxAmount()));
                mainReport.setNettSales(mainReport.getNettSales().subtract(report.getTaxAmount()));
            }
        }
    }

    private static void adjustForMultipleTaxesPatWay(List<AccountingSalesReport> reportList) {
        List<AccountingSalesReport> reports;
        ExperimentalFeature includeManipulation = ExperimentalFeature.find("MYOB Multi Tax Codes");
        List<Pair<String, String>> moveToPair = includeManipulation == null ? null : StringUtils.splitToPairs(includeManipulation.getStringValue(""), ",", ":");
        String main = (String)((Pair)moveToPair.get(0)).getKey();
        HashMap contains = new HashMap();
        for (Pair<String, String> pair : moveToPair) {
            contains.put(pair.key, pair.value);
        }
        MultiKeyMap map = new MultiKeyMap();
        for (AccountingSalesReport report : reportList) {
            reports = (ArrayList<AccountingSalesReport>)map.get((Object)report.getShift(), (Object)report.getGroupName());
            if (reports == null) {
                reports = new ArrayList<AccountingSalesReport>();
                map.put((Object)report.getShift(), (Object)report.getGroupName(), reports);
            }
            reports.add(report);
        }
        for (AccountingSalesReport reportObject : map.values()) {
            AccountingSalesReport report;
            reports = (List)((Object)reportObject);
            if (reports.size() <= 1) continue;
            AccountingSalesReport mainReport = null;
            Iterator iterator = reports.iterator();
            while (iterator.hasNext()) {
                mainReport = report = (AccountingSalesReport)iterator.next();
                if (!report.getTaxCode().getCode().equals(main)) continue;
                mainReport = report;
            }
            for (int i = 0; i < reports.size(); ++i) {
                report = (AccountingSalesReport)reports.get(i);
                String taxCode = report.getTaxCode().getCode();
                if (mainReport == reports.get(i) || !contains.containsKey(taxCode)) continue;
                report.setNettSales(report.getTaxAmount());
                report.setGrossSales(report.getTaxAmount());
                double ratio = 1.0 - 1.0 / (1.0 + report.getTaxCode().getRate());
                Price surchargeTax = report.getSurcharge().multiply(ratio);
                report.setSurcharge(surchargeTax);
                report.setDiscount(Price.ZERO_DOLLAR);
                mainReport.setGrossSales(mainReport.getGrossSales().subtract(report.getTaxAmount()));
                mainReport.setNettSales(mainReport.getNettSales().subtract(report.getTaxAmount()));
                mainReport.setSurcharge(mainReport.getSurcharge().subtract(report.getSurcharge()));
                report.setTaxCode(TaxCode.getNotTaxable());
                report.setTaxAmount(Price.ZERO_DOLLAR);
                report.setGLAccount(GLAccount.getGLAccountForGLCode((String)contains.get(taxCode)));
            }
        }
    }

    private static final void ensureAtLeastOne(List<AccountingSalesReport> reportList, Shift startShift, Shift endShift) {
        List<Shift> shifts = PersistenceManager.getObjectList(Shift.class, new ObjectQuery().select(Shift.class).wherePropertyBetween(Shift.Properties.ID, startShift.getID(), endShift.getID()).toString(), null);
        int index = 0;
        for (Shift shift : shifts) {
            boolean found = false;
            long id = shift.getID();
            for (int i = index; i < reportList.size(); ++i) {
                AccountingSalesReport report = reportList.get(i);
                if (report.getShift().getID() > id) {
                    index = i;
                    break;
                }
                if (report.getShift().getID() != id) continue;
                found = true;
                break;
            }
            if (found) continue;
            reportList.add(index, AccountingSalesReport.generateBlankReport(shift));
        }
    }

    @Override
    public ColumnPropertyMapping[] getRawMappings() {
        return this.maps;
    }

    private static String getGrouping() {
        if (AccountingIntegrationConfig.getInstance().isGroupBySalesLocation() || FinanceExportStyle.Xero.equals((Object)AccountingIntegrationConfig.getInstance().getType())) {
            return "GROUP BY sales_item_quantity.FK_finance_shift, inventory_group.ID, sales_component_tax.FK_system_tax_code, sales_item_quantity.fk_config_sales_location ORDER BY sales_item_quantity.FK_finance_shift, inventory_group.ID, sales_component_tax.FK_system_tax_code, sales_item_quantity.fk_config_sales_location ";
        }
        return "GROUP BY sales_item_quantity.FK_finance_shift, inventory_group.ID, sales_component_tax.FK_system_tax_code ORDER BY sales_item_quantity.FK_finance_shift, inventory_group.ID, sales_component_tax.FK_system_tax_code ";
    }

    private static String getSelectStmt() {
        StringBuffer query = new StringBuffer(BASE_QUERY);
        query.append(AccountingSalesReportMap.getGrouping());
        if (AccountingIntegrationConfig.getInstance().isGroupBySalesLocation()) {
            int idx = query.indexOf("WHERE");
            query.insert(idx, "LEFT JOIN config_integration_acc_group_location_link ON ((config_sales_location.ID = config_integration_acc_group_location_link.fk_config_sales_location) AND (inventory_group.ID = config_integration_acc_group_location_link.fk_inventory_group)) ");
            String GL_CODE_STR = "inventory_group.FK_config_integration_acc_gl_account\t\t\tAS FK_config_integration_acc_gl_account ";
            idx = query.indexOf("inventory_group.FK_config_integration_acc_gl_account\t\t\tAS FK_config_integration_acc_gl_account ");
            query.replace(idx, idx + "inventory_group.FK_config_integration_acc_gl_account\t\t\tAS FK_config_integration_acc_gl_account ".length(), "COALESCE(config_integration_acc_group_location_link.fk_config_integration_acc_gl_account, inventory_group.FK_config_integration_acc_gl_account) AS FK_config_integration_acc_gl_account ");
        }
        return query.append(";").toString();
    }

    public static List<AccountingSalesReport> getSalesReportExcludingZeroAmounts(Shift startShift, Shift endShift) {
        if (startShift == null || endShift == null) {
            return null;
        }
        List<AccountingSalesReport> reportList = PersistenceManager.getObjectList(AccountingSalesReport.class, AccountingSalesReportMap.getSelectStmtExcludingZeroAmounts(), new Object[]{startShift.getID(), endShift.getID()});
        AccountingSalesReportMap.ensureAtLeastOne(reportList, startShift, endShift);
        return reportList;
    }

    private static String getSelectStmtExcludingZeroAmounts() {
        return BASE_QUERY + AccountingSalesReportMap.getGrouping() + "HAVING SUM(sales_component.unit_price * sales_item_quantity.quantity) <> 0;";
    }

    private static void recalculateTAXBySalesAmount(List<AccountingSalesReport> accountingSalesReportList) {
        if (accountingSalesReportList == null || accountingSalesReportList.isEmpty()) {
            return;
        }
        for (AccountingSalesReport accountingSalesReport : accountingSalesReportList) {
            BigDecimal originalTax;
            BigDecimal taxCalculatedBySalesAmount;
            Price totalPrice = accountingSalesReport.getTotal();
            Price taxAmount = accountingSalesReport.getTaxAmount();
            if (totalPrice == null || taxAmount == null || (taxCalculatedBySalesAmount = totalPrice.toBigDecimal().divide(BigDecimal.valueOf(11L), RoundingMode.HALF_EVEN)).subtract(originalTax = taxAmount.toBigDecimal()).abs().compareTo(new BigDecimal(ONE_CENT)) != 0) continue;
            accountingSalesReport.setTaxAmount(new Price(taxCalculatedBySalesAmount, 0.01));
        }
    }
}

