/*
 * Decompiled with CFR 0.152.
 */
package ordermate.maps.inventory;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.FKList;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.persistence.cache.CachedFKList;
import au.com.ordermate.persistence.cache.CachedFKReference;
import au.com.ordermate.persistence.database.AbstractQueryableColumnClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.ColorMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.EnumMapping;
import au.com.ordermate.persistence.database.columnpropertymap.IDMapping;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ListMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ReferenceMapping;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryGroupTriggerLink;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.triggers.activation.StrategyRegister;
import ordermate.database.stock.DecrementStockArea;
import ordermate.database.users.PermissionGroup;

public class InventoryGroupMap
extends AbstractQueryableColumnClassMap {
    public static final String TABLE_NAME = "inventory_group";
    private final ColumnPropertyMapping[] maps;
    private static final ListMapping[] lists = new ListMapping[]{new ListMapping<InventoryGroup>(InventoryGroup.Properties.SUB_GROUPS, new FKList<InventoryGroup>(InventoryGroup.class, InventoryGroup.Properties.PARENT_GROUP).orderBy(InventoryGroup.Properties.SEQUENCE).orderBy(InventoryGroup.Properties.ID).checkActive(true).tearDownLinkBack(true)), new ListMapping<InventoryItem>(InventoryGroup.Properties.MENU_ITEMS, new FKList<InventoryItem>(InventoryItem.class, InventoryItem.Properties.MENU_GROUP).orderBy(InventoryItem.Properties.SEQUENCE).orderBy(InventoryItem.Properties.LABEL).checkActive(true)), new ListMapping<InventoryCombo>(InventoryGroup.Properties.COMBOS, new FKList<InventoryCombo>(InventoryCombo.class, InventoryCombo.Properties.MENU_GROUP).orderBy(InventoryCombo.Properties.SEQUENCE).orderBy(InventoryCombo.Properties.LABEL).checkActive(true)), new ListMapping<InventoryItem>(InventoryGroup.Properties.ALL_ITEMS, new FKList<InventoryItem>(InventoryItem.class, InventoryItem.Properties.MENU_GROUP).orderBy(InventoryItem.Properties.SEQUENCE).orderBy(InventoryItem.Properties.LABEL).checkDeleted(true)), new ListMapping<DecrementStockArea>(InventoryGroup.Properties.DECREMENT_STOCK, new FKList<DecrementStockArea>(DecrementStockArea.class, DecrementStockArea.Properties.INVENTORY_GROUP).deleteOnRemove(true)), new ListMapping<InventoryGroupTriggerLink>(InventoryGroup.Properties.TRIGGER_LINKS, new CachedFKList<InventoryGroupTriggerLink>(InventoryGroupTriggerLink.class, InventoryGroupTriggerLink.Properties.INVENTORY_GROUP).deleteOnRemove(true))};

    public InventoryGroupMap() {
        super(TABLE_NAME, InventoryGroup.class);
        this.maps = new ColumnPropertyMapping[]{new IDMapping(), new InstanceVarMapping(InventoryGroup.Properties.LABEL, "Name"), new InstanceVarMapping(InventoryGroup.Properties.ICON), new ColorMapping(InventoryGroup.Properties.BACKGROUND_COLOR, "RGB_background"), new ColorMapping(InventoryGroup.Properties.FOREGROUND_COLOR, "RGB_foreground"), new InstanceVarMapping(InventoryGroup.Properties.EXTERNAL_ID, "external_id"), new InstanceVarMapping(InventoryGroup.Properties.SEQUENCE), new InstanceVarMapping(InventoryGroup.Properties.SYSTEM_STATE, "system_state"), new InstanceVarMapping(InventoryGroup.Properties.MASTER_ID, "masterId"), new ReferenceMapping(InventoryGroup.Properties.DEFAULT_CATEGORY, "FK_inventory_category", new CachedFKReference<InventoryCategory>(InventoryCategory.class)), new ReferenceMapping(InventoryGroup.Properties.PARENT_GROUP, "FK_inventory_group", new CachedFKReference<InventoryGroup>(InventoryGroup.class).collapseOnSerialize(true)), new ReferenceMapping(InventoryGroup.Properties.PROFILE, "FK_inventory_profile", new CachedFKReference<InventoryProfile>(InventoryProfile.class).collapseOnSerialize(true)), new EnumMapping(InventoryGroup.Properties.TRIGGER_ACTIVATION_STRATEGY, "trigger_activation_strategy", false, StrategyRegister.getRegister()), new ReferenceMapping(InventoryGroup.Properties.GL_ACCOUNT, "FK_config_integration_acc_gl_account", new CachedFKReference<GLAccount>(GLAccount.class).collapseOnSerialize(true)), new ReferenceMapping(InventoryGroup.Properties.PERMISSION_GROUP, "FK_config_permission_group", new CachedFKReference<PermissionGroup>(PermissionGroup.class).collapseOnSerialize(true))};
    }

    @Override
    public ColumnPropertyMapping[] getRawMappings() {
        return this.maps;
    }

    @Override
    public ListMapping[] getListMappings() {
        return lists;
    }

    @Override
    public void preload(PersistentObjectI toLoad) {
        if (Config.isConfigSetup() && Config.getBooleanValue("no_preload_inventory_groups")) {
            OrderMate.LOG.info("Not preloading or clearing cache for inventoryItemGroup");
            return;
        }
        ExperimentalFeature exp = ExperimentalFeature.find("Skip Section Preload Clear Cache");
        if (exp != null && exp.getBooleanValue(Boolean.FALSE).booleanValue()) {
            OrderMate.LOG.info("Not clearing cache for inventoryItemGroup");
        } else {
            CacheManager.getInstance().clearEntireCache();
        }
        InventoryGroup group = (InventoryGroup)toLoad;
        for (InventoryGroup subGroup : group.getSubGroups()) {
            this.preload(subGroup);
        }
        this.preload(group.getItems());
        group.getTriggerLinks();
        for (InventoryCombo combo : group.getCombos()) {
            for (InventoryComboGroup comboGroup : combo.getGroups()) {
                this.preload(comboGroup.getItems());
            }
        }
    }

    private void preload(List items) {
        for (InventoryItem item : items) {
            for (InventoryItemUnit unit : item.getUnits()) {
                unit.getSize();
                unit.getPortion();
                unit.getIngredientCostExTax();
                unit.getLabel();
                for (InventoryOptionGroupLink link : unit.getOptionGroupLinks()) {
                    link.getOptionGroup().getOptions();
                }
                for (UnitPriceLevel unitPriceLevel : unit.getPrices()) {
                    unitPriceLevel.getPriceLevel().getTriggers().size();
                }
            }
        }
    }
}

