/*
 * Decompiled with CFR 0.152.
 */
package ordermate.maps.sales;

import au.com.ordermate.persistence.FKList;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.cache.CachedFKList;
import au.com.ordermate.persistence.cache.CachedFKReference;
import au.com.ordermate.persistence.database.AbstractSuperClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.BooleanMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.DateMapping;
import au.com.ordermate.persistence.database.columnpropertymap.EnumMapping;
import au.com.ordermate.persistence.database.columnpropertymap.IDMapping;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ListMapping;
import au.com.ordermate.persistence.database.columnpropertymap.PriceMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ReferenceMapping;
import au.com.ordermate.persistence.database.columnpropertymap.TimeMapping;
import au.com.ordermate.persistence.database.columnpropertymap.TimestampMapping;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TakeawayTicketData;
import ordermate.database.sales.coupon.SalesCouponUsage;
import ordermate.database.users.LockingUserReference;
import ordermate.database.users.User;

public class AccountMap
extends AbstractSuperClassMap {
    private final ColumnPropertyMapping[] properties;
    private final ListMapping[] listMappings;

    public AccountMap() {
        super("sales_account", Account.class);
        this.properties = new ColumnPropertyMapping[]{new IDMapping(), new EnumMapping(Account.Properties.ACCOUNT_TYPE, "account_type", false, AccountType.register), new EnumMapping(Account.Properties.ACCOUNT_STATE, "account_state", false, AccountState.getRegister()), new TimestampMapping(Account.Properties.CREATION_DATE_TIME, "Creation_time"), new EnumMapping(Account.Properties.RECEIPT_STATE, "receipt_state", false, Account.ReceiptPrintState.register), new PriceMapping(Account.Properties.SAVED_TOTAL, "saved_total", 0.01), new BooleanMapping(Account.Properties.ON_HOLD, "on_hold"), new ReferenceMapping(Account.Properties.CUSTOMER, "FK_sales_customer", new CachedFKReference<Customer>(Customer.class).collapseOnSerialize(true)), new ReferenceMapping(Account.Properties.USER, "FK_config_user", false, new LockingUserReference(Account.Properties.USER).collapseOnSerialize(true)), new ReferenceMapping(Account.Properties.OPENING_USER, "FK_config_user_opened", false, new CachedFKReference<User>(User.class).collapseOnSerialize(true)), new ReferenceMapping(Account.Properties.ASSIGNED_USER, "FK_config_user_assigned", false, new CachedFKReference<User>(User.class).collapseOnSerialize(true)), new ReferenceMapping(Account.Properties.CLOSING_USER, "FK_config_user_closed", false, new CachedFKReference<User>(User.class).collapseOnSerialize(true)), new ReferenceMapping(Account.Properties.TRADING_DAY, "FK_finance_trading_day", new CachedFKReference<TradingDay>(TradingDay.class).collapseOnSerialize(true)), new ReferenceMapping(Account.Properties.SHIFT, "FK_finance_shift", new CachedFKReference<Shift>(Shift.class).collapseOnSerialize(true)), new ReferenceMapping(Account.Properties.SALES_LOCATION, "fk_config_sales_location", new CachedFKReference<SalesLocation>(SalesLocation.class).collapseOnSerialize(true)), new InstanceVarMapping(Account.Properties.NUM_PATRONS, "patrons"), new InstanceVarMapping(Account.Properties.CARD_ID, "card_id"), new InstanceVarMapping(Account.Properties.COMMENT, "comment"), new TimestampMapping(Account.Properties.ETA, "eta").setAllowNulls(true), new TimeMapping(Account.Properties.TIME_DUE, "Time_Due"), new DateMapping(Account.Properties.DATE_DUE, "Date_Due"), new InstanceVarMapping(Account.Properties.PREP_PRINT_DUE, "prep_docket_print_time"), new TimestampMapping(Account.Properties.CLOSED_DATE_TIME, "closed_time").setAllowNulls(true), new TimestampMapping(Account.Properties.MOD_DATE_TIME, "mod_time").setAllowNulls(true), new InstanceVarMapping(Account.Properties.EXT_HREF, "ext_href"), new InstanceVarMapping(Account.Properties.SOURCE), new InstanceVarMapping(Account.Properties.EXT_DOCKET_HREF, "ext_docket_href"), new InstanceVarMapping(Account.Properties.EXT_ORDER_ID, "ext_order_id"), new InstanceVarMapping(Account.Properties.EXT_ORDER_DATE_TIME, "ext_order_date_time"), new InstanceVarMapping(Account.Properties.EXT_ORIGIN, "ext_origin")};
        this.listMappings = new ListMapping[]{new ListMapping<SalesLineItem>(Account.Properties.ITEMS, new FKList<SalesLineItem>(SalesLineItem.class, SalesLineItem.Properties.ACCOUNT).whereClause("sales_item.fK_sales_combo is null").orderBy(SalesLineItem.Properties.ID)), new ListMapping<FinanceTransaction>(Account.Properties.ALL_FINANCE_TRANSACTIONS, new FKList<FinanceTransaction>(FinanceTransaction.class, FinanceTransaction.Properties.ACCOUNT).orderBy(FinanceTransaction.Properties.ID).deleteOnRemove(true).tearDownLinkBack(false)), new ListMapping<DebtorSale>(Account.Properties.DEBTOR_SALE, new FKList<DebtorSale>(DebtorSale.class, DebtorSale.Properties.SALE_ACCOUNT).deleteOnRemove(true).tearDownLinkBack(false)), new ListMapping<SalesPriceAdjustment>(Account.Properties.ADJUSTMENTS, new FKList<SalesPriceAdjustment>(SalesPriceAdjustment.class, SalesPriceAdjustment.Properties.ACCOUNT).deleteOnRemove(true).orderBy(SalesPriceAdjustment.Properties.ID).tearDownLinkBack(true)), new ListMapping<TakeawayTicketData>(Account.Properties.TICKET_DATA, new FKList<TakeawayTicketData>(TakeawayTicketData.class, TakeawayTicketData.Properties.ACCOUNT)), new ListMapping<SalesCouponUsage>(Account.Properties.COUPON_USAGES, new FKList<SalesCouponUsage>(SalesCouponUsage.class, SalesCouponUsage.Properties.ACCOUNT)), new ListMapping<GiftVoucherTransaction>(Account.Properties.VOUCHER_TXNS, new CachedFKList<GiftVoucherTransaction>(GiftVoucherTransaction.class, GiftVoucherTransaction.Properties.ACCOUNT))};
    }

    @Override
    public String getDiscriminatorColumn() {
        return "acc_class";
    }

    @Override
    protected ColumnPropertyMapping[] getRawSuperClassMappings() {
        return this.properties;
    }

    @Override
    protected ListMapping[] getSuperClassListMappings() {
        return this.listMappings;
    }

    @Override
    public void preload(PersistentObjectI toLoad) {
        Account account = (Account)toLoad;
        account.getTotal();
        for (SalesLineItem lineItem : account.getAllItems()) {
            for (SalesItem item : lineItem.getSalesItems()) {
                item.getLabel();
                item.hasFinanceTransactions();
                item.getComponentList();
                item.getPriceAdjustments();
                item.getSalesItemQuantities();
            }
        }
    }
}

