/*
 * Decompiled with CFR 0.152.
 */
package ordermate.maps.sales;

import au.com.ordermate.persistence.cache.CachedFKReference;
import au.com.ordermate.persistence.database.AbstractQueryableColumnClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.IDMapping;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ReferenceMapping;
import au.com.ordermate.persistence.database.columnpropertymap.SalesQuantityMapping;
import au.com.ordermate.persistence.database.columnpropertymap.TimestampMapping;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;

public class SalesItemQuantityMap
extends AbstractQueryableColumnClassMap {
    public static final String TABLE_NAME = "sales_item_quantity";
    private final ColumnPropertyMapping[] maps;

    public SalesItemQuantityMap() {
        super(TABLE_NAME, SalesItemQuantity.class);
        this.maps = new ColumnPropertyMapping[]{new IDMapping(), new SalesQuantityMapping(SalesItemQuantity.Properties.QUANTITY, "quantity"), new InstanceVarMapping(SalesItemQuantity.Properties.ITEM_STATE, "item_state"), new InstanceVarMapping(SalesItemQuantity.Properties.PRINT_STATE, "print_state"), new TimestampMapping(SalesItemQuantity.Properties.CREATION_TIME, "creation_time"), new ReferenceMapping(SalesItemQuantity.Properties.SALES_LINE_ITEM, "FK_sales_item", new CachedFKReference<SalesLineItem>(SalesLineItem.class)), new ReferenceMapping(SalesItemQuantity.Properties.USER, "FK_config_user", new CachedFKReference<User>(User.class).collapseOnSerialize(true)), new ReferenceMapping(SalesItemQuantity.Properties.TERMINAL, "FK_config_terminal", new CachedFKReference<Terminal>(Terminal.class).collapseOnSerialize(true)), new ReferenceMapping(SalesItemQuantity.Properties.TRADING_DAY, "FK_finance_trading_day", new CachedFKReference<TradingDay>(TradingDay.class).collapseOnSerialize(true)), new ReferenceMapping(SalesItemQuantity.Properties.SHIFT, "FK_finance_shift", new CachedFKReference<Shift>(Shift.class).collapseOnSerialize(true)), new ReferenceMapping(SalesItemQuantity.Properties.LOCATION, "FK_config_terminal_location", new CachedFKReference<TerminalLocation>(TerminalLocation.class).collapseOnSerialize(true)), new ReferenceMapping(SalesItemQuantity.Properties.SALES_LOCATION, "FK_config_sales_location", new CachedFKReference<SalesLocation>(SalesLocation.class).collapseOnSerialize(true))};
    }

    @Override
    public ColumnPropertyMapping[] getRawMappings() {
        return this.maps;
    }

    public static class Reports {

        public static class GetDiscount {
            private static final String query_prefix_discount = "SELECT 1 as 'ID', SUM((sales_component.item_discount_total + sales_component.account_discount_total) * sales_item_quantity.quantity) * -1 AS Discount_Amount";
            private static final String query_prefix_surcharge = "SELECT SUM((sales_component.item_surcharge_total + sales_component.account_surcharge_total) * sales_item_quantity.quantity) AS Surcharge_Amount";
            private static final String query_join_where = " FROM sales_item_quantity INNER JOIN sales_item ON sales_item.ID = sales_item_quantity.FK_sales_item INNER JOIN sales_account ON sales_item.FK_sales_account = sales_account.ID INNER JOIN sales_component ON sales_component.FK_sales_item = sales_item.ID WHERE";
            public static final String restrict_by_date = " sales_item_quantity.creation_time BETWEEN ? AND ? ";
            public static final String QUERY_DISCOUNT_BY_DATE = "SELECT 1 as 'ID', SUM((sales_component.item_discount_total + sales_component.account_discount_total) * sales_item_quantity.quantity) * -1 AS Discount_Amount FROM sales_item_quantity INNER JOIN sales_item ON sales_item.ID = sales_item_quantity.FK_sales_item INNER JOIN sales_account ON sales_item.FK_sales_account = sales_account.ID INNER JOIN sales_component ON sales_component.FK_sales_item = sales_item.ID WHERE sales_item_quantity.creation_time BETWEEN ? AND ? ";
            public static final String QUERY_SURCHARGE_BY_DATE = "SELECT SUM((sales_component.item_surcharge_total + sales_component.account_surcharge_total) * sales_item_quantity.quantity) AS Surcharge_Amount FROM sales_item_quantity INNER JOIN sales_item ON sales_item.ID = sales_item_quantity.FK_sales_item INNER JOIN sales_account ON sales_item.FK_sales_account = sales_account.ID INNER JOIN sales_component ON sales_component.FK_sales_item = sales_item.ID WHERE sales_item_quantity.creation_time BETWEEN ? AND ? ";
        }
    }
}

