/*
 * Decompiled with CFR 0.152.
 */
package ordermate.microserver;

import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import ordermate.OrderMate;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;

public class MicroServer {
    private int port = 8228;
    private HttpServlet servlet;
    private String path = "/";
    private ServletHolder holder;
    private Server server;

    public MicroServer(int port, String path, HttpServlet servlet) {
        if (port > 0 && port <= 65535) {
            this.port = port;
        }
        if (path != null) {
            this.path = path;
        }
        this.servlet = servlet;
    }

    public void prime() {
        this.server = new Server(this.port);
        this.holder = new ServletHolder((Servlet)this.servlet);
        WebAppContext context = new WebAppContext();
        context.setContextPath(this.path);
        context.setResourceBase("");
        context.addServlet(this.holder, "/*");
        this.server.setHandler((Handler)context);
    }

    public boolean tryStart() {
        try {
            this.server.start();
            OrderMate.LOG.info("Started Micro Server with " + this.servlet + " on " + this.port + " " + this.path);
            return true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot start the micro server", (Throwable)ex);
            return false;
        }
    }

    public boolean tryStop() {
        try {
            if (this.server != null && (this.server.isStarted() || this.server.isRunning())) {
                this.server.stop();
                OrderMate.LOG.info("Stopped Micro Server");
            }
            return true;
        }
        catch (InterruptedException ex) {
            return true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot stop the micro server", (Throwable)ex);
            return false;
        }
    }
}

