/*
 * Decompiled with CFR 0.152.
 */
package ordermate.misc;

import au.com.ordermate.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URL;
import java.util.List;
import ordermate.OrderMate;
import ordermate.misc.GeocodeLocation;
import ordermate.misc.ObjectMarshaller;

public class GeocodingHelper {
    private final String GEO_URL_PART1 = "http://maps.google.com/maps/geo?q=";
    private final String GEO_URL_PART2 = "&output=csv&oe=utf8&sensor=false";
    private final String DEFAULT_BASE_URL = "http://maps.googleapis.com/maps/api/geocode/json?address=";
    private final String GEO_URL_NEW_PART2 = "&sensor=false";
    private final String SEPERATOR = ",";
    private final String SUCCESSFULL_RESPONSE = "200";
    private String baseUrl = "http://maps.googleapis.com/maps/api/geocode/json?address=";

    public GeocodingHelper() {
    }

    public GeocodingHelper(String baseUrl) {
        this.baseUrl = baseUrl != null ? baseUrl : "http://maps.googleapis.com/maps/api/geocode/json?address=";
    }

    public String getGeocodeForAddress(String address) {
        try {
            String response = this.constructAndSendRequest(address);
            return this.parseWebserviceCsvResponse(response);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error retrieving geocode for address: " + address, (Throwable)ex);
            return "";
        }
    }

    public GeocodeLocation getGeocodeLocationForAddress(String address) {
        String response = this.constructAndSendRequest(address);
        GeocodeLocation location = this.getGeocodeLocation(response);
        return location;
    }

    private GeocodeLocation getGeocodeLocation(String toMarshall) {
        ObjectMarshaller marshaller = new ObjectMarshaller();
        List<JsonNode> results = marshaller.searchJsonNode(toMarshall, "location");
        if (results == null || results.size() < 1) {
            OrderMate.LOG.debug("failed to obtain the location to parse from the json string");
            return null;
        }
        GeocodeLocation location = marshaller.unmarshal(results.get(0).toString(), GeocodeLocation.class);
        return location;
    }

    private String constructAndSendRequest(String address) {
        try {
            URL url = new URL(this.baseUrl + address.replace(" ", "+") + "&sensor=false");
            return StringUtils.readFromStream(url.openStream(), -1);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error retrieving geocode for address: " + address, (Throwable)ex);
            return "";
        }
    }

    @Deprecated
    private String parseWebserviceCsvResponse(String response) {
        try {
            int idx;
            String resultCode;
            if (!response.isEmpty() && (resultCode = response.substring(0, idx = response.indexOf(","))).equals("200")) {
                idx = response.indexOf(",", idx + 1);
                return response.substring(idx + 1);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error parsing geocode result: ", (Throwable)ex);
        }
        return "";
    }
}

