/*
 * Decompiled with CFR 0.152.
 */
package ordermate.misc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;

public class ObjectMarshaller {
    protected ObjectMapper mapper;

    public ObjectMarshaller() {
        this.initMapper();
    }

    protected void initMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            JacksonAnnotationIntrospector introspector = new JacksonAnnotationIntrospector();
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.mapper.getDeserializationConfig().with((AnnotationIntrospector)introspector);
            this.mapper.getSerializationConfig().with((AnnotationIntrospector)introspector);
        }
    }

    public <T> T unmarshal(String value, Class<T> toCreate) {
        if (value == null || value.isEmpty()) {
            OrderMate.LOG.error("Cannot unmarshal empty string");
            return null;
        }
        Object unmarshalled = null;
        try {
            unmarshalled = this.mapper.readValue(Charset.forName("UTF-8").encode(value).array(), toCreate);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot read in Object of type " + toCreate, (Throwable)ex);
        }
        return (T)unmarshalled;
    }

    public <T> List<T> unmarshalList(String value, Class valueClass) {
        if (value == null || value.isEmpty()) {
            OrderMate.LOG.error("Cannot unmarshal empty string");
            return null;
        }
        ArrayList unmarshalled = new ArrayList();
        try {
            CollectionType type = CollectionType.construct(ArrayList.class, (JavaType)SimpleType.construct((Class)valueClass));
            Object toReturn = this.mapper.readValue(Charset.forName("UTF-8").encode(value).array(), (JavaType)type);
            unmarshalled = (ArrayList)toReturn;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot read in List of Object of type " + valueClass, (Throwable)ex);
        }
        return unmarshalled;
    }

    public String marshal(Object toMarshal) {
        String output = "";
        if (toMarshal == null) {
            OrderMate.LOG.error("Cannot marshal a null object");
        } else {
            try {
                output = this.mapper.writeValueAsString(toMarshal);
            }
            catch (JsonProcessingException ex) {
                OrderMate.LOG.error("Cannot marshal object into JSON format", (Throwable)ex);
            }
        }
        return output;
    }

    public List<JsonNode> searchJsonNode(String jsonString, String searchValue) {
        JsonNode node = null;
        try {
            node = (JsonNode)this.mapper.readValue(jsonString, JsonNode.class);
        }
        catch (JsonProcessingException ex) {
            OrderMate.LOG.error("Cannot marshal object into JSON format", (Throwable)ex);
        }
        catch (IOException e) {
            OrderMate.LOG.error("Cannot marshal object into JSON format", (Throwable)e);
        }
        if (node != null) {
            return node.findValues(searchValue);
        }
        return null;
    }

    public void setSerializationInclusion(JsonInclude.Include jsonInclude) {
        this.mapper.setSerializationInclusion(jsonInclude);
    }
}

