/*
 * Decompiled with CFR 0.152.
 */
package ordermate.misc.logging;

import java.util.Map;
import ordermate.database.misc.SystemProperty;
import ordermate.database.users.User;
import ordermate.misc.logging.DisabledErrorTracker;
import ordermate.misc.logging.ErrorTracker;
import ordermate.misc.logging.ErrorTrackingProvider;
import ordermate.misc.logging.filter.ErrorFilterType;
import ordermate.misc.logging.filter.ErrorTrackingFilter;
import ordermate.misc.logging.sentry.SentryErrorTracker;

public enum ErrorTrackingManager implements ErrorTracker
{
    GET;

    private final ErrorTrackingFilter filter = new ErrorTrackingFilter();

    private ErrorTracker getErrorTrackerImplementation() {
        ErrorTrackingProvider provider = SystemProperty.getInstance().getErrorTrackingProvider();
        if (ErrorTrackingProvider.Sentry.equals((Object)provider)) {
            return new SentryErrorTracker();
        }
        return new DisabledErrorTracker();
    }

    @Override
    public void initialise(String projectKey) {
        this.getErrorTrackerImplementation().initialise(projectKey);
    }

    @Override
    public void setPosUser(User user) {
        this.getErrorTrackerImplementation().setPosUser(user);
    }

    @Override
    public void clearBreadcrumbs() {
        this.getErrorTrackerImplementation().clearBreadcrumbs();
    }

    @Override
    public void addBreadcrumb(String category, String message, Map<String, String> data) {
        this.getErrorTrackerImplementation().addBreadcrumb(category, message, data);
    }

    @Override
    public void captureEvent(String message, String details) {
        this.getErrorTrackerImplementation().captureEvent(message, details);
    }

    public boolean allowEvent(ErrorFilterType type, String detail) {
        if (type == null || detail == null) {
            return true;
        }
        if (ErrorFilterType.Package.equals((Object)type)) {
            return this.filter.allowEventFromPackage(detail);
        }
        if (ErrorFilterType.Class.equals((Object)type)) {
            return this.filter.allowEventFromClass(detail);
        }
        if (ErrorFilterType.Message.equals((Object)type)) {
            return this.filter.allowEventWithMessage(detail);
        }
        return true;
    }
}

