/*
 * Decompiled with CFR 0.152.
 */
package ordermate.misc.logging.filter;

import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.ClientHandlerException;
import java.io.IOException;
import java.net.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.config.ExperimentalFeature;

public class ErrorTrackingFilter {
    static final String EXP_PACKAGE_EXCLUSIONS = "ErrorTracking_PackageExclusions";
    static final String EXP_CLASS_EXCLUSIONS = "ErrorTracking_ClassExclusions";
    private final List<String> exceptionPackageExclusions = new ArrayList<String>();
    private final List<String> classExclusions = new ArrayList<String>();
    private final List<String> errorMessageExclusions = new ArrayList<String>();

    public ErrorTrackingFilter() {
        this.initialiseEventFilterLists();
        this.addEventFiltersFromDatabase();
    }

    private void initialiseEventFilterLists() {
        this.classExclusions.add(ConnectException.class.getName());
        this.classExclusions.add(java.rmi.ConnectException.class.getName());
        this.classExclusions.add(java.net.UnknownHostException.class.getName());
        this.classExclusions.add(UnknownHostException.class.getName());
        this.classExclusions.add(ClientHandlerException.class.getName());
        this.classExclusions.add(IOException.class.getName());
        this.classExclusions.add(ConnectIOException.class.getName());
        this.errorMessageExclusions.add("is already bound");
        this.errorMessageExclusions.add("Cannot retrieve Coupon authority from ServerMate, Not shared?");
    }

    private void addEventFiltersFromDatabase() {
        ExperimentalFeature feature = ExperimentalFeature.find(EXP_PACKAGE_EXCLUSIONS);
        if (feature != null) {
            this.exceptionPackageExclusions.addAll(StringUtils.splitToList(feature.getStringValue(""), ","));
        }
        if ((feature = ExperimentalFeature.find(EXP_CLASS_EXCLUSIONS)) != null) {
            this.classExclusions.addAll(StringUtils.splitToList(feature.getStringValue(""), ","));
        }
    }

    public boolean allowEventFromPackage(String packageName) {
        return !this.exceptionPackageExclusions.contains(packageName);
    }

    public boolean allowEventFromClass(String className) {
        return !this.classExclusions.contains(className);
    }

    public boolean allowEventWithMessage(String message) {
        for (String exclusion : this.errorMessageExclusions) {
            if (!message.contains(exclusion)) continue;
            return false;
        }
        return true;
    }
}

