/*
 * Decompiled with CFR 0.152.
 */
package ordermate.misc.logging.sentry;

import io.sentry.Sentry;
import io.sentry.SentryClient;
import io.sentry.event.BreadcrumbBuilder;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.UserBuilder;
import io.sentry.event.helper.ShouldSendEventCallback;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryException;
import io.sentry.event.interfaces.SentryInterface;
import io.sentry.event.interfaces.StackTraceInterface;
import java.util.Date;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.users.User;
import ordermate.misc.logging.ErrorTracker;
import ordermate.misc.logging.ErrorTrackingManager;
import ordermate.misc.logging.filter.ErrorFilterType;

public class SentryErrorTracker
implements ErrorTracker,
ShouldSendEventCallback {
    @Override
    public void initialise(String projectKey) {
        SentryClient client = Sentry.init((String)("https://a686bff75df54abfb9cce9987e733484:3b1371748fa0404fac97533b6659e3b9@sentry.io/" + projectKey));
        client.addShouldSendEventCallback((ShouldSendEventCallback)this);
        this.updateContext();
    }

    @Override
    public void captureEvent(String message, String details) {
        Sentry.capture((Event)new EventBuilder().withMessage(message).withTransaction(details).withTimestamp(new Date()).withEnvironment(System.getProperty("java.version")).withDist(OrderMate.OM_VERSION.toString()).build());
        this.clearBreadcrumbs();
    }

    @Override
    public void setPosUser(User user) {
        Sentry.getContext().removeExtra("pos_user");
        Sentry.getContext().addExtra("pos_user", (Object)user.getName());
        try {
            this.updateContext();
        }
        catch (Exception e) {
            OrderMate.LOG.error("Failed to update the Sentry context! Version and site info will be missing!", (Throwable)e);
        }
    }

    @Override
    public void clearBreadcrumbs() {
        Sentry.getContext().clearBreadcrumbs();
    }

    @Override
    public void addBreadcrumb(String category, String message, Map<String, String> data) {
        BreadcrumbBuilder builder = new BreadcrumbBuilder().setTimestamp(new Date()).setMessage(message);
        if (category != null) {
            builder.setCategory(category);
        }
        if (data != null) {
            builder.setData(data);
        }
        Sentry.getContext().recordBreadcrumb(builder.build());
    }

    private void updateContext() {
        Sentry.getContext().removeExtra("pos_version");
        Sentry.getContext().addExtra("pos_version", (Object)OrderMate.OM_VERSION.toString());
        Sentry.getContext().setUser(new UserBuilder().setId(String.valueOf(SystemCurrentInfo.getInstance().getUpdatemateId())).setUsername(BusinessInfo.getInstance().getName()).build());
    }

    public boolean shouldSend(Event event) {
        OrderMate.LOG.debug("Intercepted Sentry event, should we filter it?");
        if (!ErrorTrackingManager.GET.allowEvent(ErrorFilterType.Message, event.getMessage())) {
            this.logFilteredEvent(event);
            return false;
        }
        if (event.getSentryInterfaces() == null) {
            return true;
        }
        for (SentryInterface si : event.getSentryInterfaces().values()) {
            String className;
            StackTraceInterface sti;
            if (si instanceof ExceptionInterface) {
                for (SentryException ex : ((ExceptionInterface)si).getExceptions()) {
                    if (ErrorTrackingManager.GET.allowEvent(ErrorFilterType.Package, ex.getExceptionPackageName()) && ErrorTrackingManager.GET.allowEvent(ErrorFilterType.Class, ex.getExceptionClassName()) && ErrorTrackingManager.GET.allowEvent(ErrorFilterType.Message, ex.getExceptionMessage())) continue;
                    this.logFilteredEvent(event);
                    return false;
                }
            }
            if (!(si instanceof StackTraceInterface) || (sti = (StackTraceInterface)si).getStackTrace().length <= 0 || ErrorTrackingManager.GET.allowEvent(ErrorFilterType.Class, className = sti.getStackTrace()[0].getFileName().replace(".java", "").replace(".groovy", ""))) continue;
            this.logFilteredEvent(event);
            return false;
        }
        OrderMate.LOG.debug("Nope, this one is clean. Sending up event: " + event);
        return true;
    }

    private void logFilteredEvent(Event event) {
        OrderMate.LOG.debug("Yes we should! Filtering event: " + event);
    }
}

