/*
 * Decompiled with CFR 0.152.
 */
package ordermate.observers;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PersistentObjectSnapshotDiff;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import ordermate.OrderMate;
import ordermate.database.diff.VersionControl;
import ordermate.database.diff.VersionDiff;
import ordermate.diff.BusinessExportMapping;
import ordermate.diff.BusinessExportRefMapping;
import ordermate.observers.PersistenceChangeListener;

public class PropertyVersionListener
extends PersistenceChangeListener {
    private Semaphore talkingStick = new Semaphore(1);
    private volatile boolean busy = false;
    private Map<ObjectVersion, List<VersionDiff>> objectDiffs = new HashMap<ObjectVersion, List<VersionDiff>>();

    public PropertyVersionListener(VersionControl versionControl) {
        super(versionControl);
    }

    @Override
    public boolean fireAction(PersistentObjectSnapshotDiff event) {
        if (this.propVersionControl != null) {
            this.talkingStick.tryAcquire(5L, TimeUnit.SECONDS);
            try {
                this.busy = true;
                if (PersistentObjectSnapshotDiff.ALL_DONE == event) {
                    if (!this.objectDiffs.isEmpty()) {
                        this.incrementVersion();
                    }
                } else {
                    this.processDiff(event);
                }
                boolean bl = true;
                this.talkingStick.release();
                this.busy = false;
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.talkingStick.release();
                    this.busy = false;
                    throw throwable;
                }
                catch (InterruptedException e) {
                    OrderMate.LOG.error("Interrupted while grabbing the talking stick", (Throwable)e);
                }
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.busy;
    }

    private void incrementVersion() {
        for (List<VersionDiff> diffs : this.objectDiffs.values()) {
            for (VersionDiff diff : (Iterable)diffs) {
                PersistenceManager.save(diff);
            }
        }
        this.objectDiffs.clear();
        long currentVersion = this.propVersionControl.getCurrentVersion();
        this.propVersionControl.setCurrentVersion(currentVersion + 1L);
        this.propVersionControl.save();
    }

    private void processDiff(PersistentObjectSnapshotDiff snapShotDiffs) {
        switch (snapShotDiffs.getChangeType()) {
            case Creation: {
                this.performCreationDeletion(snapShotDiffs.getNewSnapshot(), VersionDiff.ChangeType.Creation);
                break;
            }
            case Update: {
                this.performUpdate(snapShotDiffs.getOldSnapshot(), snapShotDiffs.getNewSnapshot());
                break;
            }
            case Deletion: {
                this.performCreationDeletion(snapShotDiffs.getOldSnapshot(), VersionDiff.ChangeType.Deletion);
                break;
            }
        }
    }

    private void performCreationDeletion(PersistentObjectSnapshot snapShot, VersionDiff.ChangeType change) {
        if (this.mapContainer.isIDMappingExist(snapShot.getObjectType())) {
            long objectId = snapShot.get(PersistentObject.Properties.ID);
            PropertiedObject.Property changedProp = PropertiedObject.PropsHelper.getProperties(snapShot.getObjectType()).getProperty("ID");
            this.createVersionDiff(objectId, change, changedProp);
        }
        this.createVersionForReferences(snapShot);
    }

    private void createVersionDiff(long objectId, VersionDiff.ChangeType changeT, PropertiedObject.Property changedProp) {
        VersionDiff propertyCreation = new VersionDiff(objectId, changedProp, changeT, this.propVersionControl, this.propVersionControl.getCurrentVersion() + 1L);
        ObjectVersion ver = new ObjectVersion(changedProp.getOwner(), objectId);
        List<VersionDiff> diffs = this.objectDiffs.get(ver);
        if (diffs == null) {
            diffs = new ArrayList<VersionDiff>();
            this.objectDiffs.put(ver, diffs);
        }
        if (!changeT.equals((Object)VersionDiff.ChangeType.Deletion) && !this.diffsContainChange(diffs, VersionDiff.ChangeType.Update, changedProp)) {
            diffs.add(propertyCreation);
        } else {
            diffs.clear();
            if (!this.diffsContainChange(diffs, VersionDiff.ChangeType.Creation, changedProp)) {
                diffs.add(propertyCreation);
            }
        }
    }

    private boolean diffsContainChange(List<VersionDiff> diffs, VersionDiff.ChangeType changeT, PropertiedObject.Property changedProp) {
        for (VersionDiff diff : diffs) {
            if (!diff.getChangeType().equals((Object)changeT)) continue;
            if (!changeT.equals((Object)VersionDiff.ChangeType.Update)) {
                return true;
            }
            if (!diff.getChangedProperty().equals(changedProp)) continue;
            return true;
        }
        return false;
    }

    private void createVersionForReferences(PersistentObjectSnapshot snapShot) {
        List<BusinessExportRefMapping> refProps = this.mapContainer.getRefMappingsByClass(snapShot.getObjectType());
        if (refProps != null) {
            for (BusinessExportRefMapping refExpProp : refProps) {
                this.processReference(snapShot, refExpProp);
            }
        }
    }

    private void processReference(PersistentObjectSnapshot snapShot, BusinessExportRefMapping refExpProp) {
        long parentRefId;
        PropertiedObject po;
        Object refParentId = snapShot.get(refExpProp.getRefPropertyAccessor().getBaseProperty());
        if (refParentId != null && (po = PersistenceManager.getByID(parentRefId = ((Long)refParentId).longValue(), refExpProp.getBusinessPropertyAccessor().getProperty().getOwner())) != null) {
            this.createVersionForReference((PersistentObject)po, refExpProp);
        }
    }

    private void createVersionForReference(PersistentObject po, BusinessExportRefMapping refProp) {
        if (this.isRefPropOwnerDirectParent(po, refProp)) {
            if (!this.hasDeletedSystemState(po.getLastSavedSnapshot())) {
                this.createVersionDiff(po.getID(), VersionDiff.ChangeType.Update, refProp.getBusinessPropertyAccessor().getBaseProperty());
            }
        } else {
            this.processIndirectReference(po, refProp);
        }
    }

    private boolean isRefPropOwnerDirectParent(PersistentObject po, BusinessExportRefMapping refProp) {
        Class<PropertiedObject> refBasePropOwner = refProp.getBusinessPropertyAccessor().getBaseProperty().getOwner();
        return po.getObjectType().equals(refBasePropOwner) || po.getObjectType().isAssignableFrom(refBasePropOwner) || refBasePropOwner.isAssignableFrom(po.getObjectType());
    }

    private void processIndirectReference(PersistentObject po, BusinessExportRefMapping refProp) {
        PropertiedObject.Property[] chainedProps = refProp.getBusinessPropertyAccessor().getPropertyChain();
        int stoppingIdx = 0;
        boolean referenceFound = false;
        for (PropertiedObject.Property prop : chainedProps) {
            if (prop.getActualObjectType().equals(refProp.getRefPropertyAccessor().getProperty().getActualObjectType())) {
                referenceFound = true;
                break;
            }
            ++stoppingIdx;
        }
        if (referenceFound) {
            PersistentObject resolvedPO = (PersistentObject)refProp.getRefPropertyAccessor().resolveObj(po, 1);
            if (po != null) {
                this.createVersionDiffForIndirectReference(chainedProps, stoppingIdx, resolvedPO, refProp);
            }
        } else {
            OrderMate.LOG.warn("Indirect reference is not found for the property accessor: " + refProp.getRefPropertyAccessor());
        }
    }

    private void createVersionDiffForIndirectReference(PropertiedObject.Property[] chainedProps, int stoppingIdx, PersistentObject po, BusinessExportRefMapping refProp) {
        if (po == null) {
            return;
        }
        ObjectQuery query = new ObjectQuery();
        query.select(chainedProps[0].getOwner()).equals(chainedProps[stoppingIdx], po.getID());
        for (int i = 0; i < stoppingIdx; ++i) {
            query.linkUsing(chainedProps[i]);
        }
        List<PropertiedObject> refObjects = PersistenceManager.getObjectList(chainedProps[0].getOwner(), query.toString());
        for (PersistentObject persistentObject : refObjects) {
            if (this.hasDeletedSystemState(persistentObject.getLastSavedSnapshot())) continue;
            this.createVersionDiff(persistentObject.getID(), VersionDiff.ChangeType.Update, refProp.getBusinessPropertyAccessor().getBaseProperty());
        }
    }

    private void performUpdate(PersistentObjectSnapshot snapShotOld, PersistentObjectSnapshot snapShotNew) {
        if (!this.hasDeletedSystemState(snapShotNew)) {
            this.createVersionDiffForPropsUpdate(snapShotOld, snapShotNew);
            this.createVersionDiffForRefsUpdate(snapShotOld, snapShotNew);
        } else if (!this.hasDeletedSystemState(snapShotOld)) {
            this.performCreationDeletion(snapShotNew, VersionDiff.ChangeType.Deletion);
        }
    }

    private void createVersionDiffForPropsUpdate(PersistentObjectSnapshot snapShotOld, PersistentObjectSnapshot snapShotNew) {
        List<BusinessExportMapping> propMapList = this.mapContainer.getPropMappingsByClass(snapShotOld.getObjectType());
        if (propMapList != null) {
            for (BusinessExportMapping boMap : propMapList) {
                this.createVersionDiffForUpdate(snapShotOld, snapShotNew, boMap.getBusinessPropertyAccessor().getBaseProperty());
            }
        }
    }

    private void createVersionDiffForRefsUpdate(PersistentObjectSnapshot snapShotOld, PersistentObjectSnapshot snapShotNew) {
        List<BusinessExportRefMapping> refExpPropList = this.mapContainer.getRefMappingsByClass(snapShotOld.getObjectType());
        if (refExpPropList != null) {
            for (BusinessExportRefMapping refExpProp : refExpPropList) {
                Object oldReference = snapShotOld.get(refExpProp.getRefPropertyAccessor().getBaseProperty());
                Object newReference = snapShotNew.get(refExpProp.getRefPropertyAccessor().getBaseProperty());
                if (oldReference != null && newReference != null && newReference.equals(oldReference)) continue;
                if (oldReference != null) {
                    this.processReference(snapShotOld, refExpProp);
                }
                if (newReference == null) continue;
                this.processReference(snapShotNew, refExpProp);
            }
        }
    }

    private boolean hasDeletedSystemState(PersistentObjectSnapshot snapShot) {
        if (snapShot != null) {
            Object systemStateProp = snapShot.get(PropertiedObject.PropsHelper.getProperties(snapShot.getObjectType()).getProperty("SYSTEM_STATE"));
            return systemStateProp != null && !systemStateProp.toString().equals("ACTIVE");
        }
        return false;
    }

    private void createVersionDiffForUpdate(PersistentObjectSnapshot snapShotOld, PersistentObjectSnapshot snapShotNew, PropertiedObject.Property prop) {
        Object oldSnapshotPropValue = snapShotOld.get(prop);
        Object newSnapshotPropValue = snapShotNew.get(prop);
        if (oldSnapshotPropValue != null && newSnapshotPropValue != null && !oldSnapshotPropValue.equals(newSnapshotPropValue)) {
            this.createVersionDiff(snapShotNew.get(PersistentObject.Properties.ID), VersionDiff.ChangeType.Update, prop);
        } else if (oldSnapshotPropValue == null && newSnapshotPropValue != null && !String.valueOf(newSnapshotPropValue).trim().equals("")) {
            this.createVersionDiff(snapShotNew.get(PersistentObject.Properties.ID), VersionDiff.ChangeType.Update, prop);
        } else if (newSnapshotPropValue == null && oldSnapshotPropValue != null && !String.valueOf(oldSnapshotPropValue).trim().equals("")) {
            this.createVersionDiff(snapShotOld.get(PersistentObject.Properties.ID), VersionDiff.ChangeType.Update, prop);
        }
    }

    private class ObjectVersion {
        private final Class clazz;
        private final long id;

        public ObjectVersion(Class owner, long objectId) {
            this.clazz = owner;
            this.id = objectId;
        }

        public int hashCode() {
            return this.clazz.hashCode() * (int)this.id;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other instanceof ObjectVersion) {
                return ((ObjectVersion)other).clazz.equals(this.clazz) && ((ObjectVersion)other).id == this.id;
            }
            return false;
        }
    }
}

