/*
 * Decompiled with CFR 0.152.
 */
package ordermate.persistence.remote;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SessionI;
import au.com.ordermate.persistence.UnsafePersistence;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ordermate.persistence.remote.PersistenceServerException;
import ordermate.persistence.remote.RMIPersistenceLayer;

public class RMIPersistenceLayerImpl
extends UnicastRemoteObject
implements RMIPersistenceLayer {
    private UnsafePersistence store;

    public RMIPersistenceLayerImpl(UnsafePersistence toWrap) throws RemoteException {
        this.store = toWrap;
    }

    @Override
    public String ping() throws RemoteException {
        return "pong";
    }

    @Override
    public PersistentList createList(PropertiedObject.Property property) throws RemoteException, PersistenceServerException {
        try {
            return this.store.createList(property);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public Reference createReference(PropertiedObject.Property property) throws RemoteException, PersistenceServerException {
        try {
            return this.store.createReference(property);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public PersistentObject preload(Class type, Long ID) throws RemoteException, PersistenceServerException {
        try {
            return this.store.preload(type, ID);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public long saveOrUpdate(PersistentObjectSnapshot toSave) throws RemoteException, PersistenceServerException {
        try {
            return this.store.saveOrUpdate(toSave);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return 0L;
        }
    }

    @Override
    public void update(PersistentObjectSnapshot toUpdate, PropertiedObject.Property[] properties) throws RemoteException, PersistenceServerException {
        try {
            this.store.update(toUpdate, properties);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void delete(PersistentObjDescriptor toDelete) throws RemoteException, PersistenceServerException {
        try {
            this.store.delete(toDelete);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public boolean hasChanged(PersistentObjectSnapshot toCheck) throws RemoteException, PersistenceServerException {
        try {
            return this.store.hasChanged(toCheck);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return true;
        }
    }

    public Object[][] getObjects(String sql, Object[] params) throws RemoteException, PersistenceServerException {
        try {
            return this.store.executeQuery(sql, params);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public List getObjectList(Class type, String query, Object[] params, SessionI session) throws RemoteException, PersistenceServerException {
        try {
            return this.store.getObjectList(type, query, params, session);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public long executeInsert(String sql, Object[] params) throws RemoteException, PersistenceServerException {
        try {
            return this.store.executeInsert(sql, params);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return 0L;
        }
    }

    @Override
    public void executeUpdate(String sql, Object[] params) throws RemoteException, PersistenceServerException {
        try {
            this.store.executeUpdate(sql, params);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public String getClassTable(Class type) throws RemoteException, PersistenceServerException {
        try {
            return this.store.getClassTable(type);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public String getPropertyColumn(PropertiedObject.Property property) throws RemoteException, PersistenceServerException {
        try {
            return this.store.getPropertyColumn(property);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public String getDiscriminatorColumn(Class type) throws RemoteException, PersistenceServerException {
        try {
            return this.store.getDiscriminatorColumn(type);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public String getDiscriminatorValue(Class type) throws RemoteException, PersistenceServerException {
        try {
            return this.store.getDiscriminatorValue(type);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public Object runSync(Executable exec) throws RemoteException, PersistenceServerException {
        try {
            return this.store.runSync(exec);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public Object[][] executeQuery(String sql, Object[] params) throws PersistenceServerException {
        try {
            return this.store.executeQuery(sql, params);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    @Override
    public Map<String, ?> getPropertyMetadata(PropertiedObject.Property prop) throws PersistenceServerException {
        try {
            return this.store.getPropertyMetadata(prop);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    private void handleException(Exception ex) throws PersistenceServerException {
        if (ex.getClass().getPackage().getName().startsWith("java.lang.")) {
            OrderMateLog.LOG.error("Exception caught in RMIPersistenceLayerImpl, propagating cause of exception over RMI.", (Throwable)ex);
            throw new PersistenceServerException(ex);
        }
        Date date = new Date();
        OrderMateLog.LOG.error("Exception caught in RMIPersistenceLayerImpl at " + date, (Throwable)ex);
        throw new PersistenceServerException("Exception on server at :" + date + ", check server logs for details,\n caused by: " + ex.getMessage());
    }
}

