/*
 * Decompiled with CFR 0.152.
 */
package ordermate.persistence.remote;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PersistentSession;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SessionI;
import au.com.ordermate.persistence.UnsafePersistence;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.simplermi.SimpleRMI;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.ServerConnectionManagerI;
import ordermate.persistence.remote.RMIPersistenceLayer;
import ordermate.persistence.remote.RMIPersistenceLayerImpl;
import ordermate.persistence.remote.RMIPersistenceRetriever;
import org.apache.logging.log4j.Level;

public class RemotePersistence
implements UnsafePersistence {
    private RMIPersistenceLayer store;
    private RMIPersistenceRetriever factory;
    private final ServerConnectionManagerI manager;
    private final Map<PropertiedObject.Property, PersistentList> listCache = new HashMap<PropertiedObject.Property, PersistentList>();
    private final Map<PropertiedObject.Property, Reference> referenceCache = new HashMap<PropertiedObject.Property, Reference>();
    private final Map<Class, String> classTableCache = new HashMap<Class, String>();
    private final Map<PropertiedObject.Property, String> propertyColumnCache = new HashMap<PropertiedObject.Property, String>();
    private final Map<Class, String> discriminatorColumnCache = new HashMap<Class, String>();
    private final Map<Class, String> discriminatorValueCache = new HashMap<Class, String>();
    private Map<Class, Integer> createdClasses;
    private static final long RECONNECT_WAIT = 500L;
    private static final int MAX_FAILED_COUNT = 15;

    public RemotePersistence(ServerConnectionManagerI newManager) {
        this.manager = newManager;
    }

    public void setRemoteFactory(RMIPersistenceRetriever factory) throws RemoteException, NotBoundException {
        this.factory = factory;
        do {
            this.store = factory.retrievePersistence();
            if (this.store != null) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (this.store == null);
    }

    public String ping() throws RemoteException {
        return this.store.ping();
    }

    private void handleRemoteError(String string, Exception e) throws Exception {
        OrderMate.LOG.error(string, (Throwable)e);
        Thread.sleep(500L);
        this.manager.waitUntilConnected();
        this.store = this.factory.retrievePersistence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentList createList(PropertiedObject.Property property) throws Exception {
        PersistentList prototype;
        Map<PropertiedObject.Property, PersistentList> map = this.listCache;
        synchronized (map) {
            prototype = this.listCache.get(property);
            if (prototype == null) {
                prototype = this.createListRemote(property);
                this.listCache.put(property, prototype);
            }
        }
        PersistentList toReturn = prototype.clone();
        return toReturn;
    }

    private PersistentList createListRemote(PropertiedObject.Property property) throws Exception {
        PersistentList toReturn = null;
        boolean success = false;
        while (!success) {
            try {
                toReturn = this.store.createList(property);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to create List", e);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference createReference(PropertiedObject.Property property) throws Exception {
        Reference prototype;
        Map<PropertiedObject.Property, Reference> map = this.referenceCache;
        synchronized (map) {
            prototype = this.referenceCache.get(property);
            if (prototype == null) {
                prototype = this.createReferenceRemote(property);
                this.referenceCache.put(property, prototype);
            }
        }
        Reference toReturn = (Reference)prototype.clone();
        return toReturn;
    }

    private Reference createReferenceRemote(PropertiedObject.Property property) throws Exception {
        Reference toReturn = null;
        boolean success = false;
        while (!success) {
            try {
                toReturn = this.store.createReference(property);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to get reference", e);
            }
        }
        return toReturn;
    }

    @Override
    public PersistentObject preload(Class type, Long ID) throws Exception {
        PersistentObject toReturn = null;
        boolean success = false;
        while (!success) {
            try {
                toReturn = this.store.preload(type, ID);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to preload", e);
            }
        }
        return toReturn;
    }

    @Override
    public long saveOrUpdate(PersistentObjectSnapshot toSave) throws Exception {
        long toReturn = 0L;
        boolean success = false;
        while (!success) {
            try {
                toReturn = this.store.saveOrUpdate(toSave);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to get save object", e);
            }
        }
        return toReturn;
    }

    @Override
    public void update(PersistentObjectSnapshot toUpdate, PropertiedObject.Property[] properties) throws Exception {
        boolean success = false;
        while (!success) {
            try {
                this.store.update(toUpdate, properties);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to update object", e);
            }
        }
    }

    @Override
    public void delete(PersistentObjDescriptor toDelete) throws Exception {
        if (!toDelete.isPersistent()) {
            return;
        }
        boolean success = false;
        while (!success) {
            try {
                this.store.delete(toDelete);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to delete object", e);
            }
        }
    }

    @Override
    public boolean hasChanged(PersistentObjectSnapshot toCheck) throws Exception {
        boolean success = false;
        boolean toReturn = false;
        while (!success) {
            try {
                toReturn = this.store.hasChanged(toCheck);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to check object changed object", e);
            }
        }
        return toReturn;
    }

    @Override
    public Object[][] executeQuery(String sql, Object[] params) throws Exception {
        Object[][] toReturn = null;
        boolean success = false;
        while (!success) {
            try {
                toReturn = this.store.executeQuery(sql, params);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to execute query", e);
            }
        }
        return toReturn;
    }

    @Override
    public long executeInsert(String sql, Object[] params) throws Exception {
        long toReturn = -1L;
        boolean success = false;
        while (!success) {
            try {
                toReturn = this.store.executeInsert(sql, params);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to exeucte insert", e);
            }
        }
        return toReturn;
    }

    @Override
    public void executeUpdate(String sql, Object[] params) throws Exception {
        boolean success = false;
        while (!success) {
            try {
                this.store.executeUpdate(sql, params);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to get objects", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getObjectList(Class type, String query, Object[] params, SessionI session) throws Exception {
        List toReturn = null;
        boolean success = false;
        int failCount = 0;
        while (!success) {
            if (failCount >= 15) {
                throw new Exception("failed to use RMIPersistenceLayer RMIStore to talk to ServerMate");
            }
            try {
                toReturn = this.store.getObjectList(type, query, params, null);
                if (session == null && PersistentObject.class.isAssignableFrom(type)) {
                    new PersistentSession(toReturn);
                }
                success = true;
            }
            catch (RemoteException ex) {
                this.handleRemoteError("Error trying to get object list failCount = " + ++failCount, ex);
            }
            catch (NotBoundException ex) {
                this.handleRemoteError("Error trying to get object list failCount = " + ++failCount, ex);
            }
            catch (Exception ex) {
                OrderMate.LOG.log(Level.ERROR, "Unhandled remote persistence exception, rethrowing ", (Throwable)ex);
                throw ex;
            }
        }
        if (Config.isDebuging() && toReturn != null) {
            RemotePersistence remotePersistence = this;
            synchronized (remotePersistence) {
                if (this.createdClasses == null) {
                    this.createdClasses = new HashMap<Class, Integer>();
                }
                if (!this.createdClasses.containsKey(type)) {
                    this.createdClasses.put(type, toReturn.size());
                } else {
                    this.createdClasses.put(type, this.createdClasses.get(type) + toReturn.size());
                }
            }
        }
        return toReturn;
    }

    @Override
    public String getClassTable(Class type) throws Exception {
        if (this.classTableCache.containsKey(type)) {
            String value = this.classTableCache.get(type);
            return value;
        }
        String toReturn = null;
        boolean success = false;
        int failCount = 0;
        while (!success) {
            if (failCount >= 15) {
                throw new Exception("failed to use RMIPersistenceLayer RMIStore to talk to ServerMate");
            }
            try {
                toReturn = this.store.getClassTable(type);
                success = true;
            }
            catch (Exception e) {
                this.handleRemoteError("Error trying to get class table failCount = " + ++failCount, e);
            }
        }
        if (!this.classTableCache.containsKey(type)) {
            this.classTableCache.put(type, toReturn);
        }
        return toReturn;
    }

    @Override
    public String getPropertyColumn(PropertiedObject.Property property) throws Exception {
        if (this.propertyColumnCache.containsKey(property)) {
            String value = this.propertyColumnCache.get(property);
            return value;
        }
        String toReturn = null;
        boolean success = false;
        while (!success) {
            try {
                toReturn = this.store.getPropertyColumn(property);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to get property Column", e);
            }
        }
        if (!this.propertyColumnCache.containsKey(property)) {
            this.propertyColumnCache.put(property, toReturn);
        }
        return toReturn;
    }

    @Override
    public Map<String, ?> getPropertyMetadata(PropertiedObject.Property prop) throws Exception {
        Map<String, ?> toReturn = null;
        boolean success = false;
        while (!success) {
            try {
                toReturn = this.store.getPropertyMetadata(prop);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to get meta data", e);
            }
        }
        return toReturn;
    }

    @Override
    public String getDiscriminatorColumn(Class type) throws Exception {
        if (this.discriminatorColumnCache.containsKey(type)) {
            String value = this.discriminatorColumnCache.get(type);
            return value;
        }
        String toReturn = null;
        boolean success = false;
        while (!success) {
            try {
                toReturn = this.store.getDiscriminatorColumn(type);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to get discriminator column", e);
            }
        }
        if (!this.discriminatorColumnCache.containsKey(type)) {
            this.discriminatorColumnCache.put(type, toReturn);
        }
        return toReturn;
    }

    @Override
    public String getDiscriminatorValue(Class type) throws Exception {
        if (this.discriminatorValueCache.containsKey(type)) {
            String value = this.discriminatorValueCache.get(type);
            return value;
        }
        String toReturn = null;
        boolean success = false;
        while (!success) {
            try {
                toReturn = this.store.getDiscriminatorValue(type);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to get class table", e);
            }
        }
        if (!this.discriminatorValueCache.containsKey(type)) {
            this.discriminatorValueCache.put(type, toReturn);
        }
        return toReturn;
    }

    @Override
    public Object runSync(Executable exec) throws Exception {
        if (this.store == null) {
            int count = 10;
            OrderMate.LOG.warn("Called Run Sync before remote store was set, will sleep for up to ten seconds");
            while (this.store == null && count >= 0) {
                --count;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            OrderMate.LOG.warn("Exited sleep, store is " + this.store);
        }
        Object retval = null;
        boolean success = false;
        while (!success) {
            try {
                retval = this.store.runSync(exec);
                success = true;
            }
            catch (RemoteException e) {
                this.handleRemoteError("Error trying to run synchronized code", e);
            }
        }
        return retval;
    }

    public static void sharePersistence(UnsafePersistence toShare) throws RemoteException {
        RMIPersistenceLayerImpl remoteShare = new RMIPersistenceLayerImpl(toShare);
        SimpleRMI.shareObject(remoteShare, "RMIStore");
    }

    public synchronized Integer getNumberOfCreatedClasses(Class type) {
        if (this.createdClasses != null) {
            return this.createdClasses.get(type);
        }
        return 0;
    }

    public synchronized Object getTotalCreatedClasses() {
        long tally = 0L;
        if (this.createdClasses != null) {
            for (Integer nextValue : this.createdClasses.values()) {
                tally += (long)nextValue.intValue();
            }
        }
        return tally;
    }
}

