/*
 * Decompiled with CFR 0.152.
 */
package ordermate.remotemonitor;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.IPAddressUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemCurrentInfo;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;

public class RemoteMonitor {
    private static final String HASH_PASSWORD = "omremote11";
    private static String REMOTE_FILE_NAME = "ping.php";
    private final String monitorURL;

    public RemoteMonitor(String newMonitorURL) {
        this.monitorURL = newMonitorURL;
    }

    public boolean sendMessage(RemoteMonitorData messageData) {
        HttpMethod method = this.getMethod(messageData);
        try {
            if (new HttpClient().executeMethod(method) == 200) {
                OrderMate.LOG.info("Resolved path :" + method.getPath());
                return this.readResponseStream(method.getResponseBodyAsStream());
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Could not sendClientMessage to " + method.getPath(), (Throwable)ex);
        }
        return false;
    }

    public HttpMethod getMethod(RemoteMonitorData messageData) {
        if (messageData == null) {
            throw new NullPointerException("Message data should not be null");
        }
        GetMethod method = new GetMethod(this.monitorURL + REMOTE_FILE_NAME);
        method.setQueryString(this.getParams(messageData));
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readResponseStream(InputStream stream) {
        if (stream == null) {
            return false;
        }
        try {
            String msg;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((msg = reader.readLine()) != null) {
                if (!msg.equals("OK")) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Could not read input stream :" + stream, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex2) {
                OrderMate.LOG.warn("Could not close input stream : " + stream, (Throwable)ex2);
            }
        }
    }

    public NameValuePair[] getParams(RemoteMonitorData data) {
        ArrayList<NameValuePair> values = new ArrayList<NameValuePair>();
        values.add(new NameValuePair("business_name", data.getBusinessName()));
        values.add(new NameValuePair("abn", data.getABN()));
        values.add(new NameValuePair("IPAddress", data.getIPAddress()));
        values.add(new NameValuePair("version", data.getVersion()));
        values.add(new NameValuePair("datamate_level", data.getDatamateLevel().toString()));
        values.add(new NameValuePair("last_backup", data.getLastBackUpString()));
        values.add(new NameValuePair("days_since_restart", data.getDaysSinceServermateRestart().toString()));
        values.add(new NameValuePair("debug", "" + Config.isDebuging()));
        values.add(new NameValuePair("ftp_folder", data.getFtpFolder()));
        return values.toArray(new NameValuePair[0]);
    }

    private static Date getLastBackupDate() {
        File file = new File("C:\\Backup");
        if (file.exists()) {
            return new Date(file.lastModified());
        }
        return new Date(2000, 0, 1);
    }

    public static RemoteMonitorData constructMessage(int daysSinceLastRestart) {
        BusinessInfo businessInfo = BusinessInfo.getInstance();
        RemoteMonitorData data = new RemoteMonitorData();
        data.setBusinessName(businessInfo.getName() + " " + businessInfo.getLocation());
        data.setABN(businessInfo.getAbn());
        data.setIPAddress(IPAddressUtils.getIPAddress());
        data.setDatamateLevel(SystemCurrentInfo.getInstance().getDatabaseRevision());
        data.setDaysSinceServermateRestart(daysSinceLastRestart);
        data.setVersion(OrderMate.VERSION);
        data.setLastBackup(RemoteMonitor.getLastBackupDate());
        data.setFtpFolder(businessInfo.getMenuImportFtpFolder());
        return data;
    }

    public static class RemoteMonitorData {
        private String businessName;
        private String ABN;
        private String IPAddress;
        private String version;
        private int datamateLevel;
        private Date lastBackup;
        private int daysSinceServermateRestart;
        private String hashABN;
        private String ftpFolder;

        private RemoteMonitorData() {
        }

        public RemoteMonitorData(String theBusinessName, String theABN, String theIPAddress, String theVersion, int theDatamateLevel, Date theLastBackup, int theDaysSinceServermateRestart, String theFtpFolder) {
            this.businessName = theBusinessName;
            this.setABN(theABN);
            this.IPAddress = theIPAddress;
            this.version = theVersion;
            this.datamateLevel = theDatamateLevel;
            this.lastBackup = theLastBackup;
            this.daysSinceServermateRestart = theDaysSinceServermateRestart;
            this.ftpFolder = theFtpFolder;
        }

        private String getHashSuffix() {
            return RemoteMonitor.HASH_PASSWORD + DateFormat.getDateInstance(3).format(new Date());
        }

        public String getBusinessName() {
            return this.businessName;
        }

        public String getABN() {
            return this.ABN;
        }

        public String getIPAddress() {
            return this.IPAddress;
        }

        public String getVersion() {
            return this.version;
        }

        public Integer getDatamateLevel() {
            return new Integer(this.datamateLevel);
        }

        public Date getLastBackup() {
            return this.lastBackup;
        }

        public Integer getDaysSinceServermateRestart() {
            return new Integer(this.daysSinceServermateRestart);
        }

        public void setBusinessName(String theBusinessName) {
            this.businessName = theBusinessName;
        }

        public void setABN(String abn) {
            this.ABN = abn;
            String s = abn + this.getHashSuffix();
            try {
                MessageDigest m = MessageDigest.getInstance("MD5");
                m.update(s.getBytes(), 0, s.length());
                this.hashABN = new BigInteger(1, m.digest()).toString(16);
            }
            catch (NoSuchAlgorithmException ex) {
                OrderMate.LOG.error("Not able to use the MD5.", (Throwable)ex);
            }
        }

        public void setIPAddress(String theAddress) {
            this.IPAddress = theAddress;
        }

        public void setVersion(String theVersion) {
            this.version = theVersion;
        }

        public void setDatamateLevel(int theDatamateLevel) {
            this.datamateLevel = theDatamateLevel;
        }

        public void setLastBackup(Date theLastBackup) {
            this.lastBackup = theLastBackup;
        }

        public void setDaysSinceServermateRestart(int theDaysSinceServermateRestart) {
            this.daysSinceServermateRestart = theDaysSinceServermateRestart;
        }

        public String getLastBackUpString() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            return format.format(this.getLastBackup());
        }

        public String getHash() {
            return this.hashABN;
        }

        public String getFtpFolder() {
            return this.ftpFolder;
        }

        public void setFtpFolder(String ftpFolder) {
            this.ftpFolder = ftpFolder;
        }
    }
}

