/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.accounting;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.FinanceAccountingGroup;
import ordermate.database.integration.accounting.settings.BaseAccountingConfiguration;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.integration.giftvoucher.GiftVoucherConfigurationGLAccountLink;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.integration.finance.AccountingExportManager;
import ordermate.integration.finance.AccountingExportType;
import ordermate.reports.accounting.GLType;

public class GLCodeLinkReport
extends PersistentSummaryObject
implements Saveable {
    public static final Props Properties = new Props();
    private AccountingExportType exportType;
    private String description;
    private Reference<GLAccount> glAccount;
    private Reference<StockArea> stockArea;
    private Reference<StockGroup> stockGroup;
    private Reference<InventoryGroup> inventoryGroup;
    private Reference<InventoryCategory> inventoryCategory;
    private Reference<FinanceAccountingGroup> financeAccountingGroup;
    private Reference<SalesLocation> salesLocation;
    private GLType glType;
    private Reference<GiftVoucherConfigurationGLAccountLink> voucherLink;

    public GLCodeLinkReport() {
        this.glAccount = this.createReference(GLCodeLinkReport.Properties.GL_ACCOUNT);
        this.stockArea = this.createReference(GLCodeLinkReport.Properties.STOCK_AREA);
        this.stockGroup = this.createReference(GLCodeLinkReport.Properties.STOCK_GROUP);
        this.inventoryGroup = this.createReference(GLCodeLinkReport.Properties.INVENTORY_GROUP);
        this.inventoryCategory = this.createReference(GLCodeLinkReport.Properties.INVENTORY_CATEGORY);
        this.financeAccountingGroup = this.createReference(GLCodeLinkReport.Properties.FINANCE_ACCOUNTING_GROUP);
        this.salesLocation = this.createReference(GLCodeLinkReport.Properties.SALES_LOCATION);
        this.voucherLink = this.createReference(GLCodeLinkReport.Properties.VOUCHER_LINK);
    }

    public AccountingExportType getExportType() {
        return this.exportType;
    }

    public void setExportType(AccountingExportType exportType) {
        this.exportType = exportType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    public void setStockArea(StockArea stockArea) {
        this.stockArea.set(stockArea);
    }

    public StockGroup getStockGroup() {
        return this.stockGroup.get();
    }

    public void setStockGroup(StockGroup stockGroup) {
        this.stockGroup.set(stockGroup);
    }

    public InventoryGroup getInventoryGroup() {
        return this.inventoryGroup.get();
    }

    public void setInventoryGroup(InventoryGroup inventoryGroup) {
        this.inventoryGroup.set(inventoryGroup);
    }

    public InventoryCategory getInventoryCategory() {
        return this.inventoryCategory.get();
    }

    public void setInventoryCategory(InventoryCategory inventoryCategory) {
        this.inventoryCategory.set(inventoryCategory);
    }

    public FinanceAccountingGroup getFinanceAccountingGroup() {
        return this.financeAccountingGroup.get();
    }

    public void setFinanceAccountingGroup(FinanceAccountingGroup financeAccountingGroup) {
        this.financeAccountingGroup.set(financeAccountingGroup);
    }

    public GLAccount getGlAccount() {
        return this.glAccount.get();
    }

    public void setGlAccount(GLAccount glAccount) {
        this.glAccount.set(glAccount);
    }

    public GLAccount getDisplayableGLAccount() {
        if (this.getFinanceAccountingGroup() != null && this.getGlAccount() == null) {
            return BaseAccountingConfiguration.getInstance().getDefaultFinanceGLCode();
        }
        if (this.getStockArea() != null && this.getGlAccount() == null) {
            return this.getStockAreaDefaultGL();
        }
        if (this.getStockGroup() != null && this.getGlAccount() == null) {
            if (this.getStockGroup().getParentGroup() != null) {
                return this.getStockGroup().getParentGroup().getGlAccountOrDefault();
            }
            return AccountingExportManager.getInstance().getAccountingSettings().getDefaultCOGsGLCode();
        }
        if (this.getInventoryCategory() != null && this.getGlAccount() == null) {
            return BaseAccountingConfiguration.getInstance().getDefaultSalesIncomeGLCode();
        }
        if (this.getInventoryGroup() != null && this.getGlAccount() == null) {
            if (this.getInventoryGroup().getParentGroup() != null) {
                return this.getInventoryGroup().getParentGroup().getGlAccountOrDefault();
            }
            return AccountingExportManager.getInstance().getAccountingSettings().getDefaultSalesIncomeGLCode();
        }
        if (this.getGlAccount() == null && this.getVoucherLink() != null) {
            return BaseAccountingConfiguration.getInstance().getDefaultVoucherGLCode(this.getVoucherLink().getType());
        }
        return this.getGlAccount();
    }

    public String getDisplaybleDescription() {
        if (this.getInventoryGroup() != null) {
            return this.getInventoryGroup().getLabelFull();
        }
        if (this.getStockGroup() != null) {
            return this.getStockGroup().getLabelFull();
        }
        if (this.getVoucherLink() != null && (this.getVoucherLink().getGiftVoucherConfig() == null || SystemState.DELETED_STATE.equals(this.getVoucherLink().getGiftVoucherConfig().getSystemState()))) {
            return "[DELETED] " + this.description;
        }
        return this.description;
    }

    public SalesLocation getSalesLocation() {
        return this.salesLocation.get();
    }

    public void setSalesLocation(SalesLocation terminalLocation) {
        this.salesLocation.set(terminalLocation);
    }

    @Override
    public void save() {
        if (this.getFinanceAccountingGroup() != null) {
            this.getFinanceAccountingGroup().setGlCode(this.getGlAccount());
            this.getFinanceAccountingGroup().save();
        } else if (this.getStockArea() != null) {
            if (this.getGlType() != null) {
                this.getStockArea().setGLAccountByType(this.getGlAccount(), this.getGlType());
            } else {
                this.getStockArea().setGlCode(this.getGlAccount());
            }
            this.getStockArea().save();
        } else if (this.getStockGroup() != null) {
            this.getStockGroup().setGlCode(this.getGlAccount());
            this.getStockGroup().save();
        } else if (this.getInventoryCategory() != null) {
            this.getInventoryCategory().setGlAccount(this.getGlAccount());
            this.getInventoryCategory().save();
        } else if (this.getInventoryGroup() != null && this.getSalesLocation() == null) {
            this.getInventoryGroup().setGlAccount(this.getGlAccount());
            this.getInventoryGroup().save();
        } else if (this.getVoucherLink() != null) {
            this.getVoucherLink().setGlAccount(this.getGlAccount());
            this.getVoucherLink().saveChild();
        } else if (this.getInventoryGroup() != null && this.getSalesLocation() != null) {
            PersistenceManager.getPersistenceDelegate().executeUpdate("UPDATE config_integration_acc_group_location_link SET fk_config_integration_acc_gl_account = ? WHERE fk_inventory_group = ? AND fk_config_sales_location = ?", new Object[]{this.getGlAccount() != null ? this.getGlAccount().getID() : null, this.getInventoryGroup().getID(), this.getSalesLocation().getID()});
        } else {
            PersistenceManager.getPersistenceDelegate().executeUpdate("UPDATE config_integration_acc_settings SET value = ? WHERE name = '" + this.getDescription() + "'", new Object[]{this.getGlAccount() != null ? this.getGlAccount().getID() : null});
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return true;
    }

    public GLType getGlType() {
        return this.glType;
    }

    public void setGlType(GLType glType) {
        this.glType = glType;
    }

    private GLAccount getStockAreaDefaultGL() {
        if (this.glType == null) {
            return BaseAccountingConfiguration.getInstance().getDefaultInvoiceGlCode();
        }
        switch (this.glType) {
            case COGS: {
                return BaseAccountingConfiguration.getInstance().getDefaultStockCOGsGLCode();
            }
            case Wastage: {
                return BaseAccountingConfiguration.getInstance().getDefaultStockWastageGLCode();
            }
            case Adjustment: {
                return BaseAccountingConfiguration.getInstance().getDefaultStockAdjustmentGLCode();
            }
            case Transfer: {
                return BaseAccountingConfiguration.getInstance().getDefaultStockTransferGLCode();
            }
        }
        throw new IllegalArgumentException("Stock area GL Type should be valid! " + (Object)((Object)this.glType));
    }

    public GiftVoucherConfigurationGLAccountLink getVoucherLink() {
        return this.voucherLink.get();
    }

    protected void setVoucherLink(GiftVoucherConfigurationGLAccountLink voucherLink) {
        this.voucherLink.set(voucherLink);
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<AccountingExportType> EXPORT_TYPE;
        public PropertiedObject.Property<String> DESCRIPTION;
        public PropertiedObject.Property<GLAccount> GL_ACCOUNT;
        public PropertiedObject.Property<StockArea> STOCK_AREA;
        public PropertiedObject.Property<StockGroup> STOCK_GROUP;
        public PropertiedObject.Property<InventoryGroup> INVENTORY_GROUP;
        public PropertiedObject.Property<InventoryCategory> INVENTORY_CATEGORY;
        public PropertiedObject.Property<FinanceAccountingGroup> FINANCE_ACCOUNTING_GROUP;
        public PropertiedObject.Property<SalesLocation> SALES_LOCATION;
        public PersistentObject.DerivedProperty<String> DISPLAYABLE_DESCRIPTION = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)GLCodeLinkReport.class), "displaybleDescription");
        public PropertiedObject.Property<GLType> GL_TYPE;
        public PropertiedObject.Property<GiftVoucherConfigurationGLAccountLink> VOUCHER_LINK;
    }
}

