/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.accounting;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.integration.accounting.GLAccountCode;
import ordermate.database.integration.accounting.settings.BaseAccountingConfiguration;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;
import ordermate.integration.finance.AccountingExportManager;
import ordermate.reports.accounting.InvoiceDateMethod;
import ordermate.reports.accounting.InvoiceGLGroup;

public class InvoiceReport
extends PersistentSummaryObject
implements GLAccountCode {
    public static final Props Properties = new Props();
    private String supplierName = "";
    private String orderNumber = "";
    private String supplierInvoiceNumber = "";
    private Date invoiceDate = new Date();
    private Price freightAmount = new Price(0.0, 0.0);
    private Price itemAmount = new Price(0.0, 0.0);
    private Price itemTax = new Price(0.0, 0.0);
    private Price discountAmount = new Price(0.0, 0.0);
    private Price adminCostAmount = new Price(0.0, 0.0);
    private double numReceived = 1.0;
    private double bonusReceived = 0.0;
    private String stockItemName = "";
    private Date startDate = new Date();
    private Date endDate = new Date();
    private long invoiceId;
    private String invoiceType;
    private Reference<StockArea> stockArea;
    private Reference<StockGroup> stockGroup;
    private Reference<StockSupplier> stockSupplier;
    private List<Integer> invoiceIDs;

    @Deprecated
    public InvoiceReport() {
        this.stockArea = this.createReference(InvoiceReport.Properties.STOCK_AREA);
        this.stockGroup = this.createReference(InvoiceReport.Properties.STOCK_GROUP);
        this.stockSupplier = this.createReference(InvoiceReport.Properties.STOCK_SUPPLIER);
    }

    public InvoiceReport(Date start, Date end) {
        this(start, end, Collections.EMPTY_LIST);
    }

    public InvoiceReport(Date start, Date end, List<Integer> invoiceIDs) {
        this.stockArea = this.createReference(InvoiceReport.Properties.STOCK_AREA);
        this.stockGroup = this.createReference(InvoiceReport.Properties.STOCK_GROUP);
        this.stockSupplier = this.createReference(InvoiceReport.Properties.STOCK_SUPPLIER);
        this.startDate = start;
        this.endDate = end;
        if (this.invoiceIDs == null) {
            this.invoiceIDs = new ArrayList<Integer>();
        }
        this.invoiceIDs.addAll(invoiceIDs);
    }

    public static InvoiceReport createTemplate(InvoiceReport other) {
        InvoiceReport report = new InvoiceReport();
        report.supplierName = new String(other.supplierName);
        report.orderNumber = new String(other.orderNumber);
        report.supplierInvoiceNumber = new String(other.supplierInvoiceNumber);
        report.invoiceDate = new Date(other.invoiceDate.getTime());
        report.freightAmount = new Price(other.freightAmount);
        report.discountAmount = new Price(other.discountAmount);
        report.adminCostAmount = new Price(other.adminCostAmount);
        report.stockGroup.set(other.stockGroup.get());
        report.stockArea.set(other.stockArea.get());
        report.stockSupplier.set(other.stockSupplier.get());
        report.invoiceType = other.getInvoiceType();
        return report;
    }

    public List<? extends InvoiceReport> generateReport() {
        return this.generateReport(true, true, true, true, null);
    }

    public List<? extends InvoiceReport> generateReport(boolean incFreightReports, boolean incAdminChargeReports, boolean incDiscountReports, boolean isDiscountNegative, List<String> invoiceTypes) {
        return this.generateReport(incFreightReports, incAdminChargeReports, incDiscountReports, isDiscountNegative, false, invoiceTypes);
    }

    public List<? extends InvoiceReport> generateReport(boolean incFreightReports, boolean incAdminChargeReports, boolean incDiscountReports, boolean isDiscountNegative, boolean excludeExported, List<String> invoiceTypes) {
        Object[] params = new Object[]{this.startDate, this.endDate};
        ObjectQuery query = this.getSummaryQuery();
        if (invoiceTypes != null && !invoiceTypes.isEmpty()) {
            query.wherePropertyIn(StockInvoice.Properties.INVOICE_TYPE, invoiceTypes);
        }
        if (excludeExported) {
            query.whereFunction("date_exported is null");
        }
        if (!this.invoiceIDs.isEmpty()) {
            query.wherePropertyIn(StockInvoice.Properties.ID, this.invoiceIDs);
        }
        List<?> invoiceReportList = PersistenceManager.getObjectList(this.getClass(), query.toString(), params);
        if (incFreightReports || incAdminChargeReports || incDiscountReports) {
            return this.addAdditionalReports(invoiceReportList, incFreightReports, incAdminChargeReports, incDiscountReports, isDiscountNegative);
        }
        return invoiceReportList;
    }

    private List<InvoiceReport> addAdditionalReports(List<? extends InvoiceReport> invoiceReportList, boolean incFreightReports, boolean incAdminChargeReports, boolean incDiscountReports, boolean isDiscountNegative) {
        HashSet<Long> invoicesDealtWith = new HashSet<Long>();
        ArrayList<InvoiceReport> orderedReportList = new ArrayList<InvoiceReport>();
        ArrayList<InvoiceReport> additionalReportList = new ArrayList<InvoiceReport>();
        double taxRate = SystemProperty.getInstance().getBaseTaxRate();
        for (InvoiceReport invoiceReport : invoiceReportList) {
            if (invoicesDealtWith.contains(invoiceReport.getInvoiceId())) {
                orderedReportList.add(invoiceReport);
                continue;
            }
            invoicesDealtWith.add(invoiceReport.getInvoiceId());
            if (!additionalReportList.isEmpty()) {
                orderedReportList.addAll(additionalReportList);
                additionalReportList.clear();
            }
            orderedReportList.add(invoiceReport);
            if (incFreightReports && !invoiceReport.getFreightAmount().isZero()) {
                Price freightAmnt = invoiceReport.getFreightAmount();
                InvoiceReport freightEntry = InvoiceReport.createTemplate(invoiceReport);
                freightEntry.setItemAmount(freightAmnt);
                freightEntry.setItemTax(FinanceUtils.getTaxValue(freightAmnt, taxRate));
                freightEntry.setStockItemName("Freight cost");
                freightEntry.setInvoiceId(invoiceReport.getInvoiceId());
                additionalReportList.add(freightEntry);
            }
            if (incAdminChargeReports && !invoiceReport.getAdminCostAmount().isZero()) {
                InvoiceReport adminCostEntry = InvoiceReport.createTemplate(invoiceReport);
                adminCostEntry.setItemAmount(invoiceReport.getAdminCostAmount());
                adminCostEntry.setItemTax(FinanceUtils.getTaxValue(invoiceReport.getAdminCostAmount(), taxRate));
                adminCostEntry.setStockItemName("Administration cost");
                adminCostEntry.setInvoiceId(invoiceReport.getInvoiceId());
                additionalReportList.add(adminCostEntry);
            }
            if (!incDiscountReports || invoiceReport.getDiscountAmount().isZero()) continue;
            InvoiceReport discountEntry = InvoiceReport.createTemplate(invoiceReport);
            discountEntry.setItemAmount(isDiscountNegative ? invoiceReport.getDiscountAmount().multiply(-1) : invoiceReport.getDiscountAmount().abs());
            discountEntry.setItemTax(isDiscountNegative ? FinanceUtils.getTaxValue(invoiceReport.getDiscountAmount().multiply(-1), taxRate) : FinanceUtils.getTaxValue(invoiceReport.getDiscountAmount(), taxRate).abs());
            discountEntry.setStockItemName("Discount ");
            discountEntry.setInvoiceId(invoiceReport.getInvoiceId());
            additionalReportList.add(discountEntry);
        }
        if (!additionalReportList.isEmpty()) {
            orderedReportList.addAll(additionalReportList);
            additionalReportList.clear();
        }
        return orderedReportList;
    }

    protected ObjectQuery getSummaryQuery() {
        InvoiceDateMethod dateMethod = BaseAccountingConfiguration.getInstance().getInvoiceDateMethod() != null ? BaseAccountingConfiguration.getInstance().getInvoiceDateMethod() : InvoiceDateMethod.Invoice;
        ObjectQuery sql = Query.select(StockInvoiceEntry.Properties.ID, "ID").select(StockSupplier.Properties.LABEL, "supplier_name").select(StockInvoice.Properties.ORDER_NUMBER, "order_num").select(StockInvoice.Properties.INVOICE_NUMBER, "supplier_invoice_number").select(StockInvoice.Properties.DATE, "invoice_date").select(StockInvoiceEntry.Properties.PRICE_PAID, "item_amount").selectFunc("IF( stock_invoice_entry.tax_included = 1, stock_invoice_entry.PricePaid * " + FinanceUtils.getTaxMultiplier(SystemProperty.getInstance().getBaseTaxRate()) + ", 0) AS item_tax").select(StockInvoice.Properties.FREIGHT_COST, "freight_amount").select(StockInvoice.Properties.ADMIN_COST, "admin_cost_amount").select(StockInvoice.Properties.DISCOUNT, "discount_amount").select(StockInvoiceEntry.Properties.NUM_RECEIVED, "num_received").select(StockInvoiceEntry.Properties.BONUS_RECEIVED, "bonus_received").select(StockItem.Properties.LABEL, "stock_item_name").select(StockInvoice.Properties.ID).select(StockInvoice.Properties.INVOICE_TYPE, "invoice_type").select(StockInvoice.Properties.STOCK_AREA, "stock_area").select(StockItem.Properties.STOCK_GROUP, "stock_group").select(StockInvoice.Properties.SUPPLIER, "stock_supplier").linkUsing(StockInvoiceEntry.Properties.INVOICE).linkUsing(StockInvoice.Properties.SUPPLIER).linkUsing(StockInvoice.Properties.STOCK_AREA).linkUsing(StockInvoiceEntry.Properties.STOCK_ITEM).active(StockInvoice.class).active(StockInvoiceEntry.class).not().isNull(StockInvoice.Properties.SUPPLIER).greaterThanParam(dateMethod.getDateProperty()).lessThanParam(dateMethod.getDateProperty()).orderBy(StockInvoice.Properties.DATE).orderBy(StockInvoice.Properties.ORDER_NUMBER);
        return sql;
    }

    public String getSupplierName() {
        return this.supplierName;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public Date getInvoiceDate() {
        return this.invoiceDate;
    }

    public String getGlCode() {
        InvoiceGLGroup group = AccountingExportManager.getInstance().getAccountingSettings().getInvoiceGLGroup();
        String glCode = null;
        if (InvoiceGLGroup.StockGroup.equals((Object)group)) {
            StockGroup currentGroup = this.getStockGroup();
            String string = glCode = currentGroup.getGlCode() != null ? currentGroup.getGlCode().getGlCode() : null;
            while (currentGroup != null && (glCode == null || glCode.isEmpty())) {
                glCode = currentGroup.getGlCode() != null ? currentGroup.getGlCode().getGlCode() : null;
                currentGroup = currentGroup.getParentGroup();
            }
        } else if (InvoiceGLGroup.StockArea.equals((Object)group)) {
            String string = glCode = this.getStockArea().getGlCode() != null ? this.getStockArea().getGlCode().getGlCode() : null;
        }
        if (glCode == null) {
            glCode = AccountingExportManager.getInstance().getAccountingSettings().getDefaultInvoiceGlCode().getGlCode();
        }
        return glCode;
    }

    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    public void setStockArea(StockArea value) {
        this.stockArea.set(value);
    }

    @Override
    public String getGlAccountCode() {
        return this.getGlCode();
    }

    public Price getItemAmount() {
        return this.itemAmount;
    }

    public Price getItemTax() {
        return this.itemTax;
    }

    public Price getDiscountAmount() {
        return this.discountAmount;
    }

    public Price getFreightAmount() {
        return this.freightAmount;
    }

    public Price getAdminCostAmount() {
        return this.adminCostAmount;
    }

    public double getNumReceived() {
        return this.numReceived;
    }

    public double getBonusReceived() {
        return this.bonusReceived;
    }

    public String getStockItemName() {
        return this.stockItemName;
    }

    public Price getUnitPrice() {
        return new Price(this.getItemAmount().doubleValue() / this.getNumReceived(), 0.0);
    }

    public String getSupplierInvoiceNumber() {
        return this.supplierInvoiceNumber;
    }

    public void setSupplierName(String newSupplierName) {
        this.supplierName = newSupplierName;
    }

    public void setOrderNumber(String newOrderNumber) {
        this.orderNumber = newOrderNumber;
    }

    public void setSupplierInvoiceNumber(String newSupplierInvoiceNumber) {
        this.supplierInvoiceNumber = newSupplierInvoiceNumber;
    }

    public void setInvoiceDate(Date newInvoiceDate) {
        this.invoiceDate = newInvoiceDate;
    }

    public void setItemAmount(Price newItemAmount) {
        this.itemAmount = newItemAmount;
    }

    public void setItemTax(Price newItemTax) {
        this.itemTax = newItemTax;
    }

    public void setFreightAmount(Price newFreightAmount) {
        this.freightAmount = newFreightAmount;
    }

    public void setNumReceived(double newNumReceived) {
        this.numReceived = newNumReceived;
    }

    public void setStockItemName(String newStockItemName) {
        this.stockItemName = newStockItemName;
    }

    public void setInvoiceId(long id) {
        this.invoiceId = id;
    }

    public long getInvoiceId() {
        return this.invoiceId;
    }

    public StockGroup getStockGroup() {
        return this.stockGroup.get();
    }

    public void setStockGroup(StockGroup newStockGroup) {
        this.stockGroup.set(newStockGroup);
    }

    public String getAccountName() {
        GLAccount account = GLAccount.getGLAccountForGLCode(this.getGlAccountCode());
        return account == null ? "Stock" : account.getName();
    }

    public Price getExTaxAmount() {
        return new Price(this.getItemAmount().subtract(this.getItemTax()), 0.0);
    }

    public TaxCode getTaxCode() {
        return this.getItemTax().isZero() ? TaxCode.getNonCapAqFree() : TaxCode.getNonCapAqGST();
    }

    public String getTaxLabel() {
        return SystemProperty.getInstance().getBaseTaxLabel();
    }

    public String getDescription() {
        String desc = this.getNumReceived() != 0.0 ? this.getNumReceived() + " x " + this.getStockItemName() + " @ " + this.getUnitPrice() + " ea" : this.getStockItemName();
        if (this.getBonusReceived() != 0.0) {
            desc = desc + " (plus " + this.getBonusReceived() + " bonus)";
        }
        return desc;
    }

    public Price getFreightExTax() {
        return new Price(this.getFreightAmount().subtract(this.getFreightTaxAmount()), 0.0);
    }

    public Price getFreightTaxAmount() {
        return new Price(FinanceUtils.getTaxValue(this.getFreightAmount().doubleValue(), SystemProperty.getInstance().getBaseTaxRate()), 0.0);
    }

    public String getJournalMemo() {
        return "Imported invoice : " + this.getSupplierName();
    }

    public StockSupplier getStockSupplier() {
        return this.stockSupplier.get();
    }

    public void setStockSupplier(StockSupplier newStockSupplier) {
        this.stockSupplier.set(newStockSupplier);
    }

    public String getInvoiceType() {
        return this.invoiceType;
    }

    public void setInvoiceType(String value) {
        this.invoiceType = value;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property SUPPLIER_NAME;
        public PropertiedObject.Property ORDER_NUMBER;
        public PropertiedObject.Property SUPPLIER_INVOICE_NUMBER;
        public PropertiedObject.Property INVOICE_DATE;
        public PropertiedObject.Property ITEM_AMOUNT;
        public PropertiedObject.Property ITEM_TAX;
        public PropertiedObject.Property DISCOUNT_AMOUNT;
        public PropertiedObject.Property FREIGHT_AMOUNT;
        public PropertiedObject.Property ADMIN_COST_AMOUNT;
        public PropertiedObject.Property NUM_RECEIVED;
        public PropertiedObject.Property BONUS_RECEIVED;
        public PropertiedObject.Property STOCK_ITEM_NAME;
        public PropertiedObject.Property INVOICE_ID;
        public PropertiedObject.Property<StockArea> STOCK_AREA;
        public PropertiedObject.Property<StockGroup> STOCK_GROUP;
        public PropertiedObject.Property<StockSupplier> STOCK_SUPPLIER;
        public PropertiedObject.Property<String> INVOICE_TYPE;
        public PersistentObject.DerivedProperty<String> GL_CODE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InvoiceReport.class), "glCode");
        public PersistentObject.DerivedProperty<String> ACCOUNT_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InvoiceReport.class), "accountName");
        public PersistentObject.DerivedProperty<Price> EX_TAX_AMOUNT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InvoiceReport.class), "exTaxAmount");
        public PersistentObject.DerivedProperty<TaxCode> TAX_CODE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InvoiceReport.class), "taxCode");
        public PersistentObject.DerivedProperty<String> TAX_LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InvoiceReport.class), "taxLabel");
        public PersistentObject.DerivedProperty<String> DESCRIPTION = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InvoiceReport.class), "description");
        public PersistentObject.DerivedProperty<Price> FREIGHT_EX_TAX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InvoiceReport.class), "freightExTax");
        public PersistentObject.DerivedProperty<Price> FRIEGHT_TAX_AMOUNT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InvoiceReport.class), "freightTaxAmount");
        public PersistentObject.DerivedProperty<String> JOURNAL_MEMO = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InvoiceReport.class), "journalMemo");
    }
}

