/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.dynamicjasper;

import au.com.ordermate.search.offset.DateOffsetFunction;
import au.com.ordermate.search.offset.DateOffsetFunctions;
import au.com.ordermate.util.DateTimeUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.TradingDay;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;

public abstract class PeriodReportAdapter {
    public static final PeriodReportAdapter DAILY = new PeriodReportAdapter(){

        @Override
        public DateFormat getFormatter() {
            return DateTimeUtils.getMediumDateFormat();
        }

        @Override
        public List<Date> getDateList() {
            return TradingDay.ReportDates.getTradingDayDatesOnOrAfter(TradingDay.ReportDates.getFirstTradingDay().getDate());
        }

        @Override
        public DateOffsetFunction getDateOffset() {
            return DateOffsetFunctions.END_DAY;
        }

        @Override
        public String getLabel() {
            return "Daily";
        }

        @Override
        public String getUnitOfTime() {
            return "Day";
        }

        @Override
        public String getTitle() {
            return "Daily";
        }
    };
    public static final PeriodReportAdapter WEEK_ENDING = new PeriodReportAdapter(){

        @Override
        public DateFormat getFormatter() {
            return DateTimeUtils.getDateOfBirthFormat();
        }

        @Override
        public List<Date> getDateList() {
            return TradingDay.ReportDates.getLastDayOfWeekDates();
        }

        @Override
        public DateOffsetFunction getDateOffset() {
            return DateOffsetFunctions.END_WEEK_ENDING;
        }

        @Override
        public String getLabel() {
            return "Week Ending";
        }

        @Override
        public String getTitle() {
            return "Weekly";
        }

        @Override
        public String getUnitOfTime() {
            return "Week";
        }

        @Override
        public String formatDateForDisplay(Date date) {
            return super.formatDateForDisplay(this.getDateOffset().calcStart(date));
        }
    };
    public static final PeriodReportAdapter MONTHLY = new PeriodReportAdapter(){

        @Override
        public DateFormat getFormatter() {
            return new SimpleDateFormat("MMM yyyy");
        }

        @Override
        public List<Date> getDateList() {
            return TradingDay.ReportDates.getStartMonthDates();
        }

        @Override
        public DateOffsetFunction getDateOffset() {
            return DateOffsetFunctions.END_MONTH;
        }

        @Override
        public String getLabel() {
            return "Monthly";
        }

        @Override
        public String getUnitOfTime() {
            return "Month";
        }

        @Override
        public String getTitle() {
            return "Monthly";
        }
    };
    public static final PeriodReportAdapter QUARTER = new PeriodReportAdapter(){

        @Override
        public DateFormat getFormatter() {
            return new SimpleDateFormat("MMM yyyy");
        }

        @Override
        public List<Date> getDateList() {
            return TradingDay.ReportDates.getStartQuarterDates();
        }

        @Override
        public DateOffsetFunction getDateOffset() {
            return DateOffsetFunctions.END_QUARTER;
        }

        @Override
        public String getLabel() {
            return "Quarterly";
        }

        @Override
        public String getUnitOfTime() {
            return "Quarter";
        }

        @Override
        public String formatDateForDisplay(Date date) {
            return "Qtr Beginning " + this.getFormatter().format(this.getDateOffset().calcStart(date));
        }

        @Override
        public String getTitle() {
            return "Quarterly";
        }
    };
    public static final PeriodReportAdapter YEAR = new PeriodReportAdapter(){

        @Override
        public DateFormat getFormatter() {
            return new SimpleDateFormat("yyyy");
        }

        @Override
        public List<Date> getDateList() {
            return TradingDay.ReportDates.getStartYearDates();
        }

        @Override
        public DateOffsetFunction getDateOffset() {
            return DateOffsetFunctions.END_YEAR;
        }

        @Override
        public String getLabel() {
            return "Yearly";
        }

        @Override
        public String getUnitOfTime() {
            return "Year";
        }

        @Override
        public String getTitle() {
            return "Yearly";
        }
    };

    public abstract List<Date> getDateList();

    public abstract DateOffsetFunction getDateOffset();

    public abstract String getLabel();

    public abstract String getTitle();

    public abstract String getUnitOfTime();

    public String toString() {
        return this.getLabel();
    }

    public String formatDateForDisplay(Date date) {
        if (this.getFormatter() == null) {
            throw new IllegalStateException("The formatter for this adapter has not been defined.");
        }
        if (date == null) {
            throw new IllegalArgumentException("The date is null");
        }
        return this.getFormatter().format(date);
    }

    public String formatRangeForDisplay(Date start, Date end) {
        String endDate;
        String startDate = this.formatDateForDisplay(start);
        if (startDate.equals(endDate = this.formatDateForDisplay(end))) {
            return startDate;
        }
        if (end.before(start)) {
            return endDate + " - " + startDate;
        }
        return startDate + " - " + endDate;
    }

    public String formatTradingDayRangeForDisplay(Date start, Date end, Date closeTime) {
        String endDate;
        String startDate = this.formatDateForDisplay(start);
        if (startDate.equals(endDate = this.formatDateForDisplay(end))) {
            return startDate + " " + TradingDayFilteredReportSearcher.DisplayHelper.formatTradingDayCloseTime(closeTime);
        }
        if (end.before(start)) {
            return endDate + " - " + startDate + " " + TradingDayFilteredReportSearcher.DisplayHelper.formatTradingDayCloseTime(closeTime);
        }
        return startDate + " - " + endDate + " " + TradingDayFilteredReportSearcher.DisplayHelper.formatTradingDayCloseTime(closeTime);
    }

    public abstract DateFormat getFormatter();

    public static PeriodReportAdapter[] getStandardPeriods() {
        return new PeriodReportAdapter[]{DAILY, WEEK_ENDING, MONTHLY, QUARTER, YEAR};
    }

    public static enum PeriodAndDateRange {
        DateRange(null),
        Daily(DAILY),
        Weekly(WEEK_ENDING),
        Monthly(MONTHLY),
        Quarterly(QUARTER),
        Yearly(YEAR);

        final PeriodReportAdapter period;

        private PeriodAndDateRange(PeriodReportAdapter thePeriod) {
            this.period = thePeriod;
        }

        public PeriodReportAdapter getPeriod() {
            return this.period;
        }
    }

    public static enum StandardPeriod {
        Daily(DAILY),
        Weekly(WEEK_ENDING),
        Monthly(MONTHLY),
        Quarterly(QUARTER),
        Yearly(YEAR);

        final PeriodReportAdapter period;

        private StandardPeriod(PeriodReportAdapter thePeriod) {
            this.period = thePeriod;
        }

        public PeriodReportAdapter getPeriod() {
            return this.period;
        }

        public static StandardPeriod standardPeriodFor(PeriodReportAdapter searchFor) {
            return StandardPeriod.valueOf(searchFor.getTitle());
        }
    }
}

