/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.dynamicjasper;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.domain.AutoText;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ChartBuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.builder.DJBar3DChartBuilder;
import ar.com.fdvs.dj.domain.chart.builder.DJPie3DChartBuilder;
import ar.com.fdvs.dj.domain.chart.builder.DJTimeSeriesChartBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.ImageScaleMode;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PercentageColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import ordermate.OrderMate;
import ordermate.database.misc.BusinessInfo;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateDefaultReportStyle;
import ordermate.reports.dynamicjasper.ReportStyles;
import ordermate.reports.dynamicjasper.customexpressions.CustomExpressionRegister;
import ordermate.reports.printing.HeaderSubReport;
import org.apache.commons.lang.StringUtils;

public class ReportBuilder {
    public static final Double BAR_LABEL_ROTATION = -45.0;
    public static final String FOOTER_LEGEND = "* = Excludes Tax, ^ = Excludes Discounts & Surcharges";
    private final SafeReportBuilder builder = new SafeReportBuilder();
    private final ReportStyles styles;
    protected final Map<PropertiedObject.Property, PropertyColumn> propertiesToColumns = new HashMap<PropertiedObject.Property, PropertyColumn>();
    protected final Map<PropertyColumn, PropertiedObject.Property> columnToProperties = new HashMap<PropertyColumn, PropertiedObject.Property>();
    private int columnCount = 0;
    private TemplateFormat reportTemplateFormat = TemplateFormat.A4Portrait;
    public static final int MAX_LOGO_HEIGHT = 110;
    public static final int MAX_LOGO_WIDTH = 240;
    private static final String PORTRAIT_TEMPLATE_PATH = "ordermate/reports/dynamicjasper/BlankA4Portrait.jrxml";
    private static final String LANDSCAPE_TEMPLATE_PATH = "ordermate/reports/dynamicjasper/BlankA4Landscape.jrxml";
    private static final String PORTRAIT_NO_HEADER_TEMPLATE_PATH = "ordermate/reports/dynamicjasper/BlankA4PortraitNoHeader.jrxml";
    private static final String LANDSCAPE_NO_HEADER_TEMPLATE_PATH = "ordermate/reports/dynamicjasper/BlankA4LandscapeNoHeader.jrxml";
    private final CustomExpressionRegister customExpressionRegister = new CustomExpressionRegister();

    public ReportBuilder() {
        this(new OrderMateDefaultReportStyle());
    }

    public ReportBuilder(TemplateFormat tpf) {
        this(new OrderMateDefaultReportStyle());
        this.setReportFormat(tpf);
    }

    public ReportBuilder(ReportStyles reportStyles, TemplateFormat tpf) {
        this(reportStyles);
        this.setReportFormat(tpf);
    }

    public ReportBuilder(ReportStyles reportStyles) {
        this.styles = reportStyles;
        this.builder.setColumnsPerPage(1).setMargins(2, 2, 20, 20).setDetailHeight(10).setPrintBackgroundOnOddRows(true).setDefaultStyles(this.styles.getTitleStyle(), this.styles.getSubtitleStyle(), this.styles.getColumnHeaderStyle(), this.styles.getColumnDetailStyle()).setUseFullPageWidth(true).setWhenNoDataAllSectionNoDetail();
    }

    public CustomExpressionRegister getCustomExpressionRegister() {
        return this.customExpressionRegister;
    }

    protected void setReportFormat(TemplateFormat tpf) {
        this.reportTemplateFormat = tpf;
    }

    public DJChart createBarChart(DJGroup columnGroup, ChartCalculation chartCalculation, Collection<? extends AbstractColumn> reportColumns) throws ChartBuilderException {
        return this.createBarChart(columnGroup, chartCalculation, reportColumns, (byte)2, null);
    }

    public DJChart createBarChart(DJGroup columnGroup, ChartCalculation chartCalculation, Collection<? extends AbstractColumn> reportColumns, byte position, DJAxisFormat axisFormat) throws ChartBuilderException {
        if (columnGroup == null) {
            throw new NullPointerException("Column group must be specified.");
        }
        DJBar3DChartBuilder cb = new DJBar3DChartBuilder();
        cb.setOperation(chartCalculation.convertToDJChartCalculation()).setColumnGroup(columnGroup.getColumnToGroupBy()).setPosition(position);
        if (axisFormat != null) {
            cb.setValueAxisFormat(axisFormat);
        }
        for (AbstractColumn abstractColumn : reportColumns) {
            cb.addSerie(abstractColumn);
        }
        DJChart chart = cb.build();
        chart.getPlot().setLabelRotation(BAR_LABEL_ROTATION);
        this.addChart(chart);
        return chart;
    }

    public ReportBuilder addChart(DJChart chart) {
        this.builder.addChart(chart);
        return this;
    }

    public ReportBuilder addReportColumns(Collection<PropertiedObject.Property> propsToShow) throws ColumnBuilderException {
        for (PropertiedObject.Property propToShow : propsToShow) {
            this.addReportColumn(propToShow, "");
        }
        return this;
    }

    public ReportBuilder addReportColumns(Collection propsToShow, String ... titles) throws ColumnBuilderException {
        int index = 0;
        for (PropertiedObject.Property property : propsToShow) {
            String title = property.getUserVisibleLabel();
            if (index < titles.length) {
                title = titles[index];
            }
            this.addReportColumn(property, title, "");
            ++index;
        }
        return this;
    }

    public ReportBuilder addReportColumn(PropertiedObject.Property propToShow, String pattern) throws ColumnBuilderException {
        this.addReportColumn(propToShow, propToShow.getUserVisibleLabel(), pattern);
        return this;
    }

    public ReportBuilder addReportColumn(PropertiedObject.Property propToShow, String title, String pattern) throws ColumnBuilderException {
        Class columnClass = this.determineColumnClass(propToShow.getObjectTypeFromMethod());
        String thePattern = pattern;
        if (pattern == null || pattern.isEmpty()) {
            thePattern = this.determineDefaultPattern(columnClass);
        }
        PropertyColumn column = this.createColumn(new ColumnSpec().setClass(columnClass).setTitle(title).setName(propToShow.getName()).setPattern(thePattern));
        this.propertiesToColumns.put(propToShow, column);
        this.columnToProperties.put(column, propToShow);
        return this;
    }

    public PropertiedObject.Property getPropertyForColumn(PropertyColumn column) {
        return this.columnToProperties.get(column);
    }

    private String determineDefaultPattern(Class columnClass) {
        if (Number.class.isAssignableFrom(columnClass)) {
            return "0.##";
        }
        if (SalesQuantity.class.isAssignableFrom(columnClass)) {
            return "0.##";
        }
        if (Date.class.isAssignableFrom(columnClass)) {
            return ((SimpleDateFormat)DateTimeUtils.getDateTimeFormat()).toPattern();
        }
        return null;
    }

    protected PropertyColumn createColumn(ColumnSpec col) throws ColumnBuilderException {
        ColumnBuilder colBuilder = ColumnBuilder.getNew().setTitle(col.title);
        CustomExpression expression = this.customExpressionRegister.getCustomExpressionForType(col.clazz, col.name);
        if (expression != null) {
            colBuilder.setCustomExpression(expression);
            colBuilder.setCustomExpressionForCalculation(this.customExpressionRegister.getCustomCalcExpressionForType(col.clazz, col.name));
            this.builder.addField(col.name, col.clazz.getName());
        }
        colBuilder.setColumnProperty(col.name, col.clazz.getName());
        if (col.pattern != null && !col.pattern.isEmpty()) {
            colBuilder.setPattern(col.pattern);
        }
        PropertyColumn column = (PropertyColumn)colBuilder.build();
        this.addColumnToBuilder((AbstractColumn)column);
        return column;
    }

    private void addColumnToBuilder(AbstractColumn column) {
        ++this.columnCount;
        this.builder.addColumn(column);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    protected Class determineColumnClass(Class clazz) {
        Class columnClass;
        if (String.class.isAssignableFrom(clazz)) {
            columnClass = String.class;
        } else if (Displayable.class.isAssignableFrom(clazz)) {
            columnClass = Displayable.class;
        } else if (Price.class.isAssignableFrom(clazz)) {
            columnClass = Price.class;
        } else if (Number.class.isAssignableFrom(clazz)) {
            columnClass = clazz;
        } else {
            if (clazz.equals(Boolean.class)) {
                return clazz;
            }
            if (clazz.equals(Date.class)) {
                return Date.class;
            }
            if (clazz.isPrimitive()) {
                return clazz;
            }
            if (clazz.isArray()) {
                return clazz.getComponentType();
            }
            return clazz;
        }
        return columnClass;
    }

    public DJGroup addGroupBy(PropertiedObject.Property groupByProp, Collection<PropertyCalculation> propertyCalculations) {
        return this.addGroupBy(new PropertyGroupSpec(groupByProp), propertyCalculations);
    }

    public GroupBuilder addGroupByToBuilder(GroupSpec groupSpec, Collection<PropertyCalculation> propertyCalculations) {
        Collection<PropertyCalculation> propCalculations = propertyCalculations != null ? propertyCalculations : Collections.emptyList();
        PropertyColumn groupByColumn = groupSpec.groupColumn;
        if (groupByColumn == null) {
            return null;
        }
        GroupBuilder groupBuilder = new GroupBuilder();
        groupBuilder.setGroupLayout(groupSpec.layout);
        groupBuilder.setCriteriaColumn(groupByColumn);
        for (PropertyCalculation calc : propCalculations) {
            this.addFooterCalculation(calc, groupBuilder);
        }
        groupByColumn.setStyle(groupSpec.groupedColumnStyle);
        groupByColumn.setHeaderStyle(groupSpec.groupedColumnStyle);
        return groupBuilder;
    }

    public DJGroup addGroupBy(GroupSpec groupSpec, Collection<PropertyCalculation> propertyCalculations) {
        GroupBuilder groupBuilder = this.addGroupByToBuilder(groupSpec, propertyCalculations);
        return this.addGroupBuilderToReport(groupBuilder, groupSpec);
    }

    public DJGroup addGroupBuilderToReport(GroupBuilder groupBuilder, GroupSpec groupSpec) {
        DJGroup group = groupBuilder.build();
        this.builder.addGroup(group);
        this.builder.setPrintColumnNames(groupSpec.showColumnNamesInPageHeader);
        return group;
    }

    private void addFooterCalculation(PropertyCalculation calculation, GroupBuilder groupBuilder) {
        PropertyColumn column = this.propertiesToColumns.get(calculation.property);
        if (column != null) {
            DJValueFormatter formatter = this.customExpressionRegister.getValueFormatterForType(this.determineColumnClass(calculation.property.getObjectTypeFromMethod()));
            groupBuilder.addFooterVariable((AbstractColumn)column, calculation.calculation, this.styles.getColumnDetailStyle(), formatter);
        }
    }

    public void addFooterCalculation(PropertyCalculation calculation) {
        AbstractColumn column = (AbstractColumn)this.propertiesToColumns.get(calculation.property);
        if (column != null) {
            this.addFooterCalculation(column, this.determineColumnClass(calculation.property.getObjectTypeFromMethod()), calculation.calculation);
        }
    }

    public void addFooterCalculation(AbstractColumn column, Class colClass, DJCalculation calculation) {
        DJValueFormatter formatter = this.customExpressionRegister.getValueFormatterForType(colClass);
        Style style = column.getStyle();
        if (style == null) {
            style = this.getStyles().getColumnDetailStyle();
        }
        this.getReportBuilder().addGlobalFooterVariable(column, calculation, style, formatter);
    }

    public void addFooterCalculation(AbstractColumn column, Class colClass, DJCalculation calculation, Style style) {
        DJValueFormatter formatter = this.getCustomExpressionRegister().getValueFormatterForType(colClass);
        this.getReportBuilder().addGlobalFooterVariable(column, calculation, style, formatter);
    }

    public ReportBuilder addInvisibleField(PropertiedObject.Property prop) {
        SimpleColumn column = new SimpleColumn();
        column.setColumnProperty(new ColumnProperty(prop.getName(), prop.getObjectTypeFromMethod().getName()));
        column.setName(prop.getUserVisibleLabel());
        column.setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + " 0.00");
        this.propertiesToColumns.put(prop, (PropertyColumn)column);
        this.columnToProperties.put((PropertyColumn)column, prop);
        this.builder.addField(prop.getName(), this.determineColumnClass(prop.getObjectTypeFromMethod()).getName());
        return this;
    }

    public ReportBuilder addInvisibleField(String propertyName, Class clazzType) {
        SimpleColumn column = new SimpleColumn();
        String clazzName = clazzType.getName();
        column.setColumnProperty(new ColumnProperty(propertyName, clazzName));
        column.setName(propertyName);
        this.builder.addField(propertyName, clazzName);
        return this;
    }

    public PropertyColumn getPropertyColumn(PropertiedObject.Property prop) {
        PropertyColumn column = this.propertiesToColumns.get(prop);
        if (column == null) {
            throw new NullPointerException("Could not get column for property : " + prop);
        }
        return column;
    }

    public boolean isPropertyColumnPresent(PropertiedObject.Property prop) {
        return this.propertiesToColumns.get(prop) != null;
    }

    public ReportBuilder setTitle(String title) {
        this.builder.setTitle(title);
        return this;
    }

    public ReportBuilder setSubtitle(String subtitle) {
        this.builder.setSubtitle(subtitle);
        return this;
    }

    public final DynamicReport buildJasperReport() {
        return this.builder.build();
    }

    public final SafeReportBuilder getReportBuilder() {
        return this.builder;
    }

    public ReportBuilder setUseGrandTotal(boolean useGrandTotal) {
        this.builder.setGrandTotalLegendStyle(this.styles.getGroupedDetailStyle());
        if (useGrandTotal) {
            this.builder.setGrandTotalLegend("Total");
        } else {
            this.builder.setGrandTotalLegend(null);
        }
        return this;
    }

    public ReportStyles getStyles() {
        return this.styles;
    }

    public ReportBuilder addPercentageColumn(String title, PropertiedObject.Property percentageOf) throws ColumnBuilderException {
        PercentageColumn percColumn = (PercentageColumn)ColumnBuilder.getNew().setTitle(title).setPercentageColumn(this.getPropertyColumn(percentageOf)).setPattern("0.0%").build();
        this.getReportBuilder().addColumn((AbstractColumn)percColumn);
        return this;
    }

    public void addGroupStaticText(String text, DJGroup group, AbstractColumn column) {
    }

    public void addFooter(String userName) {
        this.builder.addAutoText((byte)0, (byte)0, (byte)1, 50, 100);
        if (StringUtils.isNotBlank((String)userName)) {
            this.builder.addAutoText("Printed by " + userName, (byte)0, (byte)2);
        }
        this.builder.addAutoText((byte)3, (byte)0, (byte)3, (byte)3, 150, 30);
    }

    public void addLogoToFirstPage() {
        String location = IconLoader.class.getResource(BusinessInfo.getInstance().getLabelLogo()).getFile();
        String logoLocation = BusinessInfo.getInstance().getLogo();
        if (logoLocation != null && !logoLocation.isEmpty()) {
            String otherLocation = null;
            try {
                otherLocation = IconLoader.class.getResource(logoLocation).getFile();
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot resolve Business Logo from jar, trying from file:" + otherLocation);
                try {
                    otherLocation = System.getProperty("user.dir") + IconLoader.get(logoLocation);
                }
                catch (Exception ex2) {
                    OrderMate.LOG.error("Still can't find business logo, using ordermate logo", (Throwable)ex2);
                }
            }
            if (otherLocation != null && new File(otherLocation).exists()) {
                location = otherLocation;
            }
        }
        Dimension dim = new Dimension(40, 40);
        try {
            BufferedImage image = ImageIO.read(new URL(location));
            if (image != null) {
                new ImageHelper().removeAlpha(image, Color.WHITE);
            }
            dim = new Dimension(image.getWidth(), image.getHeight());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot read in file, not adding to header:" + location, (Throwable)ex);
        }
        this.getReportBuilder().addFirstPageImageBanner(location, Math.min(dim.width, 240), Math.min(dim.height, 110), (byte)1, ImageScaleMode.FILL_PROPORTIONALLY);
    }

    public void addLogoToAllPages() {
        String labelPath = IconLoader.class.getResource(BusinessInfo.getInstance().getLabelLogo()).getFile();
        this.getReportBuilder().addImageBanner(labelPath, Math.min(IconLoader.getWidth(labelPath), 120), Math.min(IconLoader.getHeight(labelPath), 55), (byte)0);
    }

    public void addMinimalistBusinessDetails() {
        Style busNameStyle = new StyleBuilder(true).setFont(new Font(13, "Verdana", true)).setVerticalAlign(VerticalAlign.TOP).build();
        Style busDetailsStyle = new StyleBuilder(true).setFont(new Font(10, "Verdana", false)).setVerticalAlign(VerticalAlign.TOP).build();
        BusinessInfo busInfo = BusinessInfo.getInstance();
        String name = busInfo.getName();
        String address1 = busInfo.getAddress1();
        String address2 = busInfo.getAddress2();
        String address = StringUtils.isNotBlank((String)address2) ? address1 + " " + address2 : address1;
        int WIDTH = 800;
        this.builder.addAutoText(name, (byte)1, (byte)3, 800, busNameStyle);
        this.builder.addAutoText(address, (byte)1, (byte)3, 800, busDetailsStyle);
    }

    public void addBusinessDetailsToAutoTextHeader() {
        Style busNameStyle = new StyleBuilder(true).setFont(new Font(18, "Verdana", true)).setVerticalAlign(VerticalAlign.BOTTOM).build();
        Style busDetailsStyle = new StyleBuilder(true).setFont(new Font(10, "Verdana", false)).setVerticalAlign(VerticalAlign.TOP).build();
        BusinessInfo busInfo = BusinessInfo.getInstance();
        String name = busInfo.getName();
        String abn = busInfo.getBusinessNumberType() + ": " + busInfo.getAbn();
        String address1 = busInfo.getAddress1();
        String address2 = busInfo.getAddress2();
        String phone = "Ph " + busInfo.getPhone();
        this.builder.addAutoText(name, (byte)1, (byte)3, AutoText.WIDTH_NOT_SET, busNameStyle);
        this.builder.addAutoText(abn, (byte)1, (byte)3, AutoText.WIDTH_NOT_SET, busDetailsStyle);
        this.builder.addAutoText(address1, (byte)1, (byte)3, AutoText.WIDTH_NOT_SET, busDetailsStyle);
        if (StringUtils.isNotBlank((String)address2)) {
            this.builder.addAutoText(address2, (byte)1, (byte)3, AutoText.WIDTH_NOT_SET, busDetailsStyle);
        }
        this.builder.addAutoText(phone, (byte)1, (byte)3, AutoText.WIDTH_NOT_SET, busDetailsStyle);
    }

    public Map<String, ?> addBusinessLogoDetailHeaderAndFooterTemplate() {
        String path = this.getTemplateFilePath();
        if (OrderMate.LOG.isDebugEnabled()) {
            OrderMate.LOG.debug("Trying " + path);
            URL resource = DynamicJasperHelper.class.getClassLoader().getResource(path);
            OrderMate.LOG.debug("resource = " + resource);
        }
        this.builder.setTemplateFile(path);
        return new HeaderSubReport().getParamsMap();
    }

    private String getTemplateFilePath() {
        String path = "";
        switch (this.reportTemplateFormat) {
            case A4Landscape: {
                path = LANDSCAPE_TEMPLATE_PATH;
                break;
            }
            case A4LandscapeNoHeader: {
                path = LANDSCAPE_NO_HEADER_TEMPLATE_PATH;
                break;
            }
            case A4Portrait: {
                path = PORTRAIT_TEMPLATE_PATH;
                break;
            }
            case A4PortraitNoHeader: {
                path = PORTRAIT_NO_HEADER_TEMPLATE_PATH;
                break;
            }
            default: {
                path = PORTRAIT_TEMPLATE_PATH;
            }
        }
        return path;
    }

    public void createPieChart(byte operation, DJGroup columnKey, AbstractColumn ... seriesColumn) throws ChartBuilderException {
        this.createPieChart(operation, columnKey.getColumnToGroupBy(), seriesColumn);
    }

    public void createPieChart(byte operation, PropertyColumn columnKey, AbstractColumn ... seriesColumns) throws ChartBuilderException {
        DJPie3DChartBuilder chartBuilder = new DJPie3DChartBuilder();
        chartBuilder.setX(20).setOperation(operation).setWidth(500).setHeight(500).setY(10).setCentered(false).setBackColor(Color.LIGHT_GRAY).setShowLegend(true).setPosition((byte)1).setTitleColor(Color.DARK_GRAY).setTitleFont(Font.ARIAL_BIG_BOLD).setSubtitleColor(Color.DARK_GRAY).setLegendColor(Color.DARK_GRAY).setLegendBackgroundColor(Color.WHITE).setLegendPosition((byte)2).setTitlePosition((byte)1).setLineStyle((byte)2).setLineWidth(1.0f).setLineColor(Color.DARK_GRAY).setPadding(5).setKey(columnKey).setDepthFactor(0.05).setCircular(true);
        for (AbstractColumn series : seriesColumns) {
            chartBuilder.addSerie(series);
        }
        this.addChart(chartBuilder.build());
    }

    public void createTimeSeriesChart(ColumnProperty groupProperty, List<String> names, DJTimeSeriesChartBuilder chartBuilder, byte calculation) throws ChartBuilderException {
        SafeReportBuilder subBuilder = this.builder;
        subBuilder.addField(groupProperty);
        SimpleColumn groupColumn = new SimpleColumn();
        groupColumn.setName(groupProperty.getProperty());
        groupColumn.setColumnProperty(groupProperty);
        ArrayList<SimpleColumn> reportableColumns = new ArrayList<SimpleColumn>();
        for (String string : names) {
            ColumnProperty columnProperty = new ColumnProperty(string, Double.class);
            subBuilder.addField(columnProperty);
            SimpleColumn column = new SimpleColumn();
            column.setName(string);
            column.setColumnProperty(columnProperty);
            reportableColumns.add(column);
        }
        DJGroup group = new DJGroup();
        group.setColumnToGroupBy((PropertyColumn)groupColumn);
        chartBuilder.setColumnGroup(group.getColumnToGroupBy());
        chartBuilder.setOperation(calculation);
        for (AbstractColumn abstractColumn : reportableColumns) {
            chartBuilder.addSerie(abstractColumn, abstractColumn.getName());
        }
        DJChart dJChart = chartBuilder.build();
        subBuilder.addChart(dJChart);
    }

    public Style createGhostTextStyle() {
        Style style = Style.createBlankStyle((String)"ghost");
        style.setTextColor(Color.GRAY);
        style.setFont(Font.ARIAL_SMALL);
        style.setPaddingTop(Integer.valueOf(3));
        return style;
    }

    public static class SafeReportBuilder
    extends DynamicReportBuilder {
        private volatile DynamicReport report;

        public synchronized DynamicReport build() {
            if (this.report == null) {
                this.report = super.build();
            }
            return this.report;
        }

        public List getConcatenatedReports() {
            return this.concatenatedReports;
        }
    }

    public static class GroupSpec {
        protected GroupLayout layout = GroupLayout.DEFAULT_WITH_HEADER;
        protected boolean showColumnNamesInPageHeader = false;
        protected final PropertyColumn groupColumn;
        protected Style groupedColumnStyle = new OrderMateDefaultReportStyle().getGroupedDetailStyle();

        public GroupSpec(PropertyColumn groupCol) {
            if (groupCol == null) {
                throw new NullPointerException("Column to group on should not be null");
            }
            this.groupColumn = groupCol;
        }

        public GroupSpec setLayout(GroupLayout newLayout) {
            this.layout = newLayout;
            return this;
        }

        public GroupSpec setShowColumnNames(boolean showColumnNames) {
            this.showColumnNamesInPageHeader = showColumnNames;
            return this;
        }

        public GroupSpec setGroupedColumnStyle(Style groupedStyle) {
            this.groupedColumnStyle = groupedStyle;
            return this;
        }

        public GroupLayout getLayout() {
            return this.layout;
        }

        public Style getGroupedColumnStyle() {
            return this.groupedColumnStyle;
        }
    }

    public class PropertyGroupSpec
    extends GroupSpec {
        protected final PropertiedObject.Property groupByProp;

        public PropertyGroupSpec(PropertiedObject.Property groupByProperty) {
            super(ReportBuilder.this.propertiesToColumns.get(groupByProperty));
            this.groupByProp = groupByProperty;
        }
    }

    protected static class ColumnSpec {
        protected Class clazz;
        protected String title;
        protected String name;
        protected String pattern;

        public ColumnSpec setClass(Class colClass) {
            this.clazz = colClass;
            return this;
        }

        public ColumnSpec setTitle(String colTitle) {
            this.title = colTitle;
            return this;
        }

        public ColumnSpec setName(String colName) {
            this.name = colName;
            return this;
        }

        public ColumnSpec setPattern(String colPattern) {
            this.pattern = colPattern;
            return this;
        }
    }

    public static class PropertyCalculation {
        public final PropertiedObject.Property property;
        public final DJCalculation calculation;

        public PropertyCalculation(PropertiedObject.Property prop, DJCalculation calc) {
            this.calculation = calc;
            this.property = prop;
        }
    }

    public static enum ChartCalculation {
        SUM,
        COUNT;


        public byte convertToDJChartCalculation() {
            if (this == SUM) {
                return 2;
            }
            if (this == COUNT) {
                return 1;
            }
            throw new IllegalArgumentException("must be one of SUM or COUNT");
        }
    }

    public static enum TemplateFormat {
        A4Portrait,
        A4Landscape,
        A4PortraitNoHeader,
        A4LandscapeNoHeader;

    }
}

