/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.dynamicjasper.customexpressions;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import au.com.ordermate.util.DateTimeUtils;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import ordermate.reports.dynamicjasper.customexpressions.CustomExpressionBuilder;

public class DateExpressionBuilder
extends CustomExpressionBuilder {
    DJValueFormatter formatter;

    public DateExpressionBuilder() {
        this(DateTimeUtils.getMediumDateFormat());
    }

    public DateExpressionBuilder(DateFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("Format cannot be null");
        }
        this.formatter = this.constructFormatter(format);
    }

    protected DJValueFormatter constructFormatter(DateFormat format) {
        return new DJDateFormatter(format);
    }

    @Override
    public CustomExpression buildExpressionForDisplay(final String fieldName) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return DateExpressionBuilder.this.getValueFormater().evaluate(fields.get(fieldName), fields, variables, parameters);
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }

    @Override
    public CustomExpression buildExpressionForCalculation(final String fieldName) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return ((Date)fields.get(fieldName)).getTime();
            }

            public String getClassName() {
                return Long.class.getName();
            }
        };
    }

    @Override
    public DJValueFormatter getValueFormater() {
        return this.formatter;
    }

    private static class DJDateFormatter
    implements DJValueFormatter {
        private DateFormat format;

        public DJDateFormatter(DateFormat format) {
            this.format = format;
        }

        public Object evaluate(Object value, Map fields, Map variables, Map parameters) {
            Date toFormat = null;
            if (value instanceof Long) {
                long fieldValue = (Long)value;
                toFormat = new Date(fieldValue);
            } else if (value instanceof Date) {
                toFormat = (Date)value;
            }
            if (toFormat == null) {
                return null;
            }
            return this.format.format(toFormat);
        }

        public String getClassName() {
            return String.class.getName();
        }
    }
}

