/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.dynamicjasper.customexpressions;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Map;
import ordermate.reports.dynamicjasper.customexpressions.CustomExpressionBuilder;

public final class PriceExpressionBuilder
extends CustomExpressionBuilder {
    @Override
    public CustomExpression buildExpressionForDisplay(final String fieldName) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return ((Price)fields.get(fieldName)).toString();
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }

    @Override
    public CustomExpression buildExpressionForCalculation(final String fieldName) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return BigDecimal.valueOf(((Price)fields.get(fieldName)).doubleValue());
            }

            public String getClassName() {
                return BigDecimal.class.getName();
            }
        };
    }

    @Override
    public DJValueFormatter getValueFormater() {
        return new DJPriceFormatter();
    }

    public static class DJPriceFormatter
    implements DJValueFormatter {
        public Object evaluate(Object value, Map fields, Map variables, Map parameters) {
            if (value instanceof Double) {
                if (!((Double)value).isNaN()) {
                    return new Price((Double)value, 1.0E-4).toString();
                }
                return Price.ZERO_DOLLAR;
            }
            return new Price((BigDecimal)value, 1.0E-4).toString();
        }

        public String getClassName() {
            return String.class.getName();
        }
    }
}

