/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.dynamicjasper.reportbuilder;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.thread.ThreadValidating;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import ordermate.OrderMate;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.DataSourceProvider;
import ordermate.reports.dynamicjasper.reportbuilder.DynamicReportProvider;
import ordermate.scheduler.AutoSender;

public abstract class AbstractReportProvider
implements DynamicReportProvider,
DataSourceProvider,
ThreadValidating {
    public static final String SALES_FILTER_DESCRIPTION = "Sales in this report are being filtered based on ";
    private final Map<String, Object> params = new HashMap<String, Object>();
    private boolean busy;
    private ReportProviderHelper helper;

    @Override
    public Map<String, Object> getParameters() {
        return this.params;
    }

    @Override
    public void addParam(String param, Object value) {
        this.params.put(param, value);
    }

    @Override
    public JasperPrint getReportPrint() throws JRException {
        try {
            String additionalFooterText;
            this.initTitle();
            JRRewindableDataSource datasource = this.getDataSource();
            if (datasource == null) {
                throw new NullPointerException("Datasource has not been set for this state.  Set the datasource before calling init");
            }
            if (datasource instanceof JREmptyDataSource) {
                OrderMate.LOG.warn("No datasource for jasper report. Perhaps no search values have been set?");
                return null;
            }
            DynamicReport report = this.getReport();
            if (report == null) {
                OrderMate.LOG.warn("getReport() returned null");
                return null;
            }
            HashMap<String, Object> currentParams = new HashMap<String, Object>(this.getParameters());
            if (!currentParams.containsKey("user")) {
                String userName = null;
                try {
                    userName = GuiApp.getAppComplex().getApplicationSecurity().getUser().getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (userName != null) {
                    currentParams.put("user", userName);
                }
            }
            if ((additionalFooterText = this.getAdditionalFooterText()) == null) {
                additionalFooterText = "";
            }
            currentParams.put("additional-footer", additionalFooterText);
            JasperReport compiledReport = DynamicJasperHelper.generateJasperReport((DynamicReport)report, (LayoutManager)new ClassicLayoutManager(), currentParams);
            return JasperFillManager.fillReport((JasperReport)compiledReport, currentParams, (JRDataSource)datasource);
        }
        catch (BuilderException djEx) {
            throw new JRException("Dynamic jasper exception building dynamic report", (Throwable)djEx);
        }
    }

    private void initTitle() throws BuilderException {
        Object title = this.getParameters().get("OM_TITLE_PARAM");
        if (title != null) {
            this.getBuilder().setTitle(title.toString());
        }
    }

    protected abstract DynamicReport getReport() throws BuilderException;

    @Override
    public abstract ReportBuilder getBuilder() throws BuilderException;

    protected abstract String getAdditionalFooterText();

    protected void sendEmailReport() {
        AutoSender.getInstance().doAutoSend(this.getClass());
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    @Override
    public void validateThreadState() {
        if (Thread.currentThread().isInterrupted()) {
            throw new IllegalStateException("ReportProvider - Thread is interrupted by another thread! ");
        }
    }

    public ReportBuilder createSubReportBuilder(String title, boolean detailSplit, boolean ignorePagination, List<String> columnNames) {
        ReportBuilder subReportBuilder = new ReportBuilder();
        subReportBuilder.getReportBuilder().setAllowDetailSplit(detailSplit);
        subReportBuilder.getReportBuilder().setIgnorePagination(false);
        subReportBuilder.setTitle(title);
        int size = columnNames.size();
        int iPosition = 0;
        for (String name : columnNames) {
            if (iPosition == 0 || iPosition == size - 1) {
                ColumnProperty prop = new ColumnProperty(name, String.class);
                SimpleColumn column = new SimpleColumn();
                column.setColumnProperty(prop);
                column.setName(name);
                column.setTitle(name);
                if (iPosition == 0) {
                    column.setHeaderStyle(JasperReportHelper.leftAlignStyle(subReportBuilder.getStyles().getColumnHeaderStyle()));
                    column.setStyle(JasperReportHelper.leftAlignStyle(subReportBuilder.getStyles().getColumnDetailStyle()));
                } else {
                    column.setHeaderStyle(JasperReportHelper.rightAlignStyle(subReportBuilder.getStyles().getColumnHeaderStyle()));
                    column.setStyle(JasperReportHelper.rightAlignStyle(subReportBuilder.getStyles().getColumnDetailStyle()));
                }
                subReportBuilder.getReportBuilder().addColumn((AbstractColumn)column);
            }
            ++iPosition;
        }
        return subReportBuilder;
    }

    public void hideColumnName(PropertyColumn column) {
        Integer WIDTH_ZERO = 0;
        String TITLE_EMPTY = "";
        column.setWidth(WIDTH_ZERO);
        column.setTitle("");
    }

    protected ReportProviderHelper getHelper() {
        if (this.helper == null) {
            this.helper = new ReportProviderHelper();
        }
        return this.helper;
    }
}

