/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.email;

import au.com.ordermate.gateway.GatewayProcessor;
import au.com.ordermate.message.Email;
import au.com.ordermate.message.MessageServer;
import au.com.ordermate.reports.ReportOutput;
import au.com.ordermate.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.config.report.ReportConfigSchedule;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.reports.maker.OMReportMakerFactory;
import ordermate.database.users.User;
import ordermate.integration.cloudback.OMOutgoingServiceResponse;
import ordermate.integration.cloudback.nudge.NudgeManager;
import org.apache.logging.log4j.Level;

class EmailReportIgor
implements GatewayProcessor<ReportConfigSchedule> {
    private static SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy");

    EmailReportIgor() {
    }

    @Override
    public boolean processIncoming(ReportConfigSchedule toProcess) {
        ReportConfig config = toProcess.getReportConfig();
        if (config == null) {
            OrderMate.LOG.info("Cannot send scheduled report, no configuration. Will delete.");
            toProcess.delete();
            return true;
        }
        if (!NudgeManager.isNudgeConfigured()) {
            MessageServer server = MessageServer.getServer();
            server.connect();
            if (!server.isSmtpConnected()) {
                OrderMate.LOG.info("Will not send Report Email, MessageServer is not connected");
                return true;
            }
        }
        List<String> emailAddresses = toProcess.getEmailList();
        List<User> users = toProcess.getUserList();
        if (emailAddresses.isEmpty() && users.isEmpty()) {
            OrderMate.LOG.info("No address found for report, not sending Report");
            return true;
        }
        File output = this.performReport(toProcess);
        if (output != null) {
            try {
                Email email = new Email();
                email.setText("Scheduled Report - " + config.getLabel());
                String emailSender = SystemProperty.getInstance().getEmailSender();
                if (!StringUtils.isEmpty(emailSender)) {
                    email.addSender(emailSender, emailSender);
                } else {
                    email.addSender("noreply@ordermate.com.au", "No Reply");
                }
                email.addAttachment(output);
                for (String nextEmail : emailAddresses) {
                    email.addToRecipient(nextEmail, nextEmail);
                }
                for (User user : users) {
                    String userEmail = user.getEmail();
                    if (userEmail != null && !userEmail.isEmpty()) {
                        email.addToRecipient(userEmail, user.getName());
                        continue;
                    }
                    OrderMate.LOG.error("Cannot send email to user " + user.getName());
                }
                email.setSubject(BusinessInfo.getInstance().getName() + " " + BusinessInfo.getInstance().getLocation() + " - " + config.getLabel());
                if (NudgeManager.isNudgeConfigured()) {
                    OMOutgoingServiceResponse nudgeResponse = NudgeManager.getInstance().sendEmail(email);
                    return nudgeResponse.isSuccessful();
                }
                boolean done = MessageServer.getServer().send(email.createMessage(MessageServer.getServer().getSession()));
                return done;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot export report to email ", (Throwable)ex);
            }
        } else {
            OrderMate.LOG.warn("There was nothing to email. Will not send to the recipient");
        }
        return false;
    }

    private File performReport(ReportConfigSchedule toProcess) {
        File file = new File(this.generateFileName(toProcess));
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.log(Level.WARN, "Cannot delete file, will attempt to export anyway: " + file, (Throwable)ex);
        }
        if (ReportOutput.CSV.equals((Object)toProcess.getReportOutput())) {
            this.doCsv(toProcess, file);
        } else if (ReportOutput.PDF.equals((Object)toProcess.getReportOutput())) {
            this.doPdf(toProcess, file);
        } else {
            throw new IllegalStateException("Cannot output the report to " + (Object)((Object)toProcess.getReportOutput()));
        }
        return file;
    }

    String generateFileName(ReportConfigSchedule toProcess) {
        String spacer = "_";
        StringBuilder sb = new StringBuilder();
        BusinessInfo info = BusinessInfo.getInstance();
        sb.append(StringUtils.removeSpecialCharacters(toProcess.getReportConfig().getLabel()));
        sb.append(spacer);
        sb.append(StringUtils.clampStringRetainWordsWithMaxChars(info.getName(), 12));
        if (!StringUtils.isEmpty(info.getLocation())) {
            sb.append(spacer);
            sb.append(StringUtils.clampStringRetainWordsWithMaxChars(info.getLocation(), 12));
        }
        sb.append(spacer);
        sb.append(format.format(new Date()));
        sb.append(".");
        sb.append(toProcess.getReportOutput().name().toLowerCase());
        return StringUtils.sanitiseStringForWindowsFileSystem(sb.toString());
    }

    private void doCsv(ReportConfigSchedule toProcess, File file) {
        ConfigurableReportMaker maker = OMReportMakerFactory.getInstance().createReportMaker(toProcess.getReportConfig());
        String output = maker.createCsv();
        if (output != null) {
            try {
                StringUtils.writeTextToFile(file, output);
            }
            catch (IOException ex) {
                OrderMate.LOG.error("cannot export csv report to file ", (Throwable)ex);
            }
        }
    }

    private void doPdf(ReportConfigSchedule toProcess, File file) {
        ConfigurableReportMaker maker = OMReportMakerFactory.getInstance().createReportMaker(toProcess.getReportConfig());
        if (maker == null) {
            OrderMate.LOG.error("cannot export report from config " + toProcess.getReportConfig().getLabel());
            return;
        }
        JasperPrint print = maker.createJasperReport();
        if (print != null) {
            try {
                JasperExportManager.exportReportToPdfFile((JasperPrint)print, (String)file.getName());
            }
            catch (JRException ex) {
                OrderMate.LOG.error("cannot export report, jasper error ", (Throwable)ex);
            }
        }
    }
}

