/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.email;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportConfigSchedule;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.schedule.Schedule;
import ordermate.reports.email.EmailReportTaskMaster;
import ordermate.scheduler.Scheduler;
import ordermate.scheduler.Task;

public class EmailReportTask
implements Task {
    public static final String NAME = "Email Report Task";
    private static Map<String, Schedule> scheduleMap;
    private ReportConfigSchedule report;

    @Override
    public void run() {
        if (this.report != null) {
            EmailReportTaskMaster.getInstance().emailReport(this.report);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setData(Object data) {
        this.report = PersistenceManager.getByID((Long)data, ReportConfigSchedule.class);
        if (this.report == null) {
            OrderMate.LOG.error("Cannot find report config of id " + data);
        }
    }

    public static void scheduleReport(ReportConfigSchedule nextSchedule) {
        try {
            String label = "Email " + nextSchedule.getID();
            Schedule oldSchedule = EmailReportTask.getScheduleFor(label);
            if (oldSchedule != null) {
                Scheduler.getInstance().endTimer(oldSchedule);
            }
            if (SystemState.ACTIVE_STATE.equals(nextSchedule.getSystemState())) {
                Schedule schedule = new Schedule();
                schedule.setLabel(label);
                schedule.setRecurrence(nextSchedule.getCronSchedule());
                schedule.setTask(NAME);
                schedule.setData(nextSchedule.getID());
                EmailReportTask.setScheduleFor(label, schedule);
                Scheduler.getInstance().startTimer(schedule);
                OrderMate.LOG.info("Report scheduled " + nextSchedule.getReportConfig().getLabel());
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot schedule report " + nextSchedule.getReportConfig().getLabel(), (Throwable)ex);
        }
    }

    private static Schedule getScheduleFor(String label) {
        if (scheduleMap != null) {
            return scheduleMap.get(label);
        }
        return null;
    }

    private static void setScheduleFor(String label, Schedule value) {
        if (scheduleMap == null) {
            scheduleMap = new HashMap<String, Schedule>();
        }
        scheduleMap.put(label, value);
    }

    public static void scheduleAllReports() {
        List<ReportConfigSchedule> schedules = PersistenceManager.getObjectList(ReportConfigSchedule.class, Query.select(ReportConfigSchedule.class).active(ReportConfigSchedule.class).toString());
        if (!schedules.isEmpty()) {
            for (ReportConfigSchedule nextSchedule : schedules) {
                try {
                    EmailReportTask.scheduleReport(nextSchedule);
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Couldn't schedule emailed report ", (Throwable)ex);
                }
            }
        }
    }
}

