/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.impl;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.reports.PrintDataReport;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.util.StringUtils;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import ordermate.OrderMate;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.DateSearcher;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.users.User;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.reportbuilder.DataSourceProvider;
import ordermate.reports.dynamicjasper.reportbuilder.DynamicReportProvider;
import ordermate.reports.printing.HeaderSubReport;

public abstract class OrdermateReportTemplateProvider<T extends PersistentObjectI>
extends PrintDataReport
implements DynamicReportProvider,
DataSourceProvider {
    private static final String KEY_REPORT_SUBTITLE = "report_subtitle";
    private static final String KEY_REPORT_TITLE = "report_title";
    public static final String TEMPLATES_URL = "/ordermate/reports/printing/";
    static final String KEY_STYLE_TEMPLATE_URL = "STYLE_TEMPLATE_URL";
    private static final String STYLE_TEMPLATE = "OmorphosStyleTemplate.jrtx";
    static final String KEY_HEADER_TEMPLATE_URL = "HEADER_SUBREPORT_URL";
    private static final String LETTERHEAD_SUBREPORT = "letterheadTitleSubReport.jasper";
    private User user;
    private HeaderSubReport headerSubReport;
    private final DateSearcher<T> searcher;
    private PeriodReportAdapter periodReportAdapter;
    private boolean busy;

    public OrdermateReportTemplateProvider(String newFileName, DateSearcher<T> searcher, PeriodReportAdapter adapter) {
        super(newFileName, "");
        this.searcher = searcher;
        this.periodReportAdapter = adapter;
    }

    @Override
    public void addParam(String param, Object value) {
        this.addReportParam(param, value);
    }

    @Override
    public Map getParameters() {
        return this.getReportParams();
    }

    @Override
    public JasperPrint getReportPrint() throws JRException {
        this.setPrintData(this.searcher.search());
        this.injectParameters();
        this.generate();
        return this.getReport();
    }

    protected Map<String, Object> injectParameters() {
        String additionalFooterText;
        this.addParam(KEY_REPORT_TITLE, this.getReportTitle());
        this.addParam(KEY_REPORT_SUBTITLE, this.getSubTitle());
        if (this.getUser() != null) {
            this.addParam("user", this.getUser().getName());
        }
        if ((additionalFooterText = this.getAdditionalFooterText()) == null) {
            additionalFooterText = "";
        }
        this.addParam("additional_footer", additionalFooterText);
        URL styleResourceURL = this.getResource("/ordermate/reports/printing/OmorphosStyleTemplate.jrtx");
        this.addParam(KEY_STYLE_TEMPLATE_URL, styleResourceURL);
        URL headerTemplateURL = this.getResource("/ordermate/reports/printing/letterheadTitleSubReport.jasper");
        this.addParam(KEY_HEADER_TEMPLATE_URL, headerTemplateURL);
        Map<String, Object> reportParams = this.getReportParams();
        if (this.headerSubReport == null) {
            this.headerSubReport = new HeaderSubReport();
        }
        reportParams.putAll(this.headerSubReport.getParamsMap());
        this.addSubReport(this.headerSubReport);
        return reportParams;
    }

    private URL getResource(String resource) {
        URL styleResourceURL = OrdermateReportTemplateProvider.class.getResource(resource);
        if (styleResourceURL == null) {
            String message = "Unable to find " + resource;
            OrderMate.LOG.error(message);
            throw new IllegalStateException(message);
        }
        return styleResourceURL;
    }

    public abstract String getReportTitle();

    protected String getSubTitle() {
        String time;
        StringBuilder SB = new StringBuilder(this.getDateString());
        TimeSearchFilter timeFilter = this.getTimeFilter();
        if (timeFilter != null && !StringUtils.isEmpty(time = timeFilter.getDisplayableTime())) {
            SB.append(" - ").append(time);
        }
        return SB.toString();
    }

    protected abstract TimeSearchFilter getTimeFilter();

    protected String getDateString() {
        IRangedSearchFilter<Date> dateRangeFilter = this.searcher.getTradingDayDateRangeFilter();
        IRangedSearchFilter dateRangeAdapter = null;
        try {
            dateRangeAdapter = (IRangedSearchFilter)this.searcher.getClass().getMethod("getTradingDayDateRangeAdapter", null).invoke(this.searcher, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String dateString = this.periodReportAdapter == null && dateRangeAdapter == null ? TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(dateRangeFilter) : (this.periodReportAdapter == null && dateRangeAdapter != null ? TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(dateRangeAdapter) : (dateRangeAdapter != null ? this.periodReportAdapter.formatTradingDayRangeForDisplay(dateRangeFilter.getStart(), dateRangeFilter.getEnd(), (Date)dateRangeAdapter.getEnd()) : this.periodReportAdapter.formatRangeForDisplay(dateRangeFilter.getStart(), dateRangeFilter.getEnd())));
        return dateString;
    }

    protected DateSearcher<T> getSearcher() {
        return this.searcher;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    protected abstract String getAdditionalFooterText();

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public void setBusy(boolean busy) {
        this.busy = busy;
    }
}

