/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.impl;

import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.reports.dynamicjasper.reportbuilder.DataSourceProvider;

public class SearcherDataSourceProvider<T extends ObjectQuerySearcher>
implements DataSourceProvider {
    private final PropertiedObject.Property orderingProperty;
    private final T searcher;
    private List reportList;

    public SearcherDataSourceProvider(T theSearcher) {
        this(theSearcher, null);
    }

    public SearcherDataSourceProvider(T theSearcher, PropertiedObject.Property toOrderBy) {
        this.searcher = theSearcher;
        this.orderingProperty = toOrderBy;
    }

    public List getCurrentReportList() {
        return this.reportList;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        this.reportList = this.getReportList();
        if (this.orderingProperty != null) {
            this.orderByProperty(this.reportList);
        }
        return new JRBeanCollectionDataSource((Collection)this.reportList);
    }

    public final T getSearch() {
        return this.searcher;
    }

    protected List getReportList() {
        if (!this.getSearch().hasSearchValues()) {
            return new ArrayList();
        }
        return this.getSearch().search();
    }

    private void orderByProperty(List reportList) {
        Collections.sort(reportList, new PropertyComparator(this.orderingProperty));
    }

    private static class PropertyComparator
    implements Comparator {
        private PropertiedObject.Property property;

        public PropertyComparator(PropertiedObject.Property comparisonProperty) {
            this.property = comparisonProperty;
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 == null) {
                throw new IllegalArgumentException("Argument one cannot be null");
            }
            if (arg1 == null) {
                throw new IllegalArgumentException("Argument two cannot be null");
            }
            PersistentObject obj1 = (PersistentObject)arg0;
            PersistentObject obj2 = (PersistentObject)arg1;
            Object propValue1 = obj1.getPropertyValue(this.property);
            Object propValue2 = obj2.getPropertyValue(this.property);
            if (propValue1 instanceof Comparable) {
                return ((Comparable)propValue1).compareTo(propValue2);
            }
            return propValue1.toString().compareTo(propValue2.toString());
        }
    }
}

