/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.labels;

import au.com.ordermate.reports.PrintData;
import au.com.ordermate.reports.PrintDataReport;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.inventory.ItemSummary;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import org.apache.commons.lang.StringEscapeUtils;

public class ShelfLabelsReport
extends PrintDataReport {
    private static final String DEFAULT_FONT = "Arial";
    private static final int DEFAULT_SIZE = 14;
    private static final int MAX_WIDTH = 135;

    public ShelfLabelsReport(List<ItemSummary> itemSummaries, String reportFileName) {
        super(reportFileName, "Shelf Label Reports Path");
        ReportProperty fontSizeProp = ReportProperty.find(ReportGroup.ShelfLabel, ShelfLabelProperty.FontSize.name());
        ReportProperty fontNameProp = ReportProperty.find(ReportGroup.ShelfLabel, ShelfLabelProperty.FontName.name());
        ReportProperty includeSizeProp = ReportProperty.find(ReportGroup.ShelfLabel, ShelfLabelProperty.IncludeSize.name());
        ReportProperty logoFileProp = ReportProperty.find(ReportGroup.ShelfLabel, ShelfLabelProperty.LogoFile.name());
        boolean incSize = includeSizeProp == null || includeSizeProp.getBooleanValue(Boolean.TRUE) != false;
        String fontName = fontNameProp == null ? DEFAULT_FONT : fontNameProp.getStringValue(DEFAULT_FONT);
        int fontSize = fontSizeProp == null ? 14 : fontSizeProp.getIntValue(14);
        ImageIcon logo = this.getLogo(logoFileProp == null ? null : logoFileProp.getStringValue(null));
        Font baseFont = new Font(fontName, 0, fontSize);
        ArrayList<ItemSummaryPrintData> printData = new ArrayList<ItemSummaryPrintData>(itemSummaries.size());
        for (ItemSummary summary : itemSummaries) {
            String name = summary.getName();
            if (incSize) {
                name = name + "\r\n" + summary.getSize().getLabel();
            }
            printData.add(new ItemSummaryPrintData(StringEscapeUtils.escapeHtml((String)name), this.getPrice(summary), this.getFontSize(summary.getName(), baseFont)));
        }
        this.setPrintData(printData);
        this.addReportParam("logo", logo);
        this.addReportParam("fontName", fontName);
        this.addReportParam("baseFontSize", fontSize);
        this.addReportParam("topMargin", 24);
    }

    private int getFontSize(String name, Font baseFont) {
        double width = baseFont.getStringBounds(name, new FontRenderContext(null, false, false)).getWidth();
        if (width > 135.0) {
            return baseFont.getSize() - 2;
        }
        return baseFont.getSize();
    }

    private String getPrice(ItemSummary summary) {
        return NumberFormat.getCurrencyInstance().format(!SystemProperty.getInstance().isExTax() ? summary.getPrice().doubleValue() : summary.getPriceExTax().doubleValue());
    }

    private ImageIcon getLogo(String logoDir) {
        if (!StringUtils.isEmpty(logoDir)) {
            return IconLoader.get(logoDir);
        }
        BusinessInfo info = BusinessInfo.getInstance();
        if (info.getLabelLogo() != null && !info.getLabelLogo().equalsIgnoreCase("")) {
            return IconLoader.get(info.getLabelLogo());
        }
        return IconLoader.get("/ordermate/images/critical.gif");
    }

    public static class ItemSummaryPrintData
    implements PrintData {
        private final String name;
        private final int fontSize;
        private final String itemPrice;

        private ItemSummaryPrintData(String name, String price, int fontSize) {
            this.name = name;
            this.itemPrice = price;
            this.fontSize = fontSize;
        }

        public String getName() {
            return this.name;
        }

        public String getPrice() {
            return this.itemPrice;
        }

        public int getFontSize() {
            return this.fontSize;
        }
    }

    private static enum ShelfLabelProperty {
        FontSize,
        FontName,
        IncludeSize,
        LogoFile;

    }
}

