/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.printing;

import au.com.ordermate.util.Price;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.activitystatement.ActivityStatement;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.misc.ConfigReportFile;
import ordermate.internationalization.Internationalization;
import ordermate.reports.printing.DebtorStatementReport;

public class ActivityStatementReport
extends DebtorStatementReport
implements Serializable {
    public static final String DEFAULT_REPORT_FILE = "/ordermate/reports/printing/ActivityStatementReport.jrxml";
    private ActivityStatement stmt;

    public ActivityStatementReport() {
        super(ConfigReportFile.getInstance().getActivityStatementReport() == null || ConfigReportFile.getInstance().getActivityStatementReport().isEmpty() ? DEFAULT_REPORT_FILE : ConfigReportFile.getInstance().getActivityStatementReport(), "Activity Statement Report Path");
    }

    public ActivityStatement getStatement() {
        return this.stmt;
    }

    public void setStatement(ActivityStatement statement) {
        this.stmt = statement;
        if (this.stmt == null) {
            throw new IllegalArgumentException("The ActivityStatement argument is null. Cannot print the report.");
        }
        AbstractDebtor debtor = this.stmt.getDebtor();
        this.setupHeader(debtor);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
        this.addReportParam("selection", "From: " + df.format(this.stmt.getFrom()) + " to " + df.format(this.stmt.getTo()));
        List<DebtorSale> debtorSales = debtor.getUnpaidSales();
        Price taxSum = Price.ZERO;
        if (debtorSales.size() > 0) {
            for (int i = 0; i < debtorSales.size(); ++i) {
                DebtorSale saleTemp = debtorSales.get(i);
                taxSum = saleTemp.calculateTAX(saleTemp.getTotal()).add(taxSum);
            }
        }
        this.addReportParam("openingBalance", new Double(this.stmt.getOpeningBalance().doubleValue()));
        this.addReportParam("summaryCurrent", new Double(this.stmt.getAmountCurrent().doubleValue()));
        this.addReportParam("summaryThirtyDays", new Double(this.stmt.getAmountAt30().doubleValue()));
        this.addReportParam("summarySixtyDays", new Double(this.stmt.getAmountAt60().doubleValue()));
        this.addReportParam("summarySixtyPlusDays", new Double(this.stmt.getAmountAt60Plus().doubleValue()));
        this.addReportParam("summaryAmountDue", new Double(this.stmt.getAmountDue().doubleValue()));
        this.addReportParam("dollarSign", Internationalization.getLiteralFor("DOLLAR_SIGN"));
        DebtorSale saleTemp = debtorSales.get(0);
        if (saleTemp != null) {
            this.addReportParam("summaryAmountTax", taxSum.doubleValue());
        } else {
            this.addReportParam("summaryAmountTax", 0.0);
        }
        this.setPrintData(this.stmt.getPrintData());
    }
}

