/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.printing;

import au.com.ordermate.reports.PrintDataReport;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.finance.DebtorTransactionGroupAdapter;
import ordermate.database.print.FinanceTransactionPrintData;
import ordermate.internationalization.Internationalization;
import ordermate.reports.printing.HeaderSubReport;
import ordermate.reports.printing.TransactionsSubReport;

public class DebtorPaymentReport
extends PrintDataReport {
    private static final String KEY_DATE = "date";
    private static final String KEY_CUSTOMER = "customer";
    private static final String KEY_PHONE = "secondaryPhone";
    private static final String KEY_TRANSACTIONS = "transactions";
    private static final String KEY_TOTAL = "total";
    private static final String KEY_DOLLAR_SIGN = "dollarSign";
    private DebtorTransactionGroupAdapter DTGAdapter;
    private TransactionsSubReport transactionReport;

    public DebtorPaymentReport(DebtorTransactionGroupAdapter groupAdapter) {
        super("DebtorPaymentReportA4.jrxml", "Debtor Payment Report A4 Path");
        this.DTGAdapter = groupAdapter;
        this.addSubReport(new HeaderSubReport());
        this.transactionReport = new TransactionsSubReport();
        this.addSubReport(this.transactionReport);
        this.setupReport();
    }

    @Override
    public void generate() throws JRException {
        super.generate();
    }

    public void setupReport() {
        Date date = new Date();
        this.addReportParam(KEY_DATE, date);
        double total = this.DTGAdapter.getTotal().doubleValue();
        this.addReportParam(KEY_TOTAL, new Double(total));
        String customer = this.DTGAdapter.getLabel();
        if (this.DTGAdapter.getCustomer() != null) {
            customer = this.DTGAdapter.getCustomer().getName();
            String phone = this.DTGAdapter.getCustomer().getPhoneNumber();
            this.addReportParam(KEY_PHONE, phone);
        }
        this.addReportParam(KEY_CUSTOMER, customer);
        List<FinanceTransactionPrintData> transactions = FinanceTransactionPrintData.getFinanceTransactionPrintData(this.DTGAdapter.getFinanceTransactions());
        this.addReportParam(KEY_TRANSACTIONS, new JRBeanCollectionDataSource(transactions));
        this.addReportParam(KEY_DOLLAR_SIGN, Internationalization.getLiteralFor("DOLLAR_SIGN"));
        ArrayList<DebtorTransactionGroupAdapter> list = new ArrayList<DebtorTransactionGroupAdapter>();
        list.add(this.DTGAdapter);
        this.setPrintData(list);
    }
}

