/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.printing;

import au.com.ordermate.reports.PrintDataReport;
import java.util.Date;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.CustomerDebtorInterface;
import ordermate.database.finance.debtors.DebtorConfig;
import ordermate.reports.printing.HeaderSubReport;

public abstract class DebtorStatementReport
extends PrintDataReport {
    public DebtorStatementReport(String newFileName, String property) {
        super(newFileName, property);
        this.addSubReport(new HeaderSubReport());
    }

    protected void setupHeader(AbstractDebtor debtor) {
        String customerString;
        if (debtor.hasCustomer()) {
            CustomerDebtorInterface customerDebtor = (CustomerDebtorInterface)((Object)debtor);
            customerString = CustomerDebtorInterface.Helper.getPrintString(customerDebtor);
        } else {
            customerString = debtor.getLabel();
        }
        this.addReportParam("customer", customerString);
        this.addReportParam("statementDate", new Date());
        this.addReportParam("dateCol", DebtorConfig.getInstance().getStmtColTitleSaleDate());
        this.addReportParam("invoiceCol", DebtorConfig.getInstance().getStmtColTitleInvoiceNum());
        this.addReportParam("descriptionCol", DebtorConfig.getInstance().getStmtColTitleDescription());
        this.addReportParam("chargesCol", DebtorConfig.getInstance().getStmtColTitleCharges());
        this.addReportParam("paymentCol", DebtorConfig.getInstance().getStmtColTitlePayments());
        this.addReportParam("balanceCol", DebtorConfig.getInstance().getStmtColTitleBalance());
    }
}

