/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.printing;

import au.com.ordermate.reports.PrintDataReport;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.DebtorsSummary;
import ordermate.database.print.DebtorSummaryPrintData;
import ordermate.internationalization.Internationalization;
import ordermate.reports.printing.HeaderSubReport;

public class DebtorsSummaryReport
extends PrintDataReport {
    public static final String DEFAULT_JRXML_FILENAME = "DebtorsSummaryReport.jrxml";

    public DebtorsSummaryReport(String newFileName) {
        super(newFileName, "Debtors Summary Report Path");
        this.addSubReport(new HeaderSubReport());
    }

    public DebtorsSummaryReport(String newFileName, List debtors) {
        this(newFileName);
        this.setDebtors(debtors);
    }

    public void setDebtors(List debtors) {
        this.addReportParam("reportDate", new Date());
        DebtorsSummary summary = DebtorsSummary.summarize(debtors);
        this.addReportParam("totCurrent", new Double(summary.getCurrent().doubleValue()));
        this.addReportParam("totThirtyDays", new Double(summary.getThirtyDays().doubleValue()));
        this.addReportParam("totSixtyDays", new Double(summary.getSixtyDays().doubleValue()));
        this.addReportParam("totSixtyPlusDays", new Double(summary.getSixtyPlusDays().doubleValue()));
        this.addReportParam("totOutstanding", new Double(summary.getOutstanding().doubleValue()));
        this.addReportParam("dollarSign", Internationalization.getLiteralFor("DOLLAR_SIGN"));
        this.setPrintData(DebtorSummaryPrintData.getDebtorSummaryPrintData(debtors));
    }
}

